/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;

public class ParticleBlur
extends SpriteTexturedParticle {
    private static final int MAX_VIEW_DISTANCE = 30;
    private static final RenderType RENDER_TYPE = new RenderType();
    protected float originalScale;
    protected float scaleLife;

    public ParticleBlur(ParticleBlurData data, ClientWorld world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z, motionX, motionY, motionZ);
        this.field_187129_i = motionX;
        this.field_187130_j = motionY;
        this.field_187131_k = motionZ;
        this.field_70552_h = data.getRed();
        this.field_70553_i = data.getGreen();
        this.field_70551_j = data.getBlue();
        this.field_82339_as = 0.9f;
        this.field_70545_g = 0.0f;
        this.originalScale = (this.field_187136_p.nextFloat() * 0.5f + 0.5f) * 2.0f * data.getScale();
        this.field_70547_e = (int)((this.field_187136_p.nextFloat() * 0.33f + 0.66f) * data.getAgeMultiplier());
        this.func_187115_a(0.01f, 0.01f);
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.scaleLife = (float)((double)this.field_70547_e / 2.5);
        this.validateDistance();
    }

    private void validateDistance() {
        ClientPlayerEntity renderentity = Minecraft.func_71410_x().field_71439_g;
        int visibleDistance = 30;
        if (Minecraft.func_71410_x().field_71474_y.field_238330_f_.func_238162_a_() == 0) {
            visibleDistance /= 2;
        }
        if (renderentity == null || renderentity.func_70092_e(this.field_187126_f, this.field_187127_g, this.field_187128_h) > (double)(visibleDistance * visibleDistance)) {
            this.field_70547_e = 0;
        }
    }

    public IParticleRenderType func_217558_b() {
        return RENDER_TYPE;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.field_187130_j -= 0.04 * (double)this.field_70545_g;
        this.field_187126_f += this.field_187129_i;
        this.field_187127_g += this.field_187130_j;
        this.field_187128_h += this.field_187131_k;
        this.field_187129_i *= (double)0.98f;
        this.field_187130_j *= (double)0.98f;
        this.field_187131_k *= (double)0.98f;
    }

    protected int func_189214_a(float partialTicks) {
        return 0xF000F0;
    }

    public void setGravity(float particleGravity) {
        this.field_70545_g = particleGravity;
    }

    public float func_217561_b(float p_217561_1_) {
        float agescale = (float)this.field_70546_d / this.scaleLife;
        if (agescale > 1.0f) {
            agescale = 2.0f - agescale;
        }
        this.field_70544_f = this.originalScale * agescale * 0.5f;
        return this.field_70544_f;
    }

    public static class RenderType
    implements IParticleRenderType {
        public void func_217600_a(BufferBuilder bufferBuilder, TextureManager textureManager) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)1);
            RenderSystem.alphaFunc((int)516, (float)0.003921569f);
            RenderSystem.disableLighting();
            textureManager.func_110577_a(AtlasTexture.field_215262_g);
            textureManager.func_229267_b_(AtlasTexture.field_215262_g).setBlurMipmap(true, false);
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        }

        public void func_217599_a(Tessellator tessellator) {
            tessellator.func_78381_a();
            Minecraft.func_71410_x().field_71446_o.func_229267_b_(AtlasTexture.field_215262_g).restoreLastBlurMipmap();
            RenderSystem.alphaFunc((int)516, (float)0.1f);
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
        }
    }
}

