/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure;

import java.util.Random;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.treasure.function.EnchantedBook;
import xiroc.dungeoncrawl.dungeon.treasure.function.MaterialBlocks;
import xiroc.dungeoncrawl.dungeon.treasure.function.RandomItem;
import xiroc.dungeoncrawl.dungeon.treasure.function.RandomPotion;
import xiroc.dungeoncrawl.dungeon.treasure.function.Shield;
import xiroc.dungeoncrawl.dungeon.treasure.function.SuspiciousStew;
import xiroc.dungeoncrawl.theme.Theme;

public class Loot {
    public static final String LOOT_LEVEL = "loot_level";
    public static final LootFunctionType ENCHANTED_BOOK = new LootFunctionType((ILootSerializer)new EnchantedBook.Serializer());
    public static final LootFunctionType MATERIAL_BLOCKS = new LootFunctionType((ILootSerializer)new MaterialBlocks.Serializer());
    public static final LootFunctionType RANDOM_ITEM = new LootFunctionType((ILootSerializer)new RandomItem.Serializer());
    public static final LootFunctionType RANDOM_POTION = new LootFunctionType((ILootSerializer)new RandomPotion.Serializer());
    public static final LootFunctionType SHIELD = new LootFunctionType((ILootSerializer)new Shield.Serializer());
    public static final LootFunctionType SUSPICIOUS_STEW = new LootFunctionType((ILootSerializer)new SuspiciousStew.Serializer());
    public static final ResourceLocation CHEST_STAGE_1 = DungeonCrawl.locate("chests/stage_1");
    public static final ResourceLocation CHEST_STAGE_2 = DungeonCrawl.locate("chests/stage_2");
    public static final ResourceLocation CHEST_STAGE_3 = DungeonCrawl.locate("chests/stage_3");
    public static final ResourceLocation CHEST_STAGE_4 = DungeonCrawl.locate("chests/stage_4");
    public static final ResourceLocation CHEST_STAGE_5 = DungeonCrawl.locate("chests/stage_5");
    public static final ResourceLocation WITHER_SKELETON = DungeonCrawl.locate("monster_overrides/wither_skeleton");

    private static void registerLootFunctionType(ResourceLocation registryName, LootFunctionType type) {
        Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)registryName, (Object)type);
    }

    public static void init() {
        Loot.registerLootFunctionType(DungeonCrawl.locate("enchanted_book"), ENCHANTED_BOOK);
        Loot.registerLootFunctionType(DungeonCrawl.locate("material_blocks"), MATERIAL_BLOCKS);
        Loot.registerLootFunctionType(DungeonCrawl.locate("random_item"), RANDOM_ITEM);
        Loot.registerLootFunctionType(DungeonCrawl.locate("random_potion"), RANDOM_POTION);
        Loot.registerLootFunctionType(DungeonCrawl.locate("shield"), SHIELD);
        Loot.registerLootFunctionType(DungeonCrawl.locate("suspicious_stew"), SUSPICIOUS_STEW);
    }

    public static void setLoot(IWorld world, BlockPos pos, LockableLootTileEntity tile, ResourceLocation lootTable, Theme theme, Theme.SecondaryTheme secondaryTheme, Random rand) {
        LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)rand, (BlockPos)pos, (ResourceLocation)lootTable);
        Loot.setLootInformation(tile.getTileData(), theme, secondaryTheme);
    }

    public static ResourceLocation getLootTable(int lootLevel, Random rand) {
        switch (lootLevel) {
            case 0: {
                return (double)rand.nextFloat() < 0.1 ? LootTables.field_186430_l : CHEST_STAGE_1;
            }
            case 1: {
                return (double)rand.nextFloat() < 0.1 ? LootTables.field_186422_d : CHEST_STAGE_2;
            }
            case 2: {
                return (double)rand.nextFloat() < 0.1 ? LootTables.field_186422_d : CHEST_STAGE_3;
            }
            case 3: {
                return (double)rand.nextFloat() < 0.1 ? LootTables.field_186427_i : CHEST_STAGE_4;
            }
            case 4: {
                return (double)rand.nextFloat() < 0.1 ? LootTables.field_186427_i : CHEST_STAGE_5;
            }
        }
        return CHEST_STAGE_5;
    }

    public static void setLootInformation(CompoundNBT nbt, Theme theme, Theme.SecondaryTheme secondaryTheme) {
        CompoundNBT data = new CompoundNBT();
        data.func_74778_a("theme", theme.getKey().toString());
        data.func_74778_a("secondaryTheme", secondaryTheme.getKey().toString());
        nbt.func_218657_a("dungeoncrawl", (INBT)data);
    }

    public static Tuple<Theme, Theme.SecondaryTheme> getLootInformation(CompoundNBT nbt) {
        CompoundNBT data = nbt.func_74775_l("dungeoncrawl");
        return new Tuple((Object)Theme.getTheme(new ResourceLocation(data.func_74779_i("theme"))), (Object)Theme.getSecondaryTheme(new ResourceLocation(data.func_74779_i("secondaryTheme"))));
    }
}

