/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import java.util.Random;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import xiroc.dungeoncrawl.dungeon.block.provider.IBlockStateProvider;
import xiroc.dungeoncrawl.theme.Theme;

public class PlacementBehaviour {
    public static final PlacementBehaviour NON_SOLID = new PlacementBehaviour((world, pos, rand) -> false);
    public static final PlacementBehaviour SOLID = new PlacementBehaviour((world, pos, rand) -> true);
    public static final PlacementBehaviour RANDOM_IF_SOLID_NEARBY = new PlacementBehaviour((world, pos, rand) -> {
        if (PlacementBehaviour.isSolid(world, pos.func_177978_c()) || PlacementBehaviour.isSolid(world, pos.func_177974_f()) || PlacementBehaviour.isSolid(world, pos.func_177968_d()) || PlacementBehaviour.isSolid(world, pos.func_177976_e())) {
            return rand.nextFloat() < 0.6f;
        }
        return false;
    });
    private final PlacementFunction function;
    @Nullable
    public final BiFunction<Theme, Theme.SecondaryTheme, IBlockStateProvider> airBlock;

    public PlacementBehaviour(PlacementFunction function) {
        this(function, null);
    }

    public PlacementBehaviour(PlacementFunction function, BiFunction<Theme, Theme.SecondaryTheme, IBlockStateProvider> airBlock) {
        this.function = function;
        this.airBlock = airBlock;
    }

    public PlacementBehaviour withAirBlock(BiFunction<Theme, Theme.SecondaryTheme, IBlockStateProvider> airBlock) {
        return new PlacementBehaviour(this.function, airBlock);
    }

    public boolean isSolid(IWorld world, BlockPos pos, Random rand) {
        return this.function.isSolid(world, pos, rand);
    }

    private static boolean isSolid(IWorld world, BlockPos pos) {
        if (world.func_217354_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) {
            return world.func_180495_p(pos).func_200132_m() || world.func_180495_p(pos.func_177977_b()).func_200132_m();
        }
        return false;
    }

    public static interface PlacementFunction {
        public boolean isSolid(IWorld var1, BlockPos var2, Random var3);
    }
}

