/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.datastructure.IntReferenceHolderSupplied;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.network.IEnergyNetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.block.BlockCoalGenerator;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.core.helper.EnergyHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.tileentity.TileCableConnectableInventory;
import org.cyclops.integrateddynamics.inventory.container.ContainerCoalGenerator;
import org.cyclops.integrateddynamics.network.CoalGeneratorNetworkElement;

public class TileCoalGenerator
extends TileCableConnectableInventory
implements IEnergyStorage,
INamedContainerProvider {
    public static final int INVENTORY_SIZE = 1;
    public static final int MAX_PROGRESS = 13;
    public static final int ENERGY_PER_TICK = 20;
    public static final int SLOT_FUEL = 0;
    @NBTPersist
    private int currentlyBurningMax;
    @NBTPersist
    private int currentlyBurning;

    public TileCoalGenerator() {
        super(RegistryEntries.TILE_ENTITY_COAL_GENERATOR, 1, 64);
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, LazyOptional.of(() -> new NetworkElementProviderSingleton(){

            @Override
            public INetworkElement createNetworkElement(World world, BlockPos blockPos) {
                return new CoalGeneratorNetworkElement(DimPos.of((World)world, (BlockPos)blockPos));
            }
        }));
        this.addCapabilityInternal(CapabilityEnergy.ENERGY, LazyOptional.of(() -> this));
    }

    public LazyOptional<IEnergyNetwork> getEnergyNetwork() {
        return NetworkHelpers.getEnergyNetwork(this.getNetwork());
    }

    public void updateBlockState() {
        boolean wasBurning = (Boolean)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((Property)BlockCoalGenerator.LIT);
        boolean isBurning = this.isBurning();
        if (isBurning != wasBurning) {
            this.func_145831_w().func_175656_a(this.func_174877_v(), (BlockState)this.func_145831_w().func_180495_p(this.func_174877_v()).func_206870_a((Property)BlockCoalGenerator.LIT, (Comparable)Boolean.valueOf(isBurning)));
        }
    }

    public int getProgress() {
        float current = this.currentlyBurning;
        float max = this.currentlyBurningMax;
        if (max == 0.0f) {
            return -1;
        }
        return Math.round(current / max * 13.0f);
    }

    public boolean isBurning() {
        return this.currentlyBurning < this.currentlyBurningMax;
    }

    public boolean canAddEnergy(int energy) {
        IEnergyNetwork network = (IEnergyNetwork)this.getEnergyNetwork().orElse(null);
        if (network != null && (Long)network.getChannel(0).insert((Object)energy, true) == 0L) {
            return true;
        }
        return this.addEnergyFe(energy, true) == energy;
    }

    protected int addEnergy(int energy) {
        IEnergyNetwork network = (IEnergyNetwork)this.getEnergyNetwork().orElse(null);
        int toFill = energy;
        if (network != null) {
            toFill = Helpers.castSafe((long)((Long)network.getChannel(0).insert((Object)toFill, false)));
        }
        if (toFill > 0) {
            toFill -= this.addEnergyFe(toFill, false);
        }
        return energy - toFill;
    }

    protected int addEnergyFe(int energy, boolean simulate) {
        return EnergyHelpers.fillNeigbours(this.func_145831_w(), this.func_174877_v(), energy, simulate);
    }

    public static int getFuelTime(ItemStack itemStack) {
        int ret = itemStack.getBurnTime();
        return ForgeEventFactory.getItemBurnTime((ItemStack)itemStack, (int)(ret == -1 ? AbstractFurnaceTileEntity.func_214001_f().getOrDefault(itemStack.func_77973_b(), 0) : ret));
    }

    @Override
    protected void updateTileEntity() {
        super.updateTileEntity();
        if (!this.func_145831_w().field_72995_K && (!this.getInventory().func_70301_a(0).func_190926_b() || this.isBurning()) && this.canAddEnergy(20)) {
            if (this.isBurning()) {
                if (this.currentlyBurning++ >= this.currentlyBurningMax) {
                    this.currentlyBurning = 0;
                    this.currentlyBurningMax = 0;
                }
                int toFill = 20;
                this.addEnergy(toFill);
                this.func_70296_d();
            }
            if (!this.isBurning()) {
                ItemStack fuel;
                if (TileCoalGenerator.getFuelTime(this.getInventory().func_70301_a(0)) > 0 && !(fuel = this.getInventory().func_70298_a(0, 1)).func_190926_b()) {
                    if (this.getInventory().func_70301_a(0).func_190926_b()) {
                        this.getInventory().func_70299_a(0, fuel.func_77973_b().getContainerItem(fuel));
                    }
                    this.currentlyBurningMax = TileCoalGenerator.getFuelTime(fuel);
                    this.currentlyBurning = 0;
                    this.func_70296_d();
                }
                this.updateBlockState();
            }
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return 0;
    }

    public int getMaxEnergyStored() {
        return 0;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("block.integrateddynamics.coal_generator");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerCoalGenerator(id, playerInventory, (IInventory)this.getInventory(), (IntReferenceHolder)new IntReferenceHolderSupplied(this::getProgress));
    }
}

