/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IModelData;
import org.cyclops.integrateddynamics.api.client.model.IVariableModelBaked;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IValueTypeVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.core.client.model.VariableModelProviders;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.Variable;
import org.cyclops.integrateddynamics.core.item.VariableFacadeBase;

public class ValueTypeVariableFacade<V extends IValue>
extends VariableFacadeBase
implements IValueTypeVariableFacade<V> {
    private final IValueType<V> valueType;
    private final V value;
    private IVariable<V> variable = null;

    public ValueTypeVariableFacade(boolean generateId, IValueType<V> valueType, V value) {
        super(generateId);
        this.valueType = valueType;
        this.value = value;
    }

    public ValueTypeVariableFacade(int id, IValueType<V> valueType, V value) {
        super(id);
        this.valueType = valueType;
        this.value = value;
    }

    public ValueTypeVariableFacade(boolean generateId, IValueType<V> valueType, INBT value) {
        super(generateId);
        this.valueType = valueType;
        this.value = ValueHelpers.deserializeRaw(valueType, value);
    }

    public ValueTypeVariableFacade(int id, IValueType<V> valueType, INBT value) {
        super(id);
        this.valueType = valueType;
        this.value = ValueHelpers.deserializeRaw(valueType, value);
    }

    @Override
    public IVariable<V> getVariable(IPartNetwork network) {
        if (this.isValid()) {
            if (this.variable == null) {
                this.variable = new Variable<V>(this.getValueType(), this.getValue());
            }
            return this.variable;
        }
        return null;
    }

    @Override
    public boolean isValid() {
        return this.getValueType() != null && this.getValue() != null;
    }

    @Override
    public void validate(IPartNetwork network, IVariableFacade.IValidator validator, IValueType containingValueType) {
        if (!this.isValid()) {
            validator.addError((IFormattableTextComponent)new TranslationTextComponent("variable.integrateddynamics.error.invalid_item"));
        } else if (!ValueHelpers.correspondsTo(this.getValueType(), containingValueType)) {
            validator.addError((IFormattableTextComponent)new TranslationTextComponent("aspect.integrateddynamics.error.invalid_type", new Object[]{new TranslationTextComponent(containingValueType.getTranslationKey()), new TranslationTextComponent(this.getValueType().getTranslationKey())}));
        }
    }

    @Override
    public IValueType getOutputType() {
        return this.getValueType();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addInformation(List<ITextComponent> list, World world) {
        if (this.isValid()) {
            V value = this.getValue();
            this.getValueType().loadTooltip(list, false, value);
            list.add((ITextComponent)new TranslationTextComponent("valuetype.integrateddynamics.tooltip.value", new Object[]{this.getValueType().toCompactString(value)}));
        }
        super.addInformation(list, world);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addModelOverlay(IVariableModelBaked variableModelBaked, List<BakedQuad> quads, Random random, IModelData modelData) {
        IBakedModel bakedModel;
        if (this.isValid() && (bakedModel = variableModelBaked.getSubModels(VariableModelProviders.VALUETYPE).getBakedModels().get(this.getValueType())) != null) {
            quads.addAll(bakedModel.getQuads(null, null, random, modelData));
        }
    }

    @Override
    @Nullable
    public IBakedModel getVariableItemOverrideModel(IBakedModel model, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity livingEntity) {
        if (this.isValid()) {
            return this.getValueType().getVariableItemOverrideModel(this.getValue(), model, stack, world, livingEntity);
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderISTER(ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (this.isValid()) {
            this.getValueType().renderISTER(this.getValue(), stack, transformType, matrixStack, buffer, combinedLight, combinedOverlay);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueTypeVariableFacade)) {
            return false;
        }
        ValueTypeVariableFacade other = (ValueTypeVariableFacade)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IValueType<V> this$valueType = this.getValueType();
        IValueType<V> other$valueType = other.getValueType();
        if (this$valueType == null ? other$valueType != null : !this$valueType.equals(other$valueType)) {
            return false;
        }
        V this$value = this.getValue();
        V other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        IVariable<V> this$variable = this.getVariable();
        IVariable<V> other$variable = other.getVariable();
        return !(this$variable == null ? other$variable != null : !this$variable.equals(other$variable));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ValueTypeVariableFacade;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        IValueType<V> $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 0 : $valueType.hashCode());
        V $value = this.getValue();
        result = result * 59 + ($value == null ? 0 : $value.hashCode());
        IVariable<V> $variable = this.getVariable();
        result = result * 59 + ($variable == null ? 0 : $variable.hashCode());
        return result;
    }

    @Override
    public IValueType<V> getValueType() {
        return this.valueType;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public IVariable<V> getVariable() {
        return this.variable;
    }

    public void setVariable(IVariable<V> variable) {
        this.variable = variable;
    }

    @Override
    public String toString() {
        return "ValueTypeVariableFacade(valueType=" + this.getValueType() + ", value=" + this.getValue() + ", variable=" + this.getVariable() + ")";
    }
}

