/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.network.IEnergyNetwork;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkCarrier;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkElementProvider;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.capability.network.EnergyNetworkConfig;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierConfig;
import org.cyclops.integrateddynamics.capability.network.PartNetworkConfig;
import org.cyclops.integrateddynamics.capability.network.PositionedAddonsNetworkIngredientsHandlerConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.path.PathElementConfig;
import org.cyclops.integrateddynamics.capability.path.SidedPathElement;
import org.cyclops.integrateddynamics.core.network.Network;
import org.cyclops.integrateddynamics.core.persist.world.NetworkWorldStorage;

public class NetworkHelpers {
    public static LazyOptional<INetworkCarrier> getNetworkCarrier(IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return TileHelpers.getCapability((IBlockReader)world, (BlockPos)pos, (Direction)side, NetworkCarrierConfig.CAPABILITY);
    }

    public static LazyOptional<INetworkElementProvider> getNetworkElementProvider(IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return TileHelpers.getCapability((IBlockReader)world, (BlockPos)pos, (Direction)side, NetworkElementProviderConfig.CAPABILITY);
    }

    public static LazyOptional<INetwork> getNetwork(IBlockReader world, BlockPos pos, @Nullable Direction side) {
        LazyOptional networkCarried = NetworkHelpers.getNetworkCarrier(world, pos, side).lazyMap(carrier -> {
            INetwork network = carrier.getNetwork();
            return network != null ? LazyOptional.of(() -> network) : LazyOptional.empty();
        });
        return (LazyOptional)networkCarried.orElse((Object)LazyOptional.empty());
    }

    public static LazyOptional<INetwork> getNetwork(PartPos pos) {
        return NetworkHelpers.getNetwork((IBlockReader)pos.getPos().getWorld(true), pos.getPos().getBlockPos(), pos.getSide());
    }

    public static INetwork getNetworkChecked(IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return (INetwork)NetworkHelpers.getNetwork(world, pos, side).orElseThrow(() -> new IllegalStateException("Could not find a network container at " + pos.toString()));
    }

    public static INetwork getNetworkChecked(PartPos pos) {
        return (INetwork)NetworkHelpers.getNetwork(pos).orElseThrow(() -> new IllegalStateException("Could not find a network container at " + pos.toString()));
    }

    public static LazyOptional<IPartNetwork> getPartNetwork(LazyOptional<INetwork> optionalNetwork) {
        return optionalNetwork.map(network -> network.getCapability(PartNetworkConfig.CAPABILITY)).orElse(LazyOptional.empty());
    }

    public static LazyOptional<IPartNetwork> getPartNetwork(@Nullable INetwork network) {
        if (network == null) {
            return LazyOptional.empty();
        }
        return network.getCapability(PartNetworkConfig.CAPABILITY);
    }

    public static IPartNetwork getPartNetworkChecked(INetwork network) {
        return (IPartNetwork)network.getCapability(PartNetworkConfig.CAPABILITY).orElseThrow(() -> new IllegalStateException("Could not find a network's part network"));
    }

    public static LazyOptional<IEnergyNetwork> getEnergyNetwork(LazyOptional<INetwork> optionalNetwork) {
        return optionalNetwork.map(network -> network.getCapability(EnergyNetworkConfig.CAPABILITY)).orElse(LazyOptional.empty());
    }

    public static LazyOptional<IEnergyNetwork> getEnergyNetwork(@Nullable INetwork network) {
        if (network == null) {
            return LazyOptional.empty();
        }
        return network.getCapability(EnergyNetworkConfig.CAPABILITY);
    }

    public static IEnergyNetwork getEnergyNetworkChecked(INetwork network) {
        return (IEnergyNetwork)network.getCapability(EnergyNetworkConfig.CAPABILITY).orElseThrow(() -> new IllegalStateException("Could not find a network's energy network"));
    }

    public static <T, M> LazyOptional<IPositionedAddonsNetworkIngredients<T, M>> getIngredientNetwork(LazyOptional<INetwork> optionalNetwork, IngredientComponent<T, M> ingredientComponent) {
        return optionalNetwork.map(network -> ingredientComponent.getCapability(PositionedAddonsNetworkIngredientsHandlerConfig.CAPABILITY).map(handler -> handler.getStorage((INetwork)network)).orElse(LazyOptional.empty())).orElse(LazyOptional.empty());
    }

    public static Optional<INetwork> initNetwork(World world, BlockPos pos, @Nullable Direction side) {
        return TileHelpers.getCapability((IBlockReader)world, (BlockPos)pos, (Direction)side, PathElementConfig.CAPABILITY).map(pathElement -> {
            Network network = Network.initiateNetworkSetup(SidedPathElement.of(pathElement, side));
            network.initialize();
            return Optional.of(network);
        }).orElse(Optional.empty());
    }

    public static void onElementProviderBlockNeighborChange(World world, BlockPos pos, Block neighbourBlock, @Nullable Direction side, BlockPos neighbourBlockPos) {
        if (!world.func_201670_d()) {
            NetworkHelpers.getNetwork((IBlockReader)world, pos, side).ifPresent(network -> NetworkHelpers.getNetworkElementProvider((IBlockReader)world, pos, side).ifPresent(networkElementProvider -> {
                for (INetworkElement networkElement : networkElementProvider.createNetworkElements(world, pos)) {
                    networkElement.onNeighborBlockChange((INetwork)network, (IBlockReader)world, neighbourBlock, neighbourBlockPos);
                }
            }));
        }
    }

    public static boolean shouldWork() {
        return !GeneralConfig.safeMode;
    }

    public static void invalidateNetworkElements(World world, BlockPos pos, TileEntity tile) {
        tile.getCapability(NetworkCarrierConfig.CAPABILITY, null).ifPresent(networkCarrier -> {
            INetwork network = networkCarrier.getNetwork();
            if (network != null) {
                tile.getCapability(NetworkElementProviderConfig.CAPABILITY, null).ifPresent(networkElementProvider -> {
                    for (INetworkElement networkElement : networkElementProvider.createNetworkElements(world, pos)) {
                        networkElement.invalidate(network);
                    }
                });
            }
        });
    }

    public static void revalidateNetworkElements(World world, BlockPos pos) {
        INetworkCarrier networkCarrier = (INetworkCarrier)TileHelpers.getCapability((IBlockReader)world, (BlockPos)pos, NetworkCarrierConfig.CAPABILITY).orElse(null);
        IPathElement pathElement = (IPathElement)TileHelpers.getCapability((IBlockReader)world, (BlockPos)pos, PathElementConfig.CAPABILITY).orElse(null);
        if (networkCarrier != null && pathElement != null && networkCarrier.getNetwork() == null) {
            TileHelpers.getCapability((IBlockReader)world, (BlockPos)pos, NetworkElementProviderConfig.CAPABILITY).ifPresent(networkElementProvider -> {
                for (INetwork network : NetworkWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).getNetworks()) {
                    if (!network.containsSidedPathElement(SidedPathElement.of(pathElement, null))) continue;
                    for (INetworkElement networkElement : networkElementProvider.createNetworkElements(world, pos)) {
                        networkElement.revalidate(network);
                    }
                }
            });
        }
    }
}

