/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.expression.VariableAdapter;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;

public class CompositionalOperator
extends OperatorBase {
    private final String unlocalizedType;

    protected CompositionalOperator(String symbol, String operatorName, IValueType[] inputTypes, IValueType outputType, OperatorBase.IFunction function, IConfigRenderPattern renderPattern, String unlocalizedType) {
        super(symbol, operatorName, inputTypes, outputType, function, renderPattern);
        this.unlocalizedType = unlocalizedType;
    }

    @Override
    protected String getUnlocalizedType() {
        return this.unlocalizedType;
    }

    public static class AppliedOperatorBuilder {
        private final IOperator base;
        private int buildersRequiredInputLength = -1;
        private AppliedOperatorBuilder[] builders = null;

        public AppliedOperatorBuilder(IOperator base) {
            this.base = base;
        }

        public AppliedOperatorBuilder apply(IOperator ... operators) {
            AppliedOperatorBuilder[] builders = new AppliedOperatorBuilder[operators.length];
            for (int i = 0; i < operators.length; ++i) {
                builders[i] = new AppliedOperatorBuilder(operators[i]);
            }
            return this.apply(builders);
        }

        public AppliedOperatorBuilder apply(AppliedOperatorBuilder ... builders) {
            IValueType[] valueTypes = new IValueType[builders.length];
            for (int i = 0; i < builders.length; ++i) {
                IOperator operator = builders[i].base;
                valueTypes[i] = operator.getOutputType();
            }
            IFormattableTextComponent error = this.base.validateTypes(valueTypes);
            if (error != null) {
                throw new IllegalArgumentException(error.getString());
            }
            this.builders = builders;
            return this;
        }

        protected int getRequiredInputLength() {
            if (this.buildersRequiredInputLength == -1) {
                if (this.builders != null) {
                    this.buildersRequiredInputLength = Integer.MAX_VALUE;
                    for (AppliedOperatorBuilder builder : this.builders) {
                        this.buildersRequiredInputLength = Math.min(this.buildersRequiredInputLength, builder.getRequiredInputLength());
                    }
                } else {
                    this.buildersRequiredInputLength = this.base.getRequiredInputLength();
                }
            }
            return this.buildersRequiredInputLength;
        }

        protected IValueType[] getInputTypes() {
            IValueType[] inputTypes;
            if (this.builders == null) {
                inputTypes = this.base.getInputTypes();
            } else {
                inputTypes = new IValueType[this.getRequiredInputLength()];
                for (AppliedOperatorBuilder builder : this.builders) {
                    IValueType[] subInputTypes = builder.getInputTypes();
                    for (int i = 0; i < subInputTypes.length; ++i) {
                        if (inputTypes[i] != null && !ValueHelpers.correspondsTo(inputTypes[i], subInputTypes[i])) {
                            throw new IllegalArgumentException(String.format("An composed operator expected type %s at position %s, while a type of %s was found.", inputTypes[i], i, subInputTypes[i]));
                        }
                        if (inputTypes[i] != null) continue;
                        inputTypes[i] = subInputTypes[i];
                    }
                }
            }
            return inputTypes;
        }

        protected IValue evaluate(final IVariable ... variables) throws EvaluationException {
            if (this.builders == null) {
                return this.base.evaluate(variables);
            }
            IVariable[] subVariablesOut = new IVariable[this.builders.length];
            for (int i = 0; i < this.builders.length; ++i) {
                final AppliedOperatorBuilder builder = this.builders[i];
                subVariablesOut[i] = new VariableAdapter<IValue>(){

                    @Override
                    public IValueType getType() {
                        return builder.base.getOutputType();
                    }

                    @Override
                    public IValue getValue() throws EvaluationException {
                        return builder.evaluate(variables);
                    }
                };
            }
            return this.base.evaluate(subVariablesOut);
        }

        protected IFormattableTextComponent validateTypes(String unlocalizedOperatorName, IValueType[] input) {
            if (this.builders == null) {
                return this.base.validateTypes(input);
            }
            if (input.length != this.getRequiredInputLength()) {
                return new TranslationTextComponent("operator.integrateddynamics.error.wrong_input_length", new Object[]{new TranslationTextComponent(unlocalizedOperatorName), input.length, this.getRequiredInputLength()});
            }
            IValueType[] subValueTypesOut = new IValueType[this.builders.length];
            for (int i = 0; i < this.builders.length; ++i) {
                AppliedOperatorBuilder builder = this.builders[i];
                IFormattableTextComponent subError = builder.validateTypes(unlocalizedOperatorName, input);
                if (subError != null) {
                    return subError;
                }
                subValueTypesOut[i] = builder.base.getOutputType();
            }
            return this.base.validateTypes(subValueTypesOut);
        }

        public IOperator build(String symbol, String operatorName, IConfigRenderPattern renderPattern, String unlocalizedType) {
            return new CompositionalOperator(symbol, operatorName, this.getInputTypes(), this.base.getOutputType(), new OperatorBase.IFunction(){

                @Override
                public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
                    return this.evaluate(variables.getVariables());
                }
            }, renderPattern, unlocalizedType){

                @Override
                public IFormattableTextComponent validateTypes(IValueType[] input) {
                    return this.validateTypes(this.getTranslationKey(), input);
                }
            };
        }
    }
}

