/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.valuetype;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.LinkedList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import org.apache.commons.lang3.StringUtils;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.api.client.render.valuetype.IValueTypeWorldRenderer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class NbtValueTypeWorldRenderer
implements IValueTypeWorldRenderer {
    private static final int MAX_LINES = 30;
    private static final float MAX = 12.5f;
    private static final float MARGIN_FACTOR = 1.1f;

    @Override
    public void renderValue(TileEntityRendererDispatcher rendererDispatcher, IPartContainer partContainer, Direction direction, IPartType partType, IValue value, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int combinedLight, int combinedOverlay, float alpha) {
        FontRenderer fontRenderer = rendererDispatcher.func_147548_a();
        Wrapper maxWidth = new Wrapper((Object)Float.valueOf(0.0f));
        LinkedList lines = Lists.newLinkedList();
        ((ValueTypeNbt.ValueNbt)value).getRawValue().ifPresent(tag -> {
            if (tag instanceof CompoundNBT) {
                CompoundNBT tagCompound = (CompoundNBT)tag;
                lines.add("{");
                for (String key : tagCompound.func_150296_c()) {
                    if (lines.size() >= 30) {
                        lines.add("...");
                        break;
                    }
                    INBT subTag = ValueTypes.NBT.filterBlacklistedTags(tagCompound.func_74781_a(key));
                    String string = "  " + key + ": " + StringUtils.abbreviate((String)subTag.toString(), (int)40) + "";
                    float width = fontRenderer.func_78256_a(string) - 1;
                    lines.add(string);
                    maxWidth.set((Object)Float.valueOf(Math.max(((Float)maxWidth.get()).floatValue(), width)));
                }
                lines.add("}");
            } else {
                String string = tag.toString();
                lines.add(string);
                maxWidth.set((Object)Float.valueOf(fontRenderer.func_78256_a(string) - 1));
            }
        });
        fontRenderer.getClass();
        float singleHeight = 9.0f;
        float totalHeight = singleHeight * (float)lines.size();
        matrixStack.func_227860_a_();
        float scaleX = 12.5f / (((Float)maxWidth.get()).floatValue() * 1.1f);
        float scaleY = 12.5f / (totalHeight * 1.1f);
        float scale = Math.min(scaleX, scaleY);
        float newWidth = ((Float)maxWidth.get()).floatValue() * scale;
        float newHeight = totalHeight * scale;
        matrixStack.func_227861_a_((double)((12.5f - newWidth) / 2.0f), (double)((12.5f - newHeight) / 2.0f), 0.0);
        matrixStack.func_227862_a_(scale, scale, 1.0f);
        int offset = 0;
        for (String line : lines) {
            int color = Helpers.addAlphaToColor((int)ValueTypes.NBT.getDisplayColor(), (float)alpha);
            rendererDispatcher.func_147548_a().func_228079_a_(line, 0.0f, (float)offset, color, false, matrixStack.func_227866_c_().func_227870_a_(), renderTypeBuffer, false, 0, combinedLight);
            offset = (int)((float)offset + singleHeight);
        }
        matrixStack.func_227865_b_();
    }
}

