/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.valuetype;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integrateddynamics.api.client.render.valuetype.IValueTypeWorldRenderer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentHandler;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.client.render.valuetype.ValueTypeWorldRenderers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeIngredients;
import org.cyclops.integrateddynamics.core.ingredient.IngredientComponentHandlers;

public class IngredientsValueTypeWorldRenderer
implements IValueTypeWorldRenderer {
    @Override
    public void renderValue(TileEntityRendererDispatcher rendererDispatcher, IPartContainer partContainer, Direction direction, IPartType partType, IValue value, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int combinedLight, int combinedOverlay, float alpha) {
        Optional ingredientsOptional = ((ValueObjectTypeIngredients.ValueIngredients)value).getRawValue();
        if (ingredientsOptional.isPresent()) {
            IMixedIngredients ingredients = (IMixedIngredients)ingredientsOptional.get();
            ArrayList values = Lists.newArrayList();
            for (IngredientComponent component : ingredients.getComponents()) {
                IIngredientComponentHandler componentHandler = IngredientComponentHandlers.REGISTRY.getComponentHandler(component);
                for (Object instance : ingredients.getInstances(component)) {
                    values.add(componentHandler.toValue(instance));
                }
            }
            IngredientsValueTypeWorldRenderer.renderGrid(rendererDispatcher, partContainer, direction, partType, values, partialTicks, matrixStack, renderTypeBuffer, combinedLight, combinedOverlay, alpha);
        }
    }

    public static void renderGrid(TileEntityRendererDispatcher rendererDispatcher, IPartContainer partContainer, Direction direction, IPartType partType, List<IValue> values, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int combinedLight, int combinedOverlay, float alpha) {
        matrixStack.func_227860_a_();
        int matrixRadius = IngredientsValueTypeWorldRenderer.getSmallestSquareFrom(values.size());
        float scale = 1.0f / (float)matrixRadius;
        matrixStack.func_227862_a_(scale, scale, 1.0f);
        for (int i = 0; i < matrixRadius; ++i) {
            int realIndex;
            for (int j = 0; j < matrixRadius && (realIndex = i * matrixRadius + j) < values.size(); ++j) {
                IValue renderValue = values.get(realIndex);
                if (renderValue == null) continue;
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)((float)j * 12.5f), (double)((float)i * 12.5f), 0.0);
                IValueTypeWorldRenderer renderer = ValueTypeWorldRenderers.REGISTRY.getRenderer(renderValue.getType());
                if (renderer == null) {
                    renderer = ValueTypeWorldRenderers.DEFAULT;
                }
                renderer.renderValue(rendererDispatcher, partContainer, direction, partType, renderValue, partialTicks, matrixStack, renderTypeBuffer, combinedLight, combinedOverlay, alpha);
                matrixStack.func_227865_b_();
            }
        }
        matrixStack.func_227865_b_();
    }

    @Nullable
    protected static <T> T prepareElementForTick(List<T> elements, int tick, Supplier<T> defaultFactory) {
        return (T)(elements.size() > 0 ? elements.get(tick % elements.size()) : defaultFactory.get());
    }

    protected static int getSmallestSquareFrom(int n) {
        while (!IngredientsValueTypeWorldRenderer.isInt(Math.sqrt(n))) {
            ++n;
        }
        return (int)Math.sqrt(n);
    }

    protected static final boolean isInt(double n) {
        return n == Math.floor(n) && !Double.isInfinite(n);
    }
}

