/*
 * Decompiled with CFR 0.152.
 */
package malte0811.recipebuffers.util;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.recipebuffers.impl.OptimizedPacketBuffer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LoggingPacketBuffer
extends OptimizedPacketBuffer {
    private final OptimizedPacketBuffer internal;
    public final PacketBuffer log;

    public LoggingPacketBuffer(OptimizedPacketBuffer internal) {
        super((ByteBuf)internal, true);
        this.internal = internal;
        this.log = new PacketBuffer(Unpooled.buffer());
    }

    @Nonnull
    public PacketBuffer func_179250_a(@Nonnull byte[] array) {
        return this.processWrite(Type.BYTE_ARRAY, array);
    }

    @Nonnull
    public byte[] func_189425_b(int maxLength) {
        return this.processRead(Type.BYTE_ARRAY);
    }

    @Nonnull
    public PacketBuffer func_186875_a(@Nonnull int[] array) {
        return this.processWrite(Type.VARINT_ARRAY, array);
    }

    @Nonnull
    public int[] func_189424_c(int maxLength) {
        return this.processRead(Type.VARINT_ARRAY);
    }

    @Nonnull
    public PacketBuffer func_186865_a(@Nonnull long[] array) {
        return this.processWrite(Type.LONG_ARRAY, array);
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public long[] func_189423_a(@Nullable long[] array, int maxLength) {
        return this.processRead(Type.LONG_ARRAY);
    }

    @Nonnull
    public BlockPos func_179259_c() {
        return this.processRead(Type.BLOCK_POS);
    }

    @Nonnull
    public PacketBuffer func_179255_a(@Nonnull BlockPos pos) {
        return this.processWrite(Type.BLOCK_POS, pos);
    }

    public int func_150792_a() {
        return this.processRead(Type.VARINT);
    }

    public long func_179260_f() {
        return this.processRead(Type.VARLONG);
    }

    @Nonnull
    public PacketBuffer func_179252_a(@Nonnull UUID uuid) {
        return this.processWrite(Type.UUID, uuid);
    }

    @Nonnull
    public UUID func_179253_g() {
        return this.processRead(Type.UUID);
    }

    @Nonnull
    public PacketBuffer func_150787_b(int input) {
        return this.processWrite(Type.VARINT, input);
    }

    @Nonnull
    public PacketBuffer func_179254_b(long value) {
        return this.processWrite(Type.VARLONG, value);
    }

    @Nonnull
    public PacketBuffer func_150786_a(@Nullable CompoundNBT nbt) {
        return this.processWrite(Type.COMPOUND_TAG, nbt);
    }

    @Nullable
    public CompoundNBT func_150793_b() {
        return this.processRead(Type.COMPOUND_TAG);
    }

    @Nonnull
    public String func_150789_c(int maxLength) {
        return this.processRead(Type.STRING);
    }

    @Nonnull
    public PacketBuffer func_211400_a(@Nonnull String string, int maxLength) {
        return this.processWrite(Type.STRING, string);
    }

    @Override
    @Nonnull
    public PacketBuffer func_192572_a(@Nonnull ResourceLocation resourceLocationIn) {
        return this.processWrite(Type.RESOURCE_LOCATION, resourceLocationIn);
    }

    @Override
    @Nonnull
    public ResourceLocation func_192575_l() {
        return this.processRead(Type.RESOURCE_LOCATION);
    }

    @Nonnull
    public PacketBuffer writeLong(long val) {
        return this.processWrite(Type.LONG, val);
    }

    public long readLong() {
        return this.processRead(Type.LONG);
    }

    @Nonnull
    public PacketBuffer writeInt(int val) {
        return this.processWrite(Type.INT, val);
    }

    public int readInt() {
        return this.processRead(Type.INT);
    }

    private <T> PacketBuffer processWrite(Type<T> t, T data) {
        this.log(t, data);
        ((Type)t).write.accept(this.internal, data);
        return this;
    }

    private <T> T processRead(Type<T> t) {
        Object result = ((Type)t).read.apply(this.internal);
        this.log(t, result);
        return (T)result;
    }

    private <T> void log(Type<T> t, T data) {
        this.log.func_150787_b(((Type)t).index);
        ((Type)t).write.accept(this.log, data);
    }

    public static class Type<T> {
        public static final List<Type<?>> INSTANCES = new ArrayList();
        public static final Type<byte[]> BYTE_ARRAY = new Type<byte[]>("byte[]", PacketBuffer::func_179250_a, PacketBuffer::func_179251_a);
        public static final Type<int[]> VARINT_ARRAY = new Type<int[]>("varint[]", PacketBuffer::func_186875_a, PacketBuffer::func_186863_b);
        public static final Type<long[]> LONG_ARRAY = new Type<long[]>("long[]", PacketBuffer::func_186865_a, buf -> buf.func_186873_b(null));
        public static final Type<BlockPos> BLOCK_POS = new Type<BlockPos>("BlockPos", PacketBuffer::func_179255_a, PacketBuffer::func_179259_c);
        public static final Type<Integer> VARINT = new Type<Integer>("varint", PacketBuffer::func_150787_b, PacketBuffer::func_150792_a);
        public static final Type<Long> VARLONG = new Type<Long>("varlong", PacketBuffer::func_179254_b, PacketBuffer::func_179260_f);
        public static final Type<Integer> INT = new Type<Integer>("int", PacketBuffer::writeInt, PacketBuffer::readInt);
        public static final Type<Long> LONG = new Type<Long>("long", PacketBuffer::writeLong, PacketBuffer::readLong);
        public static final Type<UUID> UUID = new Type<UUID>("UUID", PacketBuffer::func_179252_a, PacketBuffer::func_179253_g);
        public static final Type<String> STRING = new Type<String>("String", PacketBuffer::func_180714_a, PacketBuffer::func_218666_n);
        public static final Type<ResourceLocation> RESOURCE_LOCATION = new Type<ResourceLocation>("ResourceLocation", PacketBuffer::func_192572_a, PacketBuffer::func_192575_l);
        public static final Type<CompoundNBT> COMPOUND_TAG = new Type<CompoundNBT>("CompoundNBT", PacketBuffer::func_150786_a, PacketBuffer::func_150793_b);
        private final int index;
        private final String name;
        private final BiConsumer<PacketBuffer, T> write;
        private final Function<PacketBuffer, T> read;

        private Type(String name, BiConsumer<PacketBuffer, T> write, Function<PacketBuffer, T> read) {
            this.name = name;
            this.index = INSTANCES.size();
            this.write = write;
            this.read = read;
            INSTANCES.add(this);
        }

        public void rerewrite(PacketBuffer source, PacketBuffer target, PacketBuffer targetAsInput, boolean log) {
            T temp = this.read.apply(source);
            if (log) {
                System.out.println("Rewriting " + temp + " (" + this.name + ")");
            }
            this.write.accept(target, (PacketBuffer)temp);
            T reread = this.read.apply(targetAsInput);
            Preconditions.checkState((boolean)Objects.deepEquals(reread, temp));
        }
    }
}

