/*
 * Decompiled with CFR 0.152.
 */
package malte0811.recipebuffers.util;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import malte0811.recipebuffers.util.RecurringData;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class IngredientSerializer {
    private final PacketBuffer buffer;
    private final RecurringData<List<ItemstackWrapper>> basicIngredientHandler;

    public IngredientSerializer(PacketBuffer buffer, boolean reading) {
        this.buffer = buffer;
        this.basicIngredientHandler = IngredientSerializer.createRecurringData(buffer, reading);
    }

    private static RecurringData<List<ItemstackWrapper>> createRecurringData(PacketBuffer buffer, boolean reader) {
        return RecurringData.createForList(buffer, b -> new ItemstackWrapper(b.func_150791_c()), (b, i) -> b.func_150788_a(((ItemstackWrapper)i).stack), reader);
    }

    public <T extends Ingredient> void write(T ingredient) {
        boolean isSpecial = !ingredient.isVanilla();
        this.buffer.writeBoolean(isSpecial);
        if (isSpecial) {
            IIngredientSerializer serializer = ingredient.getSerializer();
            ResourceLocation key = CraftingHelper.getID((IIngredientSerializer)serializer);
            if (key == null) {
                throw new IllegalArgumentException("Tried to serialize unregistered Ingredient: " + ingredient + " " + serializer);
            }
            this.buffer.func_192572_a(key);
            serializer.write(this.buffer, ingredient);
        } else {
            List wrappers = Arrays.stream(ingredient.func_193365_a()).map(x$0 -> new ItemstackWrapper((ItemStack)x$0)).collect(Collectors.toList());
            this.basicIngredientHandler.write(wrappers);
        }
    }

    public Ingredient read() {
        if (this.buffer.readBoolean()) {
            return CraftingHelper.getIngredient((ResourceLocation)this.buffer.func_192575_l(), (PacketBuffer)this.buffer);
        }
        List<ItemstackWrapper> wrappers = this.basicIngredientHandler.read();
        return Ingredient.func_234819_a_(wrappers.stream().map(w -> ((ItemstackWrapper)w).stack));
    }

    public int cacheSize() {
        return this.basicIngredientHandler.size();
    }

    public int cacheHits() {
        return this.basicIngredientHandler.hits();
    }

    private static class ItemstackWrapper {
        private final ItemStack stack;

        private ItemstackWrapper(ItemStack stack) {
            this.stack = stack;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ItemstackWrapper that = (ItemstackWrapper)o;
            return ItemStack.func_77989_b((ItemStack)this.stack, (ItemStack)that.stack);
        }

        public int hashCode() {
            return Objects.hash(this.stack.func_77973_b(), this.stack.func_190916_E(), this.stack.func_77978_p());
        }
    }
}

