/*
 * Decompiled with CFR 0.152.
 */
package malte0811.recipebuffers.impl;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import malte0811.recipebuffers.Config;
import malte0811.recipebuffers.RBRecipeSerializers;
import malte0811.recipebuffers.impl.IRecurringRecipeSerializer;
import malte0811.recipebuffers.impl.OptimizedPacketBuffer;
import malte0811.recipebuffers.util.IngredientSerializer;
import malte0811.recipebuffers.util.StateStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipeListSerializer {
    public static final Logger WRITE_LOGGER = LogManager.getLogger((String)"recipebuffers - WRITE");
    public static final Logger READ_LOGGER = LogManager.getLogger((String)"recipebuffers - READ");

    public static void writeRecipes(List<IRecipe<?>> recipes, PacketBuffer bufIn) throws IOException {
        int debugLevel = (Integer)Config.debugLogLevel.get();
        boolean writeLength = (Boolean)Config.writeRecipeLength.get();
        int configByte = 0;
        if (writeLength) {
            configByte = (byte)(configByte | 1);
        }
        bufIn.writeByte(configByte);
        StateStack.Entry computeLists = StateStack.push("Compute recipe lists");
        OptimizedPacketBuffer buf = new OptimizedPacketBuffer((ByteBuf)bufIn, false);
        IdentityHashMap<IRecipeSerializer, List> bySerializer = new IdentityHashMap<IRecipeSerializer, List>();
        for (IRecipe<?> iRecipe : recipes) {
            bySerializer.computeIfAbsent(iRecipe.func_199559_b(), ser -> new ArrayList()).add(iRecipe);
        }
        computeLists.pop();
        IngredientSerializer ingredientSerializer = new IngredientSerializer(buf, false);
        buf.func_150787_b(bySerializer.size());
        if (debugLevel > 0) {
            WRITE_LOGGER.debug("Number of serializers: {}", (Object)bySerializer.size());
        }
        for (Map.Entry entry : bySerializer.entrySet()) {
            StateStack.Entry serializerEntry = StateStack.push("Writing recipes for serializer " + ((IRecipeSerializer)entry.getKey()).getRegistryName());
            if (debugLevel > 0) {
                WRITE_LOGGER.debug("Writing {} recipes for serializer {}", (Object)((List)entry.getValue()).size(), (Object)((IRecipeSerializer)entry.getKey()).getRegistryName());
            }
            buf.writeRegistryIdUnsafe(ForgeRegistries.RECIPE_SERIALIZERS, (IForgeRegistryEntry)entry.getKey());
            IRecipeSerializer<?> serializerToUse = RBRecipeSerializers.getSerializer((IRecipeSerializer)entry.getKey());
            buf.func_150787_b(((List)entry.getValue()).size());
            for (IRecipe recipe : (List)entry.getValue()) {
                StateStack.Entry recipeEntry = StateStack.push("Writing recipe " + recipe.func_199560_c());
                if (debugLevel > 1) {
                    WRITE_LOGGER.debug("Writing recipe {} (name: {})", (Object)recipe, (Object)recipe.func_199560_c());
                }
                int oldWriteIndex = buf.writerIndex();
                RecipeListSerializer.writeRecipe(recipe, buf, serializerToUse, ingredientSerializer, writeLength);
                if (debugLevel > 1) {
                    WRITE_LOGGER.debug("Wrote recipe, takes {} bytes", (Object)(buf.writerIndex() - oldWriteIndex));
                }
                recipeEntry.pop();
            }
            serializerEntry.pop();
        }
        if (((Boolean)Config.dumpPacket.get()).booleanValue()) {
            Throwable throwable = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream("written_recipes.dmp");){
                fileOutputStream.write(ByteBufUtil.getBytes((ByteBuf)buf.copy()));
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        if (((Boolean)Config.logPacketStats.get()).booleanValue()) {
            WRITE_LOGGER.info("Recipe packet size: {}", (Object)buf.readableBytes());
            WRITE_LOGGER.info("Item stack bytes: {}", (Object)buf.itemStackBytes);
            WRITE_LOGGER.info("RL path bytes: {}", (Object)buf.resourceLocationSerializer.rlPathBytes);
            WRITE_LOGGER.info("Ingredient cache size: {}", (Object)ingredientSerializer.cacheSize());
            WRITE_LOGGER.info("Ingredient cache hits: {}", (Object)ingredientSerializer.cacheHits());
        }
    }

    public static List<IRecipe<?>> readRecipes(PacketBuffer bufIn) throws IOException {
        if (((Boolean)Config.dumpPacket.get()).booleanValue()) {
            try (FileOutputStream out = new FileOutputStream("read_recipes.dmp");){
                out.write(ByteBufUtil.getBytes((ByteBuf)bufIn.copy()));
            }
        }
        int debugLevel = (Integer)Config.debugLogLevel.get();
        OptimizedPacketBuffer buf = new OptimizedPacketBuffer((ByteBuf)bufIn, true);
        byte configByte = buf.readByte();
        boolean includesLengthPrefix = (configByte & 1) != 0;
        ArrayList recipes = Lists.newArrayList();
        IngredientSerializer ingredientSerializer = new IngredientSerializer(buf, true);
        int numSerializer = buf.func_150792_a();
        if (debugLevel > 0) {
            READ_LOGGER.debug("Number of serializers: {}", (Object)numSerializer);
        }
        for (int serId = 0; serId < numSerializer; ++serId) {
            IRecipeSerializer<?> serializer = (IRecipeSerializer<?>)buf.readRegistryIdUnsafe(ForgeRegistries.RECIPE_SERIALIZERS);
            StateStack.Entry serializerEntry = StateStack.push("Reading recipes for serializer " + serializer.getRegistryName());
            int numRecipes = buf.func_150792_a();
            if (debugLevel > 0) {
                READ_LOGGER.debug("Reading {} recipes for serializer {}", (Object)numRecipes, (Object)serializer.getRegistryName());
            }
            serializer = RBRecipeSerializers.getSerializer(serializer);
            for (int recId = 0; recId < numRecipes; ++recId) {
                int oldReadIndex = buf.readerIndex();
                Object readRecipe = RecipeListSerializer.readRecipe(buf, serializer, ingredientSerializer, includesLengthPrefix);
                recipes.add(readRecipe);
                if (debugLevel <= 1) continue;
                READ_LOGGER.debug("Read recipe {} (name {}), bytes read: {}", readRecipe, (Object)readRecipe.func_199560_c(), (Object)(buf.readerIndex() - oldReadIndex));
            }
            serializerEntry.pop();
        }
        return recipes;
    }

    public static <R extends IRecipe<?>> R readRecipe(OptimizedPacketBuffer buffer, IRecipeSerializer<R> serializer, IngredientSerializer ingredientSerializer, boolean readLength) {
        int expectedLength = readLength ? buffer.func_150792_a() : -1;
        int oldReadIndex = buffer.readerIndex();
        ResourceLocation name = buffer.func_192575_l();
        StateStack.Entry recipeEntry = StateStack.push("Reading recipe " + name);
        Object result = serializer instanceof IRecurringRecipeSerializer ? ((IRecurringRecipeSerializer)serializer).read(name, buffer, ingredientSerializer) : serializer.func_199426_a_(name, (PacketBuffer)buffer);
        int recipeLength = buffer.readerIndex() - oldReadIndex;
        if (readLength && expectedLength != recipeLength) {
            throw new IllegalStateException("Recipe read " + recipeLength + " bytes, but wrote " + expectedLength + " bytes, see log for details");
        }
        recipeEntry.pop();
        return (R)result;
    }

    public static <T extends IRecipe<?>> void writeRecipe(T recipe, OptimizedPacketBuffer buffer, IRecipeSerializer<?> serializer, IngredientSerializer ingredientSerializer, boolean writeLength) {
        int writerIndexBefore = buffer.writerIndex();
        buffer.func_192572_a(recipe.func_199560_c());
        if (serializer instanceof IRecurringRecipeSerializer) {
            ((IRecurringRecipeSerializer)serializer).write(buffer, recipe, ingredientSerializer);
        } else {
            serializer.func_199427_a_((PacketBuffer)buffer, recipe);
        }
        if (writeLength) {
            int readerIndexBefore = buffer.readerIndex();
            int bytesWritten = buffer.writerIndex() - writerIndexBefore;
            buffer.readerIndex(writerIndexBefore);
            byte[] recipeBytes = new byte[bytesWritten];
            buffer.readBytes(recipeBytes);
            buffer.readerIndex(readerIndexBefore);
            buffer.writerIndex(writerIndexBefore);
            buffer.func_150787_b(bytesWritten);
            buffer.writeBytes(recipeBytes);
        }
    }

    private static class ConfigMasks {
        public static final byte RECIPE_LENGTH = 1;

        private ConfigMasks() {
        }
    }
}

