/*
 * Decompiled with CFR 0.152.
 */
package malte0811.recipebuffers;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.FileInputStream;
import java.io.IOException;
import malte0811.recipebuffers.impl.OptimizedPacketBuffer;
import malte0811.recipebuffers.util.LoggingPacketBuffer;
import net.minecraft.network.PacketBuffer;

public class Reparse {
    public static void main(String[] args) throws IOException {
        int next;
        FileInputStream input = new FileInputStream("run/parsable.dmp");
        ByteBuf inputBuffer = Unpooled.buffer();
        while ((next = input.read()) != -1) {
            inputBuffer.writeByte(next);
        }
        inputBuffer = inputBuffer.asReadOnly();
        for (int i = 0; i < 10; ++i) {
            Reparse.reparse(inputBuffer.duplicate());
        }
    }

    private static void reparse(ByteBuf inputBuffer) {
        PacketBuffer inputPB = new PacketBuffer(inputBuffer);
        ByteBuf outputBuffer = Unpooled.buffer();
        OptimizedPacketBuffer outputPB = new OptimizedPacketBuffer(outputBuffer, false);
        OptimizedPacketBuffer outputAsInput = new OptimizedPacketBuffer(outputBuffer, true);
        long reparseStart = System.currentTimeMillis();
        int idBytes = 0;
        while (inputPB.readerIndex() != inputPB.writerIndex()) {
            int id = inputPB.func_150792_a();
            idBytes += PacketBuffer.func_150790_a((int)id);
            LoggingPacketBuffer.Type.INSTANCES.get(id).rerewrite(inputPB, outputPB, outputAsInput, false);
        }
        System.out.printf("Plain size: %,d, opt size: %,d\n", inputPB.writerIndex() - idBytes, outputPB.writerIndex());
        System.out.println("Time for reparse: " + (System.currentTimeMillis() - reparseStart) + " ms");
    }
}

