/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.thermal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import dev.latvian.kubejs.fluid.FluidStackJS;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.kubejs.thermal.ThermalRecipeJS;
import dev.latvian.kubejs.util.ListJS;
import java.util.ArrayList;

public class BasicThermalRecipeJS
extends ThermalRecipeJS {
    public ArrayList<FluidStackJS> inputFluids = new ArrayList();
    public ArrayList<FluidStackJS> outputFluids = new ArrayList();
    public String inKey = "";
    public String outKey = "";

    public void create(ListJS args) {
        this.inKey = "ingredients";
        this.outKey = "results";
        for (Object o : ListJS.orSelf((Object)args.get(0))) {
            if (o instanceof FluidStackJS) {
                this.outputFluids.add((FluidStackJS)o);
                continue;
            }
            this.outputItems.add(this.parseResultItem(o));
        }
        for (Object o : ListJS.orSelf((Object)args.get(1))) {
            if (o instanceof FluidStackJS) {
                this.inputFluids.add((FluidStackJS)o);
                continue;
            }
            this.inputItems.add(this.parseIngredientItem(o));
        }
        if (this.outputItems.isEmpty() && this.outputFluids.isEmpty()) {
            throw new RecipeExceptionJS("Thermal recipe can't have no result!");
        }
        if (this.inputItems.isEmpty() && this.inputFluids.isEmpty()) {
            throw new RecipeExceptionJS("Thermal recipe can't have no ingredients!");
        }
        this.json.addProperty("energy", (Number)4000);
    }

    public BasicThermalRecipeJS experience(float e) {
        this.json.addProperty("experience", (Number)Float.valueOf(e));
        this.save();
        return this;
    }

    public BasicThermalRecipeJS minTicks(int i) {
        this.json.addProperty("min_ticks", (Number)i);
        this.save();
        return this;
    }

    public void deserialize() {
        JsonArray array;
        JsonElement element;
        this.inKey = "";
        if (this.json.has("ingredient")) {
            this.inKey = "ingredient";
        } else if (this.json.has("ingredients")) {
            this.inKey = "ingredients";
        } else if (this.json.has("input")) {
            this.inKey = "input";
        } else if (this.json.has("inputs")) {
            this.inKey = "inputs";
        }
        if (!this.inKey.isEmpty() && (element = this.json.get(this.inKey)) != null) {
            if (element.isJsonArray()) {
                array = element.getAsJsonArray();
            } else {
                array = new JsonArray();
                array.add(element);
            }
            for (JsonElement e : array) {
                if (e.isJsonObject() && e.getAsJsonObject().has("fluid")) {
                    this.inputFluids.add(FluidStackJS.fromJson((JsonElement)e.getAsJsonObject()));
                    continue;
                }
                this.inputItems.add(this.parseIngredientItem(e));
            }
        }
        this.outKey = "";
        if (this.json.has("result")) {
            this.outKey = "result";
        } else if (this.json.has("results")) {
            this.outKey = "results";
        } else if (this.json.has("output")) {
            this.outKey = "output";
        } else if (this.json.has("outputs")) {
            this.outKey = "outputs";
        }
        if (!this.outKey.isEmpty() && (element = this.json.get(this.outKey)) != null) {
            if (element.isJsonArray()) {
                array = element.getAsJsonArray();
            } else {
                array = new JsonArray();
                array.add(element);
            }
            for (JsonElement e : array) {
                if (e.getAsJsonObject().has("fluid")) {
                    this.outputFluids.add(FluidStackJS.fromJson((JsonElement)e.getAsJsonObject()));
                    continue;
                }
                this.outputItems.add(this.parseResultItem(e));
            }
        }
    }

    public void serialize() {
        if (this.serializeOutputs) {
            JsonArray out = new JsonArray();
            for (ItemStackJS stack : this.outputItems) {
                out.add(stack.toResultJson());
            }
            for (FluidStackJS fluid : this.outputFluids) {
                out.add((JsonElement)fluid.toJson());
            }
            this.json.add(this.outKey, (JsonElement)out);
        }
        if (this.serializeInputs) {
            JsonArray in = new JsonArray();
            for (IngredientJS ingredient : this.inputItems) {
                in.add(ingredient.toJson());
            }
            for (FluidStackJS fluid : this.inputFluids) {
                in.add((JsonElement)fluid.toJson());
            }
            this.json.add(this.inKey, (JsonElement)in);
        }
    }
}

