/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.findme.network;

import com.buuz135.findme.proxy.FindMeConfig;
import com.buuz135.findme.proxy.client.ClientTickHandler;
import com.buuz135.findme.proxy.client.ParticlePosition;
import com.buuz135.findme.tracking.TrackingList;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class PositionResponseMessage
implements Serializable {
    private List<BlockPos> positions;

    public PositionResponseMessage(List<BlockPos> positions) {
        this.positions = positions;
    }

    public PositionResponseMessage() {
    }

    public PositionResponseMessage fromBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        this.positions = new ArrayList<BlockPos>();
        for (int amount = packetBuffer.readInt(); amount > 0; --amount) {
            this.positions.add(packetBuffer.func_179259_c());
        }
        return this;
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        packetBuffer.writeInt(this.positions.size());
        for (BlockPos position : this.positions) {
            packetBuffer.func_179255_a(position);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        Minecraft.func_71410_x().func_213165_a(() -> {
            if (this.positions.size() > 0) {
                Minecraft.func_71410_x().field_71439_g.func_71053_j();
                if (FindMeConfig.CLIENT.doTracking()) {
                    TrackingList.beginTracking();
                    ClientTickHandler.addRunnable(TrackingList::clear, (Integer)FindMeConfig.CLIENT.CONTAINER_TRACK_TIME.get());
                }
                for (BlockPos position : this.positions) {
                    for (int i = 0; i < 2; ++i) {
                        this.addParticle(position);
                    }
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addParticle(BlockPos position) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticlePosition((ClientWorld)Minecraft.func_71410_x().field_71439_g.field_70170_p, (double)position.func_177958_n() + 0.75 - Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73012_v.nextDouble() / 2.0, (double)position.func_177956_o() + 0.75 - Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73012_v.nextDouble() / 2.0, (double)position.func_177952_p() + 0.75 - Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73012_v.nextDouble() / 2.0, 0.0, 0.0, 0.0));
    }
}

