/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.recipes.device;

import cofh.lib.util.recipes.RecipeJsonUtils;
import cofh.thermal.core.util.managers.device.TreeExtractorManager;
import cofh.thermal.core.util.recipes.device.TreeExtractorBoost;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class TreeExtractorBoostSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<TreeExtractorBoost> {
    public TreeExtractorBoost read(ResourceLocation recipeId, JsonObject json) {
        float outputMod = 1.0f;
        int cycles = TreeExtractorManager.instance().getDefaultEnergy();
        Ingredient ingredient = RecipeJsonUtils.parseIngredient((JsonElement)json.get("ingredient"));
        if (json.has("output")) {
            outputMod = json.get("output").getAsFloat();
        } else if (json.has("output_mod")) {
            outputMod = json.get("output_mod").getAsFloat();
        }
        if (json.has("cycles")) {
            cycles = json.get("cycles").getAsInt();
        }
        return new TreeExtractorBoost(recipeId, ingredient, outputMod, cycles);
    }

    @Nullable
    public TreeExtractorBoost read(ResourceLocation recipeId, PacketBuffer buffer) {
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        float outputMod = buffer.readFloat();
        int cycles = buffer.readInt();
        return new TreeExtractorBoost(recipeId, ingredient, outputMod, cycles);
    }

    public void write(PacketBuffer buffer, TreeExtractorBoost recipe) {
        recipe.ingredient.func_199564_a(buffer);
        buffer.writeFloat(recipe.outputMod);
        buffer.writeInt(recipe.cycles);
    }
}

