/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.recipes.device;

import cofh.lib.util.recipes.RecipeJsonUtils;
import cofh.thermal.core.util.managers.device.RockGenManager;
import cofh.thermal.core.util.recipes.device.RockGenMapping;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RockGenMappingSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RockGenMapping> {
    public RockGenMapping read(ResourceLocation recipeId, JsonObject json) {
        int time = RockGenManager.instance().getDefaultEnergy();
        Block below = Blocks.field_150350_a;
        Block adjacent = Blocks.field_150350_a;
        ItemStack result = ItemStack.field_190927_a;
        if (json.has("below")) {
            below = RecipeJsonUtils.parseBlock((JsonElement)json.get("below"));
        } else if (json.has("base")) {
            below = RecipeJsonUtils.parseBlock((JsonElement)json.get("base"));
        }
        if (json.has("adjacent")) {
            adjacent = RecipeJsonUtils.parseBlock((JsonElement)json.get("adjacent"));
        }
        if (json.has("result")) {
            result = RecipeJsonUtils.parseItemStack((JsonElement)json.get("result"));
        } else if (json.has("item")) {
            result = RecipeJsonUtils.parseItemStack((JsonElement)json.get("item"));
        }
        if (json.has("time")) {
            time = json.get("time").getAsInt();
        } else if (json.has("ticks")) {
            time = json.get("ticks").getAsInt();
        }
        return new RockGenMapping(recipeId, time, below, adjacent, result);
    }

    @Nullable
    public RockGenMapping read(ResourceLocation recipeId, PacketBuffer buffer) {
        int time = buffer.readInt();
        Block trunk = (Block)ForgeRegistries.BLOCKS.getValue(buffer.func_192575_l());
        Block leaves = (Block)ForgeRegistries.BLOCKS.getValue(buffer.func_192575_l());
        ItemStack result = buffer.func_150791_c();
        return new RockGenMapping(recipeId, time, trunk, leaves, result);
    }

    public void write(PacketBuffer buffer, RockGenMapping recipe) {
        buffer.writeInt(recipe.time);
        buffer.func_192572_a(recipe.below.getRegistryName());
        buffer.func_192572_a(recipe.adjacent.getRegistryName());
        buffer.func_150788_a(recipe.result);
    }
}

