/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.item;

import cofh.core.item.ItemCoFH;
import cofh.lib.util.AreaUtils;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.references.CoreReferences;
import cofh.thermal.core.entity.projectile.BlizzProjectileEntity;
import cofh.thermal.lib.common.ThermalConfig;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class IceChargeItem
extends ItemCoFH {
    private static final IDispenseItemBehavior DISPENSER_BEHAVIOR = new DefaultDispenseItemBehavior(){

        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
            IPosition iposition = DispenserBlock.func_149939_a((IBlockSource)source);
            double d0 = iposition.func_82615_a() + (double)((float)direction.func_82601_c() * 0.3f);
            double d1 = iposition.func_82617_b() + (double)((float)direction.func_96559_d() * 0.3f);
            double d2 = iposition.func_82616_c() + (double)((float)direction.func_82599_e() * 0.3f);
            ServerWorld world = source.func_197524_h();
            Random random = world.field_73012_v;
            double d3 = random.nextGaussian() * 0.05 + (double)direction.func_82601_c();
            double d4 = random.nextGaussian() * 0.05 + (double)direction.func_96559_d();
            double d5 = random.nextGaussian() * 0.05 + (double)direction.func_82599_e();
            world.func_217376_c((Entity)Util.func_199748_a(() -> 1.lambda$dispenseStack$0(d0, d1, d2, d3, d4, d5, (World)world)));
            stack.func_190918_g(1);
            return stack;
        }

        protected void func_82485_a(IBlockSource source) {
            source.func_197524_h().func_217379_c(1018, source.func_180699_d(), 0);
        }

        private static /* synthetic */ BlizzProjectileEntity lambda$dispenseStack$0(double d0, double d1, double d2, double d3, double d4, double d5, World world) {
            return new BlizzProjectileEntity(d0, d1, d2, d3, d4, d5, world);
        }
    };

    public IceChargeItem(Item.Properties builder) {
        super(builder);
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)DISPENSER_BEHAVIOR);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        boolean isFull;
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        boolean used = false;
        if (AreaUtils.isLitCampfire((BlockState)state)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(false)));
            used = true;
        }
        if (world.func_175623_d(pos = pos.func_177972_a(context.func_196000_l())) && AreaUtils.isValidSnowPosition((World)world, (BlockPos)pos)) {
            world.func_175656_a(pos, Blocks.field_150433_aE.func_176223_P());
            used = true;
        }
        if ((state = world.func_180495_p(pos)).func_177230_c() == Blocks.field_150480_ab) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            used = true;
        }
        boolean bl = isFull = state.func_177230_c() == Blocks.field_150355_j && (Integer)state.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0;
        if (state.func_185904_a() == Material.field_151586_h && isFull && state.func_196955_c((IWorldReader)world, pos) && world.func_226663_a_(state, pos, ISelectionContext.func_216377_a())) {
            world.func_175656_a(pos, ThermalConfig.permanentWater ? Blocks.field_150432_aD.func_176223_P() : Blocks.field_185778_de.func_176223_P());
            used = true;
            if (!ThermalConfig.permanentWater) {
                world.func_205220_G_().func_205360_a(pos, (Object)Blocks.field_185778_de, MathHelper.nextInt((Random)world.field_73012_v, (int)60, (int)120));
            }
        }
        boolean bl2 = isFull = state.func_177230_c() == Blocks.field_150353_l && (Integer)state.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0;
        if (state.func_185904_a() == Material.field_151587_i && isFull && state.func_196955_c((IWorldReader)world, pos) && world.func_226663_a_(state, pos, ISelectionContext.func_216377_a())) {
            world.func_175656_a(pos, ThermalConfig.permanentLava ? Blocks.field_150343_Z.func_176223_P() : CoreReferences.GLOSSED_MAGMA.func_176223_P());
            used = true;
            if (!ThermalConfig.permanentLava) {
                world.func_205220_G_().func_205360_a(pos, (Object)CoreReferences.GLOSSED_MAGMA, MathHelper.nextInt((Random)world.field_73012_v, (int)60, (int)120));
            }
        }
        if (used) {
            this.playUseSound(world, pos);
            context.func_195996_i().func_190918_g(1);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    private void playUseSound(World worldIn, BlockPos pos) {
        worldIn.func_184133_a(null, pos, SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 1.0f, (field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.2f + 1.0f);
    }
}

