/*
 * Decompiled with CFR 0.152.
 */
package stepsword.jousting.config;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="jousting", bus=Mod.EventBusSubscriber.Bus.MOD)
public class JConfig {
    public static final Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static int WOODEN_LANCE_DURABILITY;
    public static int IRON_LANCE_DURABILITY;
    public static int GOLD_LANCE_DURABILITY;
    public static int DIAMOND_LANCE_DURABILITY;
    public static int EMERALD_LANCE_DURABILITY;
    public static int NETHERITE_LANCE_DURABILITY;
    public static double WOODEN_LANCE_DAMAGE;
    public static double IRON_LANCE_DAMAGE;
    public static double GOLD_LANCE_DAMAGE;
    public static double DIAMOND_LANCE_DAMAGE;
    public static double EMERALD_LANCE_DAMAGE;
    public static double NETHERITE_LANCE_DAMAGE;
    public static double WOODEN_LANCE_WEIGHT;
    public static double IRON_LANCE_WEIGHT;
    public static double GOLD_LANCE_WEIGHT;
    public static double DIAMOND_LANCE_WEIGHT;
    public static double EMERALD_LANCE_WEIGHT;
    public static double NETHERITE_LANCE_WEIGHT;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == SERVER_SPEC) {
            JConfig.bakeConfigServer();
        }
        if (configEvent.getConfig().getSpec() == CLIENT_SPEC) {
            JConfig.bakeConfigClient();
        }
    }

    public static void bakeConfigClient() {
    }

    public static void bakeConfigServer() {
        WOODEN_LANCE_DURABILITY = (Integer)Server.WOODEN_LANCE_DURABILITY.get();
        IRON_LANCE_DURABILITY = (Integer)Server.IRON_LANCE_DURABILITY.get();
        GOLD_LANCE_DURABILITY = (Integer)Server.GOLD_LANCE_DURABILITY.get();
        DIAMOND_LANCE_DURABILITY = (Integer)Server.DIAMOND_LANCE_DURABILITY.get();
        EMERALD_LANCE_DURABILITY = (Integer)Server.EMERALD_LANCE_DURABILITY.get();
        NETHERITE_LANCE_DURABILITY = (Integer)Server.NETHERITE_LANCE_DURABILITY.get();
        WOODEN_LANCE_DAMAGE = (Double)Server.WOODEN_LANCE_DAMAGE.get();
        IRON_LANCE_DAMAGE = (Double)Server.IRON_LANCE_DAMAGE.get();
        GOLD_LANCE_DAMAGE = (Double)Server.GOLD_LANCE_DAMAGE.get();
        DIAMOND_LANCE_DAMAGE = (Double)Server.DIAMOND_LANCE_DAMAGE.get();
        EMERALD_LANCE_DAMAGE = (Double)Server.EMERALD_LANCE_DAMAGE.get();
        NETHERITE_LANCE_DAMAGE = (Double)Server.NETHERITE_LANCE_DAMAGE.get();
        WOODEN_LANCE_WEIGHT = (Double)Server.WOODEN_LANCE_WEIGHT.get();
        IRON_LANCE_WEIGHT = (Double)Server.IRON_LANCE_WEIGHT.get();
        GOLD_LANCE_WEIGHT = (Double)Server.GOLD_LANCE_WEIGHT.get();
        DIAMOND_LANCE_WEIGHT = (Double)Server.DIAMOND_LANCE_WEIGHT.get();
        EMERALD_LANCE_WEIGHT = (Double)Server.EMERALD_LANCE_WEIGHT.get();
        NETHERITE_LANCE_WEIGHT = (Double)Server.NETHERITE_LANCE_WEIGHT.get();
    }

    public static ForgeConfigSpec.DoubleValue doubleconfig(ForgeConfigSpec.Builder builder, String comment, String tkey, double def, double min, double max) {
        return builder.comment(comment).translation(JConfig.translation_key(tkey)).defineInRange(tkey, def, min, max);
    }

    public static ForgeConfigSpec.IntValue intconfig(ForgeConfigSpec.Builder builder, String comment, String tkey, int def, int min, int max) {
        return builder.comment(comment).translation(JConfig.translation_key(tkey)).defineInRange(tkey, def, min, max);
    }

    public static ForgeConfigSpec.BooleanValue booleanconfig(ForgeConfigSpec.Builder builder, String comment, String tkey, boolean def) {
        return builder.comment(comment).translation(JConfig.translation_key(tkey)).define(tkey, def);
    }

    public static ForgeConfigSpec.ConfigValue<List<? extends String>> stringlistconfig(ForgeConfigSpec.Builder builder, String comment, String tkey, String[] def) {
        return builder.comment(comment).translation(JConfig.translation_key(tkey)).defineList(tkey, Arrays.asList(def), o -> o instanceof String);
    }

    public static String translation_key(String s) {
        return "jousting.config." + s.toLowerCase() + ".name";
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
        JConfig.bakeConfigServer();
        specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT = (Client)specPair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        JConfig.bakeConfigClient();
        WOODEN_LANCE_DURABILITY = 320;
        IRON_LANCE_DURABILITY = 600;
        GOLD_LANCE_DURABILITY = 400;
        DIAMOND_LANCE_DURABILITY = 1268;
        EMERALD_LANCE_DURABILITY = 1612;
        NETHERITE_LANCE_DURABILITY = 2550;
        WOODEN_LANCE_DAMAGE = 3.0;
        IRON_LANCE_DAMAGE = 6.0;
        GOLD_LANCE_DAMAGE = 4.5;
        DIAMOND_LANCE_DAMAGE = 6.5;
        EMERALD_LANCE_DAMAGE = 4.0;
        NETHERITE_LANCE_DAMAGE = 5.5;
        WOODEN_LANCE_WEIGHT = 1.3f;
        IRON_LANCE_WEIGHT = 2.0;
        GOLD_LANCE_WEIGHT = 1.5;
        DIAMOND_LANCE_WEIGHT = 3.0;
        EMERALD_LANCE_WEIGHT = 1.0;
        NETHERITE_LANCE_WEIGHT = 2.2f;
    }

    public static class Server {
        public static ForgeConfigSpec.IntValue WOODEN_LANCE_DURABILITY;
        public static ForgeConfigSpec.IntValue IRON_LANCE_DURABILITY;
        public static ForgeConfigSpec.IntValue GOLD_LANCE_DURABILITY;
        public static ForgeConfigSpec.IntValue DIAMOND_LANCE_DURABILITY;
        public static ForgeConfigSpec.IntValue EMERALD_LANCE_DURABILITY;
        public static ForgeConfigSpec.IntValue NETHERITE_LANCE_DURABILITY;
        public static ForgeConfigSpec.DoubleValue WOODEN_LANCE_DAMAGE;
        public static ForgeConfigSpec.DoubleValue IRON_LANCE_DAMAGE;
        public static ForgeConfigSpec.DoubleValue GOLD_LANCE_DAMAGE;
        public static ForgeConfigSpec.DoubleValue DIAMOND_LANCE_DAMAGE;
        public static ForgeConfigSpec.DoubleValue EMERALD_LANCE_DAMAGE;
        public static ForgeConfigSpec.DoubleValue NETHERITE_LANCE_DAMAGE;
        public static ForgeConfigSpec.DoubleValue WOODEN_LANCE_WEIGHT;
        public static ForgeConfigSpec.DoubleValue IRON_LANCE_WEIGHT;
        public static ForgeConfigSpec.DoubleValue GOLD_LANCE_WEIGHT;
        public static ForgeConfigSpec.DoubleValue DIAMOND_LANCE_WEIGHT;
        public static ForgeConfigSpec.DoubleValue EMERALD_LANCE_WEIGHT;
        public static ForgeConfigSpec.DoubleValue NETHERITE_LANCE_WEIGHT;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("wooden");
            WOODEN_LANCE_DURABILITY = JConfig.intconfig(builder, "Wooden Lance Durability", "WOODEN_LANCE_DURABILITY", 320, 0, 10000000);
            WOODEN_LANCE_DAMAGE = JConfig.doubleconfig(builder, "Wooden Lance Damage", "WOODEN_LANCE_DAMAGE", 3.0, 0.0, 1.0E7);
            WOODEN_LANCE_WEIGHT = JConfig.doubleconfig(builder, "Wooden Lance Weight", "WOODEN_LANCE_WEIGHT", 1.3f, 0.0, 1.0E7);
            builder.pop();
            builder.push("iron");
            IRON_LANCE_DURABILITY = JConfig.intconfig(builder, "Iron Lance Durability", "IRON_LANCE_DURABILITY", 600, 0, 10000000);
            IRON_LANCE_DAMAGE = JConfig.doubleconfig(builder, "Iron Lance Damage", "IRON_LANCE_DAMAGE", 6.0, 0.0, 1.0E7);
            IRON_LANCE_WEIGHT = JConfig.doubleconfig(builder, "Iron Lance Weight", "IRON_LANCE_WEIGHT", 2.0, 0.0, 1.0E7);
            builder.pop();
            builder.push("gold");
            GOLD_LANCE_DURABILITY = JConfig.intconfig(builder, "Gold Lance Durability", "GOLD_LANCE_DURABILITY", 400, 0, 10000000);
            GOLD_LANCE_DAMAGE = JConfig.doubleconfig(builder, "Gold Lance Damage", "GOLD_LANCE_DAMAGE", 4.5, 0.0, 1.0E7);
            GOLD_LANCE_WEIGHT = JConfig.doubleconfig(builder, "Gold Lance Weight", "GOLD_LANCE_WEIGHT", 1.5, 0.0, 1.0E7);
            builder.pop();
            builder.push("diamond");
            DIAMOND_LANCE_DURABILITY = JConfig.intconfig(builder, "Diamond Lance Durability", "DIAMOND_LANCE_DURABILITY", 1268, 0, 10000000);
            DIAMOND_LANCE_DAMAGE = JConfig.doubleconfig(builder, "Diamond Lance Damage", "DIAMOND_LANCE_DAMAGE", 6.5, 0.0, 1.0E7);
            DIAMOND_LANCE_WEIGHT = JConfig.doubleconfig(builder, "Diamond Lance Weight", "DIAMOND_LANCE_WEIGHT", 3.0, 0.0, 1.0E7);
            builder.pop();
            builder.push("emerald");
            EMERALD_LANCE_DURABILITY = JConfig.intconfig(builder, "Emerald Lance Durability", "EMERALD_LANCE_DURABILITY", 1612, 0, 10000000);
            EMERALD_LANCE_DAMAGE = JConfig.doubleconfig(builder, "Emerald Lance Damage", "EMERALD_LANCE_DAMAGE", 4.0, 0.0, 1.0E7);
            EMERALD_LANCE_WEIGHT = JConfig.doubleconfig(builder, "Emerald Lance Weight", "EMERALD_LANCE_WEIGHT", 1.0, 0.0, 1.0E7);
            builder.pop();
            builder.push("netherite");
            NETHERITE_LANCE_DURABILITY = JConfig.intconfig(builder, "Netherite Lance Durability", "NETHERITE_LANCE_DURABILITY", 2550, 0, 10000000);
            NETHERITE_LANCE_DAMAGE = JConfig.doubleconfig(builder, "Netherite Lance Damage", "NETHERITE_LANCE_DAMAGE", 5.5, 0.0, 1.0E7);
            NETHERITE_LANCE_WEIGHT = JConfig.doubleconfig(builder, "Netherite Lance Weight", "NETHERITE_LANCE_WEIGHT", 2.2f, 0.0, 1.0E7);
            builder.pop();
        }
    }

    public static class Client {
        public Client(ForgeConfigSpec.Builder builder) {
        }
    }
}

