/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.common.blocks;

import blusunrize.immersiveengineering.api.IPostBlock;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twistedgate.immersiveposts.common.blocks.GenericPostBlock;
import twistedgate.immersiveposts.common.blocks.PostBlock;
import twistedgate.immersiveposts.enums.EnumHTrussType;
import twistedgate.immersiveposts.enums.EnumPostMaterial;

public class HorizontalTrussBlock
extends GenericPostBlock
implements IPostBlock,
IWaterLoggable {
    public static final BooleanProperty CONNECTOR_POINT_TOP = BooleanProperty.func_177716_a((String)"connector_point_top");
    public static final BooleanProperty CONNECTOR_POINT_BOTTOM = BooleanProperty.func_177716_a((String)"connector_point_bottom");
    public static final BooleanProperty PANEL_NORTH = BooleanProperty.func_177716_a((String)"panel_north");
    public static final BooleanProperty PANEL_EAST = BooleanProperty.func_177716_a((String)"panel_east");
    public static final BooleanProperty PANEL_SOUTH = BooleanProperty.func_177716_a((String)"panel_south");
    public static final BooleanProperty PANEL_WEST = BooleanProperty.func_177716_a((String)"panel_west");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final EnumProperty<EnumHTrussType> TYPE = EnumProperty.func_177709_a((String)"type", EnumHTrussType.class);
    static final VoxelShape NORTH_SOUTH = VoxelShapes.func_197873_a((double)0.3125, (double)0.0, (double)0.0, (double)0.6875, (double)1.0, (double)1.0);
    static final VoxelShape EAST_WEST = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.3125, (double)1.0, (double)1.0, (double)0.6875);
    private static final VoxelShape[] SHAPE_CACHE = new VoxelShape[32];

    public HorizontalTrussBlock(EnumPostMaterial postMaterial) {
        super(postMaterial, "_truss");
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(TYPE, (Comparable)((Object)EnumHTrussType.SINGLE))).func_206870_a((Property)CONNECTOR_POINT_TOP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)CONNECTOR_POINT_BOTTOM, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)PANEL_NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)PANEL_EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)PANEL_SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)PANEL_WEST, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED, FACING, TYPE, PANEL_NORTH, PANEL_EAST, PANEL_SOUTH, PANEL_WEST, CONNECTOR_POINT_TOP, CONNECTOR_POINT_BOTTOM});
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 0;
    }

    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) == false;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        FluidState fs = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fs.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        boolean b0 = PostBlock.canConnect((IBlockReader)world, pos, Direction.UP);
        boolean b1 = PostBlock.canConnect((IBlockReader)world, pos, Direction.DOWN) || world.func_180495_p(pos.func_177972_a(Direction.DOWN)).func_177230_c() instanceof PostBlock;
        return (BlockState)((BlockState)state.func_206870_a((Property)CONNECTOR_POINT_TOP, (Comparable)Boolean.valueOf(b0))).func_206870_a((Property)CONNECTOR_POINT_BOTTOM, (Comparable)Boolean.valueOf(b1));
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.postMaterial == EnumPostMaterial.URANIUM && rand.nextFloat() < 0.125f) {
            double x = (double)pos.func_177958_n() + 0.375 + 0.25 * rand.nextDouble();
            double y = (double)pos.func_177956_o() + rand.nextDouble();
            double z = (double)pos.func_177952_p() + 0.375 + 0.25 * rand.nextDouble();
            worldIn.func_195594_a((IParticleData)PostBlock.URAN_PARTICLE, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return false;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.postMaterial.getItemStack();
    }

    public boolean canConnectTransformer(IBlockReader world, BlockPos pos) {
        return true;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult hit) {
        ItemStack held;
        if (!worldIn.field_72995_K && Utils.isHammer((ItemStack)(held = playerIn.func_184614_ca()))) {
            Direction face = hit.func_216354_b();
            Direction facing = (Direction)state.func_177229_b((Property)FACING);
            BlockState newState = state;
            switch (facing) {
                case NORTH: 
                case SOUTH: {
                    if (face == Direction.EAST) {
                        newState = (BlockState)newState.func_206870_a((Property)PANEL_EAST, (Comparable)Boolean.valueOf((Boolean)newState.func_177229_b((Property)PANEL_EAST) == false));
                        break;
                    }
                    if (face != Direction.WEST) break;
                    newState = (BlockState)newState.func_206870_a((Property)PANEL_WEST, (Comparable)Boolean.valueOf((Boolean)newState.func_177229_b((Property)PANEL_WEST) == false));
                    break;
                }
                case EAST: 
                case WEST: {
                    if (face == Direction.NORTH) {
                        newState = (BlockState)newState.func_206870_a((Property)PANEL_NORTH, (Comparable)Boolean.valueOf((Boolean)newState.func_177229_b((Property)PANEL_NORTH) == false));
                        break;
                    }
                    if (face != Direction.SOUTH) break;
                    newState = (BlockState)newState.func_206870_a((Property)PANEL_SOUTH, (Comparable)Boolean.valueOf((Boolean)newState.func_177229_b((Property)PANEL_SOUTH) == false));
                    break;
                }
            }
            if (!newState.equals(state)) {
                worldIn.func_175656_a(pos, newState);
                return ActionResultType.SUCCESS;
            }
        }
        if (Utils.isHammer((ItemStack)playerIn.func_184614_ca())) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (world.field_72995_K) {
            return;
        }
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        BlockPos posA = pos.func_177972_a(facing);
        BlockPos posB = pos.func_177972_a(facing.func_176734_d());
        BlockState stateA = world.func_180495_p(posA);
        BlockState stateB = world.func_180495_p(posB);
        if (stateA.func_177230_c().isAir(stateA, (IBlockReader)world, posA) || stateB.func_177230_c().isAir(stateB, (IBlockReader)world, posB) || stateA.func_177230_c() == Blocks.field_150355_j || stateB.func_177230_c() == Blocks.field_150355_j) {
            this.replaceSelf(state, world, pos);
            return;
        }
    }

    private static int getCacheIndex(Direction.Axis axis, boolean panelNorth, boolean panelEast, boolean panelSouth, boolean panelWest) {
        int result;
        int n = result = axis == Direction.Axis.X ? 1 : 0;
        if (panelNorth) {
            result |= 2;
        }
        if (panelEast) {
            result |= 4;
        }
        if (panelSouth) {
            result |= 8;
        }
        if (panelWest) {
            result |= 0x10;
        }
        return result;
    }

    private static VoxelShape computeShape(Direction.Axis axis, boolean panelNorth, boolean panelEast, boolean panelSouth, boolean panelWest) {
        VoxelShape shape = null;
        switch (axis) {
            case Z: {
                shape = NORTH_SOUTH;
                break;
            }
            case X: {
                shape = EAST_WEST;
                break;
            }
        }
        if (shape == null) {
            return VoxelShapes.func_197880_a();
        }
        if (panelNorth) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (panelEast) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (panelSouth) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (panelEast) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return shape.func_197753_c();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction.Axis axis = ((Direction)state.func_177229_b((Property)FACING)).func_176740_k();
        if (axis != Direction.Axis.X && axis != Direction.Axis.Z) {
            return VoxelShapes.func_197880_a();
        }
        return SHAPE_CACHE[HorizontalTrussBlock.getCacheIndex(axis, (Boolean)state.func_177229_b((Property)PANEL_NORTH), (Boolean)state.func_177229_b((Property)PANEL_EAST), (Boolean)state.func_177229_b((Property)PANEL_SOUTH), (Boolean)state.func_177229_b((Property)PANEL_WEST))];
    }

    static {
        boolean[] bools = new boolean[]{false, true};
        for (Direction.Axis axis : new Direction.Axis[]{Direction.Axis.X, Direction.Axis.Z}) {
            for (boolean north : bools) {
                for (boolean east : bools) {
                    for (boolean south : bools) {
                        for (boolean west : bools) {
                            HorizontalTrussBlock.SHAPE_CACHE[HorizontalTrussBlock.getCacheIndex((Direction.Axis)axis, (boolean)north, (boolean)east, (boolean)south, (boolean)west)] = HorizontalTrussBlock.computeShape(axis, north, east, south, west);
                        }
                    }
                }
            }
        }
    }
}

