/*
 * Decompiled with CFR 0.152.
 */
package commoble.entitydetectors.blocks;

import commoble.entitydetectors.blocks.MobDetectorItemHandler;
import commoble.entitydetectors.blocks.TileEntityRegistrar;
import commoble.entitydetectors.items.ImprintedSlimeballItem;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class MobDetectorTileEntity
extends TileEntity {
    public static final String FILTER_KEY = "filter";
    public ItemStack slimeStack = ItemStack.field_190927_a;
    public final IItemHandler itemHandler = new MobDetectorItemHandler(this);

    public MobDetectorTileEntity() {
        super(TileEntityRegistrar.MOB_DETECTOR);
    }

    public boolean isEntityDetectable(Entity ent) {
        return ImprintedSlimeballItem.getEntityType(this.slimeStack).map(type -> type == ent.func_200600_R()).orElse(true);
    }

    public Optional<EntityType<?>> getFilteredEntityType() {
        return ImprintedSlimeballItem.getEntityType(this.slimeStack);
    }

    public ActionResultType onRightClickWithSlime(PlayerEntity player, ItemStack stack, World world, BlockPos pos) {
        this.dropSlime(world, pos);
        ItemStack remainder = this.itemHandler.insertItem(0, stack, false);
        stack.func_190920_e(remainder.func_190916_E());
        this.func_70296_d();
        world.func_184138_a(pos, this.func_195044_w(), this.func_195044_w(), 2);
        return ActionResultType.SUCCESS;
    }

    private void dropSlime(World worldIn, BlockPos pos) {
        ItemStack extractedStack;
        if (!worldIn.field_72995_K && !(extractedStack = this.itemHandler.extractItem(0, 1, false)).func_190926_b()) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187900_fz, SoundCategory.BLOCKS, 0.1f + this.field_145850_b.field_73012_v.nextFloat() * 0.3f, this.field_145850_b.field_73012_v.nextFloat() * 1.5f + 1.0f);
            float f = 0.7f;
            double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
            double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, extractedStack.func_77946_l());
            itementity.func_174869_p();
            worldIn.func_217376_c((Entity)itementity);
        }
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.itemHandler).cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.readData(compound);
    }

    public void readData(CompoundNBT compound) {
        if (compound.func_74764_b(FILTER_KEY)) {
            this.slimeStack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l(FILTER_KEY));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT nbt = super.func_189515_b(compound);
        CompoundNBT itemNBT = this.slimeStack.func_77955_b(new CompoundNBT());
        nbt.func_218657_a(FILTER_KEY, (INBT)itemNBT);
        return nbt;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readData(pkt.func_148857_g());
    }
}

