/*
 * Decompiled with CFR 0.152.
 */
package commoble.entitydetectors.blocks;

import commoble.entitydetectors.blocks.EntityDetectorBlock;
import commoble.entitydetectors.blocks.MobDetectorItemHandler;
import commoble.entitydetectors.blocks.MobDetectorTileEntity;
import commoble.entitydetectors.blocks.TileEntityRegistrar;
import commoble.entitydetectors.util.WorldHelper;
import java.util.function.Predicate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class MobDetectorBlock
extends EntityDetectorBlock {
    public MobDetectorBlock(AbstractBlock.Properties properties) {
        super(MobEntity.class, properties);
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        if (MobDetectorItemHandler.isItemValidFilter(stack)) {
            return WorldHelper.getTileEntityAt(MobDetectorTileEntity.class, (IWorldReader)world, pos).map(te -> te.onRightClickWithSlime(player, stack, world, pos)).orElseGet(() -> super.func_225533_a_(state, world, pos, player, hand, hit));
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    @Override
    public <T extends Entity> Predicate<T> getEntityFilter(IWorld world, BlockPos pos) {
        return entity -> WorldHelper.getTileEntityAt(MobDetectorTileEntity.class, (IWorldReader)world, pos).map(te -> te.isEntityDetectable((Entity)entity)).orElse(true);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return TileEntityRegistrar.MOB_DETECTOR.func_200968_a();
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            WorldHelper.getTileEntityAt(MobDetectorTileEntity.class, (IWorldReader)world, pos).ifPresent(te -> InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)te.slimeStack));
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }
}

