/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.drop;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.drop.BiomeList;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.drop.Drop;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.drop.DropTarget;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.drop.FocusList;
import com.valkyrieofnight.envirotech.m_voidminer.datapack.voidregistry.drop.IAddToDropList;
import com.valkyrieofnight.vlib.core.util.annotations.Nullable;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class DimList
implements IAddToDropList {
    private final VLID dim;
    private volatile CopyOnWriteArrayList<Drop> unfocused = Lists.newCopyOnWriteArrayList();
    private volatile ConcurrentMap<VLID, FocusList> focused = Maps.newConcurrentMap();
    private volatile ConcurrentMap<VLID, BiomeList> biomeLists = Maps.newConcurrentMap();
    private volatile CopyOnWriteArrayList<VLID> blacklisted = Lists.newCopyOnWriteArrayList();

    public DimList(VLID dim) {
        this.dim = dim;
    }

    public String toString() {
        return super.toString();
    }

    @Override
    public void addToDropList(Map<VLID, Drop> drops, int tier, @Nullable VLID focus, float focusWeightMultiplier, DropTarget dropTarget, @Nullable VLID dim, @Nullable VLID biome) {
        if (biome != null && this.biomeLists.containsKey(biome)) {
            ((BiomeList)this.biomeLists.get(biome)).addToDropList(drops, tier, focus, focusWeightMultiplier, dropTarget, dim, biome);
        } else if (dropTarget.isAnyBiome()) {
            for (BiomeList bl : this.biomeLists.values()) {
                bl.addToDropList(drops, tier, focus, focusWeightMultiplier, dropTarget, null, null);
            }
        }
        if (focus != null && this.focused.containsKey(focus)) {
            ((FocusList)this.focused.get(focus)).addToDropList(drops, tier, focus, focusWeightMultiplier, dropTarget, dim, biome);
        }
        for (Drop d : this.unfocused) {
            if (!d.isValid() || !d.tiers.contains(tier) || !this.canAddDrop(d, dropTarget, dim, biome)) continue;
            drops.putIfAbsent(d.recipeID, d);
        }
    }

    public void register(Drop d, List<VLID> biomes, VLID focus) {
        if (d == null) {
            return;
        }
        if (biomes == null || biomes.isEmpty()) {
            if (focus == null) {
                this.unfocused.add(d);
            } else {
                this.focused.computeIfAbsent(focus, fid -> new FocusList((VLID)fid));
                this.focused.computeIfPresent(focus, (vlid, focusList) -> {
                    focusList.register(d);
                    return focusList;
                });
            }
        } else {
            for (VLID biome : biomes) {
                this.biomeLists.computeIfAbsent(biome, bid -> new BiomeList((VLID)bid));
                this.biomeLists.computeIfPresent(biome, (bid, biomeList) -> {
                    biomeList.register(d, focus);
                    return biomeList;
                });
            }
        }
    }
}

