/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common.logic.entityblocking.megatorch;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.World;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.TorchmasterConfig;
import net.xalcon.torchmaster.common.ModBlocks;
import net.xalcon.torchmaster.common.logic.DistanceLogics;
import net.xalcon.torchmaster.common.logic.entityblocking.IEntityBlockingLight;

public class MegatorchEntityBlockingLight
implements IEntityBlockingLight {
    public static final VoxelShape SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private BlockPos pos;

    public MegatorchEntityBlockingLight(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public boolean shouldBlockEntity(Entity entity, BlockPos pos) {
        return Torchmaster.MegaTorchFilterRegistry.containsEntity(entity.func_200600_R().getRegistryName()) && DistanceLogics.Cubic.isPositionInRange(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), this.pos, (Integer)TorchmasterConfig.GENERAL.megaTorchRadius.get());
    }

    @Override
    public String getLightSerializerKey() {
        return "megatorch";
    }

    @Override
    public boolean cleanupCheck(World world) {
        return world.func_175667_e(this.pos) && world.func_180495_p(this.pos).func_177230_c() != ModBlocks.blockMegaTorch;
    }

    @Override
    public String getName() {
        return "Mega Torch";
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }
}

