/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.spawner.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import mcjty.rftoolsutility.modules.spawner.recipes.SpawnerRecipe;
import mcjty.rftoolsutility.modules.spawner.recipes.SpawnerRecipes;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SpawnerRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<SpawnerRecipe> {
    public SpawnerRecipe fromJson(ResourceLocation recipeId, JsonObject root) {
        ResourceLocation id = new ResourceLocation(root.getAsJsonPrimitive("id").getAsString());
        int power = root.getAsJsonPrimitive("power").getAsInt();
        SpawnerRecipes.MobSpawnAmount item1 = this.readSpawnAmount(root, "item1");
        SpawnerRecipes.MobSpawnAmount item2 = this.readSpawnAmount(root, "item2");
        SpawnerRecipes.MobSpawnAmount item3 = this.readSpawnAmount(root, "item3");
        ResourceLocation entity = new ResourceLocation(root.getAsJsonPrimitive("entity").getAsString());
        return new SpawnerRecipe(id, item1, item2, item3, power, entity);
    }

    private SpawnerRecipes.MobSpawnAmount readSpawnAmount(JsonObject root, String tag) {
        SpawnerRecipes.MobSpawnAmount item1;
        JsonObject item1Object = root.getAsJsonObject(tag);
        float amount = item1Object.get("amount").getAsFloat();
        if (item1Object.has("living")) {
            item1 = new SpawnerRecipes.MobSpawnAmount(Ingredient.field_193370_a, amount);
        } else {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)item1Object.get("ingredient"));
            item1 = new SpawnerRecipes.MobSpawnAmount(ingredient, amount);
        }
        return item1;
    }

    @Nullable
    public SpawnerRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
        ResourceLocation id = buffer.func_192575_l();
        int power = buffer.readInt();
        SpawnerRecipes.MobSpawnAmount item1 = this.readSpawnAmount(buffer);
        SpawnerRecipes.MobSpawnAmount item2 = this.readSpawnAmount(buffer);
        SpawnerRecipes.MobSpawnAmount item3 = this.readSpawnAmount(buffer);
        ResourceLocation entity = buffer.func_192575_l();
        return new SpawnerRecipe(id, item1, item2, item3, power, entity);
    }

    private SpawnerRecipes.MobSpawnAmount readSpawnAmount(PacketBuffer buffer) {
        SpawnerRecipes.MobSpawnAmount item1;
        float amount = buffer.readFloat();
        if (buffer.readBoolean()) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            item1 = new SpawnerRecipes.MobSpawnAmount(ingredient, amount);
        } else {
            item1 = new SpawnerRecipes.MobSpawnAmount(Ingredient.field_193370_a, amount);
        }
        return item1;
    }

    public void toNetwork(PacketBuffer buffer, SpawnerRecipe recipe) {
        buffer.func_192572_a(recipe.func_199560_c());
        buffer.writeInt(recipe.getSpawnRf());
        this.writeMobAmount(buffer, recipe.getItem1());
        this.writeMobAmount(buffer, recipe.getItem2());
        this.writeMobAmount(buffer, recipe.getItem3());
        buffer.func_192572_a(recipe.getEntity());
    }

    private void writeMobAmount(PacketBuffer buffer, SpawnerRecipes.MobSpawnAmount item) {
        boolean hasIngredient = item.getObject() != null;
        buffer.writeFloat(item.getAmount());
        buffer.writeBoolean(hasIngredient);
        if (hasIngredient) {
            item.getObject().func_199564_a(buffer);
        }
    }
}

