/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.spawner.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Rectangle;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsutility.modules.spawner.SpawnerConfiguration;
import mcjty.rftoolsutility.modules.spawner.SpawnerModule;
import mcjty.rftoolsutility.modules.spawner.blocks.SpawnerTileEntity;
import mcjty.rftoolsutility.modules.spawner.items.SyringeItem;
import mcjty.rftoolsutility.modules.spawner.recipes.SpawnerRecipes;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class GuiSpawner
extends GenericGuiContainer<SpawnerTileEntity, GenericContainer> {
    private static final int SPAWNER_WIDTH = 180;
    private static final int SPAWNER_HEIGHT = 152;
    private EnergyBar energyBar;
    private BlockRender[] blocks = new BlockRender[3];
    private Label[] labels = new Label[3];
    private Label name;
    private Label rfTick;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolsutility", "textures/gui/spawner.png");
    private static long lastTime = 0L;

    public GuiSpawner(SpawnerTileEntity spawnerTileEntity, GenericContainer container, PlayerInventory inventory) {
        super((GenericTileEntity)spawnerTileEntity, (Container)container, inventory, ((BaseBlock)SpawnerModule.SPAWNER.get()).getManualEntry());
        this.field_146999_f = 180;
        this.field_147000_g = 152;
    }

    public static void register() {
        GuiSpawner.register((ContainerType)((ContainerType)SpawnerModule.CONTAINER_SPAWNER.get()), GuiSpawner::new);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.energyBar = ((EnergyBar)new EnergyBar().vertical().hint(10, 7, 8, 54)).showText(false);
        this.blocks[0] = (BlockRender)new BlockRender().hint(100, 5, 18, 18);
        this.blocks[1] = (BlockRender)new BlockRender().hint(100, 25, 18, 18);
        this.blocks[2] = (BlockRender)new BlockRender().hint(100, 45, 18, 18);
        this.labels[0] = (Label)Widgets.label((int)120, (int)5, (int)74, (int)18, (String)"").horizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        this.labels[1] = (Label)Widgets.label((int)120, (int)25, (int)74, (int)18, (String)"").horizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        this.labels[2] = (Label)Widgets.label((int)120, (int)45, (int)74, (int)18, (String)"").horizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        this.name = (Label)Widgets.label((int)22, (int)31, (int)78, (int)16, (String)"").horizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        this.rfTick = (Label)Widgets.label((int)22, (int)47, (int)78, (int)16, (String)"").horizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        Panel toplevel = (Panel)((Panel)new Panel().background(iconLocation)).layout((Layout)new PositionalLayout()).children(new Widget[]{this.energyBar, this.blocks[0], this.labels[0], this.blocks[1], this.labels[1], this.blocks[2], this.labels[2], this.rfTick, this.name});
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
    }

    private void showSyringeInfo() {
        for (int i = 0; i < 3; ++i) {
            this.blocks[i].renderItem(null);
            this.labels[i].text("");
        }
        this.name.text("");
        this.rfTick.text("");
        ItemStack stack = ((SpawnerTileEntity)this.tileEntity).getItems().getStackInSlot(0);
        if (stack.func_190926_b()) {
            return;
        }
        String mobId = SyringeItem.getMobId(stack);
        if (mobId != null) {
            String mobName = SyringeItem.getMobName(stack);
            this.name.text(mobName);
            SpawnerRecipes.MobData mobData = SpawnerRecipes.getMobData((World)Minecraft.func_71410_x().field_71441_e, mobId);
            if (mobData != null) {
                this.rfTick.text(mobData.getSpawnRf() + "RF");
                int i = 0;
                if (System.currentTimeMillis() - lastTime > 100L) {
                    lastTime = System.currentTimeMillis();
                    ((SpawnerTileEntity)this.tileEntity).requestDataFromServer(RFToolsUtilityMessages.INSTANCE, "getSpawnerInfo", TypedMap.EMPTY);
                }
                float[] matter = new float[]{SpawnerTileEntity.matterReceived0, SpawnerTileEntity.matterReceived1, SpawnerTileEntity.matterReceived2};
                for (int index = 0; index < 3; ++index) {
                    SpawnerRecipes.MobSpawnAmount item = mobData.getItem(index);
                    ItemStack[] matchingStacks = item.getObject().func_193365_a();
                    float amount = item.getAmount();
                    if (matchingStacks.length == 0) {
                        ITag itemTag = ItemTags.func_199903_a().func_199910_a(SpawnerConfiguration.LIVING);
                        if (itemTag == null) {
                            this.blocks[i].renderItem((Object)new ItemStack((IItemProvider)Blocks.field_150357_h, 1));
                        } else {
                            ArrayList items = new ArrayList(itemTag.func_230236_b_());
                            int idx = (int)(System.currentTimeMillis() / 500L % (long)items.size());
                            this.blocks[i].renderItem((Object)new ItemStack((IItemProvider)((Item)items.get(idx)), 1));
                        }
                    } else {
                        int idx = (int)(System.currentTimeMillis() / 500L % (long)matchingStacks.length);
                        ItemStack b = matchingStacks[idx];
                        this.blocks[i].renderItem((Object)b);
                    }
                    DecimalFormat format = new DecimalFormat("#.##");
                    format.setRoundingMode(RoundingMode.DOWN);
                    String mf = format.format(matter[i]);
                    this.labels[i].text(mf + "/" + Float.toString(amount));
                    ++i;
                }
            }
        }
    }

    protected void func_230450_a_(MatrixStack matrixStack, float v, int i, int i2) {
        this.showSyringeInfo();
        this.drawWindow(matrixStack);
        this.updateEnergyBar(this.energyBar);
    }
}

