/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.spawner.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IValue;
import mcjty.lib.container.AutomationFilterItemHander;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.NoDirectionItemHander;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbase.RFToolsBase;
import mcjty.rftoolsutility.modules.spawner.SpawnerConfiguration;
import mcjty.rftoolsutility.modules.spawner.SpawnerModule;
import mcjty.rftoolsutility.modules.spawner.blocks.SpawnerTileEntity;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;

public class MatterBeamerTileEntity
extends GenericTileEntity
implements ITickableTileEntity {
    public static final int TICKTIME = 20;
    public static final int SLOT_MATERIAL = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).slot(SlotDefinition.generic().in(), "container", 0, 28, 8).playerSlots(10, 70));
    private final NoDirectionItemHander items = this.createItemHandler();
    private final LazyOptional<AutomationFilterItemHander> itemHandler = LazyOptional.of(() -> new AutomationFilterItemHander(this.items));
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)SpawnerConfiguration.BEAMER_MAXENERGY, (long)SpawnerConfiguration.BEAMER_RECEIVEPERTICK);
    private final LazyOptional<GenericEnergyStorage> energyHandler = LazyOptional.of(() -> this.energyStorage);
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Matter Beamer").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)SpawnerModule.CONTAINER_MATTER_BEAMER.get(), windowId.intValue(), (ContainerFactory)CONTAINER_FACTORY.get(), this.func_174877_v(), (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage));
    private final IInfusable infusable = new DefaultInfusable((TileEntity)this);
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> this.infusable);
    public static final Key<BlockPos> VALUE_DESTINATION = new Key("destination", Type.BLOCKPOS);
    private BlockPos destination = null;
    private boolean glowing = false;
    private int ticker = 20;

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_DESTINATION, this::getDestination, this::setDestination)};
    }

    public MatterBeamerTileEntity() {
        super((TileEntityType)SpawnerModule.TYPE_MATTER_BEAMER.get());
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.checkStateServer();
        }
    }

    public boolean isPowered() {
        return this.powerLevel != 0;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    private void checkStateServer() {
        if (this.powerLevel == 0) {
            this.disableBlockGlow();
            return;
        }
        --this.ticker;
        if (this.ticker > 0) {
            return;
        }
        this.ticker = 20;
        TileEntity te = null;
        if (this.destination != null) {
            te = this.field_145850_b.func_175625_s(this.destination);
            if (!(te instanceof SpawnerTileEntity)) {
                this.setDestination(null);
                return;
            }
        } else {
            return;
        }
        ItemStack itemStack = this.items.getStackInSlot(0);
        if (itemStack.func_190926_b()) {
            this.disableBlockGlow();
            return;
        }
        SpawnerTileEntity spawnerTileEntity = (SpawnerTileEntity)te;
        int maxblocks = (int)((double)SpawnerConfiguration.beamBlocksPerSend * (1.01 + (double)this.infusable.getInfusedFactor() * 2.0));
        int numblocks = Math.min(maxblocks, itemStack.func_190916_E());
        int rf = (int)((float)(SpawnerConfiguration.beamRfPerObject * numblocks) * (4.0f - this.infusable.getInfusedFactor()) / 4.0f);
        if (this.energyStorage.getEnergyStored() < rf) {
            return;
        }
        this.energyStorage.consumeEnergy((long)rf);
        if (spawnerTileEntity.addMatter(itemStack, numblocks, this.infusable.getInfusedFactor())) {
            this.items.decrStackSize(0, numblocks);
            this.enableBlockGlow();
        }
    }

    private void disableBlockGlow() {
        if (this.glowing) {
            this.glowing = false;
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(this.glowing)), 3);
            this.markDirtyQuick();
        }
    }

    private void enableBlockGlow() {
        if (!this.glowing) {
            this.glowing = true;
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(this.glowing)), 3);
            this.markDirtyQuick();
        }
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        boolean oldglowing = this.glowing;
        super.onDataPacket(net, packet);
        super.onDataPacket(net, packet);
        if (this.field_145850_b.field_72995_K && oldglowing != this.glowing) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(this.glowing)), 3);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        return new AxisAlignedBB((double)(xCoord - 4), (double)(yCoord - 4), (double)(zCoord - 4), (double)(xCoord + 5), (double)(yCoord + 5), (double)(zCoord + 5));
    }

    public boolean wrenchUse(World world, BlockPos pos, Direction side, PlayerEntity player) {
        if (world.field_72995_K) {
            world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_189107_dL, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            this.useWrench(player);
        }
        return true;
    }

    private void useWrench(PlayerEntity player) {
        BlockPos coord = RFToolsBase.instance.clientInfo.getSelectedTE();
        TileEntity tileEntity = null;
        if (coord != null) {
            tileEntity = this.field_145850_b.func_175625_s(coord);
        }
        if (!(tileEntity instanceof MatterBeamerTileEntity)) {
            RFToolsBase.instance.clientInfo.setSelectedTE(this.func_174877_v());
            SpawnerTileEntity destinationTE = this.getDestinationTE();
            if (destinationTE == null) {
                RFToolsBase.instance.clientInfo.setDestinationTE(null);
            } else {
                RFToolsBase.instance.clientInfo.setDestinationTE(destinationTE.func_174877_v());
            }
            Logging.message((PlayerEntity)player, (String)"Select a spawner as destination");
        } else if (coord.equals((Object)this.func_174877_v())) {
            RFToolsBase.instance.clientInfo.setSelectedTE(null);
            RFToolsBase.instance.clientInfo.setDestinationTE(null);
            this.setDestination(null);
            Logging.message((PlayerEntity)player, (String)"Destination cleared!");
        }
    }

    public void setDestination(BlockPos destination) {
        this.destination = destination;
        this.disableBlockGlow();
        this.func_70296_d();
        if (this.field_145850_b.field_72995_K) {
            this.valueToServer(RFToolsUtilityMessages.INSTANCE, VALUE_DESTINATION, destination);
        } else {
            this.markDirtyClient();
        }
    }

    public BlockPos getDestination() {
        return this.destination;
    }

    private SpawnerTileEntity getDestinationTE() {
        if (this.destination == null) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.destination);
        if (te instanceof SpawnerTileEntity) {
            return (SpawnerTileEntity)te;
        }
        this.destination = null;
        this.markDirtyClient();
        return null;
    }

    public void read(CompoundNBT tagCompound) {
        super.read(tagCompound);
        this.destination = BlockPosTools.read((CompoundNBT)tagCompound, (String)"dest");
        this.glowing = tagCompound.func_74767_n("glowing");
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        BlockPosTools.write((CompoundNBT)tagCompound, (String)"dest", (BlockPos)this.destination);
        tagCompound.func_74757_a("glowing", this.glowing);
        return tagCompound;
    }

    private NoDirectionItemHander createItemHandler() {
        return new NoDirectionItemHander((GenericTileEntity)this, (ContainerFactory)CONTAINER_FACTORY.get());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyHandler.cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        if (cap == CapabilityInfusable.INFUSABLE_CAPABILITY) {
            return this.infusableHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

