/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modules;

import mcjty.lib.varia.DimensionId;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.data.IModuleDataBoolean;
import mcjty.rftoolsutility.modules.logic.tools.RedstoneChannels;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ButtonScreenModule
implements IScreenModule<IModuleDataBoolean> {
    private String line = "";
    private int channel = -1;
    private boolean toggle;

    public IModuleDataBoolean getData(IScreenDataHelper helper, World worldObj, long millis) {
        if (this.channel != -1 && this.toggle) {
            RedstoneChannels channels = RedstoneChannels.getChannels(worldObj);
            RedstoneChannels.RedstoneChannel ch = channels.getOrCreateChannel(this.channel);
            return helper.createBoolean(ch.getValue() > 0);
        }
        return null;
    }

    public void setupFromNBT(CompoundNBT tagCompound, DimensionId dim, BlockPos pos) {
        if (tagCompound != null) {
            this.line = tagCompound.func_74779_i("text");
            if (tagCompound.func_74764_b("channel")) {
                this.channel = tagCompound.func_74762_e("channel");
            }
            this.toggle = tagCompound.func_74767_n("toggle");
        }
    }

    public void mouseClick(World world, int x, int y, boolean clicked, PlayerEntity player) {
        int xoffset = !this.line.isEmpty() ? 80 : 5;
        if (x >= xoffset) {
            if (this.channel != -1) {
                if (this.toggle) {
                    if (clicked) {
                        RedstoneChannels.RedstoneChannel ch;
                        RedstoneChannels channels = RedstoneChannels.getChannels(world);
                        ch.setValue((ch = channels.getOrCreateChannel(this.channel)).getValue() == 0 ? 15 : 0);
                        channels.save();
                    }
                } else {
                    RedstoneChannels channels = RedstoneChannels.getChannels(world);
                    RedstoneChannels.RedstoneChannel ch = channels.getOrCreateChannel(this.channel);
                    ch.setValue(clicked ? 15 : 0);
                    channels.save();
                }
            } else if (player != null) {
                player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Module is not linked to redstone channel!"), false);
            }
        }
    }

    public int getRfPerTick() {
        return (Integer)ScreenConfiguration.BUTTON_RFPERTICK.get();
    }
}

