/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental.recipes;

import mcjty.rftoolsutility.modules.environmental.EnvironmentalModule;
import mcjty.rftoolsutility.modules.spawner.items.SyringeItem;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class SyringeBasedRecipe
extends ShapedRecipe {
    private final ResourceLocation mobId;

    public SyringeBasedRecipe(ResourceLocation id, String group, int width, int height, NonNullList<Ingredient> ingredients, ItemStack result, ResourceLocation mobId) {
        super(id, group, width, height, SyringeBasedRecipe.addMob(ingredients, mobId), result);
        this.mobId = mobId;
    }

    public SyringeBasedRecipe(ShapedRecipe other, ResourceLocation mobId) {
        super(other.func_199560_c(), other.func_193358_e(), other.func_192403_f(), other.func_192404_g(), SyringeBasedRecipe.addMob((NonNullList<Ingredient>)other.func_192400_c(), mobId), other.func_77571_b());
        this.mobId = mobId;
    }

    private static NonNullList<Ingredient> addMob(NonNullList<Ingredient> input, ResourceLocation mobId) {
        NonNullList output = NonNullList.func_191197_a((int)input.size(), (Object)Ingredient.field_193370_a);
        for (int i = 0; i < input.size(); ++i) {
            Ingredient ingredient = (Ingredient)input.get(i);
            if (!ingredient.func_203189_d() && ingredient.func_193365_a().length > 0 && ingredient.func_193365_a()[0].func_77973_b() instanceof SyringeItem) {
                ItemStack syringe = SyringeItem.createMobSyringe(mobId);
                ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{syringe});
            }
            output.set(i, (Object)ingredient);
        }
        return output;
    }

    public boolean func_77569_a(CraftingInventory inv, World level) {
        boolean matches = super.func_77569_a(inv, level);
        if (matches) {
            for (int i = 0; i < inv.func_174922_i() * inv.func_174923_h(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (!(stack.func_77973_b() instanceof SyringeItem)) continue;
                String mob = SyringeItem.getMobId(stack);
                if (mob == null || !mob.equals(this.mobId.toString())) {
                    return false;
                }
                int amount = SyringeItem.getLevel(stack);
                if (amount >= 100) continue;
                return false;
            }
        }
        return matches;
    }

    public ResourceLocation getMobId() {
        return this.mobId;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)EnvironmentalModule.SYRINGE_SERIALIZER.get();
    }
}

