/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mcjty.lib.client.CustomRenderTypes;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.client.RenderSettings;
import mcjty.rftoolsutility.modules.environmental.EnvironmentalModule;
import mcjty.rftoolsutility.modules.environmental.blocks.EnvironmentalControllerTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class EnvironmentalRenderer
extends TileEntityRenderer<EnvironmentalControllerTileEntity> {
    public static ResourceLocation HALO = new ResourceLocation("rftoolsutility", "effects/floatingsphere");
    private static Random random = new Random();
    private static List<EnvironmentalControllerTileEntity> toRender = new ArrayList<EnvironmentalControllerTileEntity>();
    private static final RenderSettings RENDER_SETTINGS = RenderSettings.builder().color(255, 255, 255).renderType(CustomRenderTypes.TRANSLUCENT_LIGHTNING_NOLIGHTMAPS).alpha(128).build();

    public EnvironmentalRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(EnvironmentalControllerTileEntity te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        if (te.isActive()) {
            toRender.add(te);
        }
    }

    public static void register() {
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)EnvironmentalModule.TYPE_ENVIRONENTAL_CONTROLLER.get()), EnvironmentalRenderer::new);
    }

    public static void renderEnvironmentals(RenderWorldLastEvent event) {
        if (toRender.isEmpty()) {
            return;
        }
        MatrixStack matrixStack = event.getMatrixStack();
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        matrixStack.func_227860_a_();
        Vector3d projectedView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        matrixStack.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
        for (EnvironmentalControllerTileEntity te : toRender) {
            float s = 0.6f + random.nextFloat() * 0.1f;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)te.func_174877_v().func_177958_n(), (double)te.func_174877_v().func_177956_o(), (double)te.func_174877_v().func_177952_p());
            RenderHelper.renderBillboardQuadBright((MatrixStack)matrixStack, (IRenderTypeBuffer)buffer, (float)s, (ResourceLocation)HALO, (RenderSettings)RenderSettings.builder().color(255, 255, 255).renderType(CustomRenderTypes.TRANSLUCENT_LIGHTNING_NOLIGHTMAPS).alpha(128).build());
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
        toRender.clear();
    }
}

