/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.information.CapabilityPowerInformation;
import mcjty.lib.api.information.IPowerInformation;
import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.api.module.CapabilityModuleSupport;
import mcjty.lib.api.module.DefaultModuleSupport;
import mcjty.lib.api.module.IModuleSupport;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.AutomationFilterItemHander;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.NoDirectionItemHander;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.ScrollableLabel;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.environmental.EnvModuleProvider;
import mcjty.rftoolsutility.modules.environmental.EnvironmentalConfiguration;
import mcjty.rftoolsutility.modules.environmental.EnvironmentalModule;
import mcjty.rftoolsutility.modules.environmental.modules.EnvironmentModule;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;

public class EnvironmentalControllerTileEntity
extends GenericTileEntity
implements ITickableTileEntity {
    public static final String CMD_SETRADIUS = "env.setRadius";
    public static final String CMD_RSMODE = "env.setRsMode";
    public static final String CMD_SETBOUNDS = "env.setBounds";
    public static final Key<Integer> PARAM_MIN = new Key("min", Type.INTEGER);
    public static final Key<Integer> PARAM_MAX = new Key("max", Type.INTEGER);
    public static final String CMD_SETMODE = "env.setBlacklist";
    public static final Key<Integer> PARAM_MODE = new Key("mode", Type.INTEGER);
    public static final String CMD_ADDPLAYER = "env.addPlayer";
    public static final String CMD_DELPLAYER = "env.delPlayer";
    public static final Key<String> PARAM_NAME = new Key("name", Type.STRING);
    public static final String CMD_GETPLAYERS = "getPlayers";
    public static final String CLIENTCMD_GETPLAYERS = "getPlayers";
    public static final String COMPONENT_NAME = "environmental_controller";
    public static final int ENV_MODULES = 7;
    public static final int SLOT_MODULES = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(7).box(SlotDefinition.specific(s -> s.func_77973_b() instanceof EnvModuleProvider).in().out(), CONTAINER_INVENTORY, 0, 7, 8, 1, 7).playerSlots(27, 142));
    public static final String CONTAINER_INVENTORY = "container";
    private final NoDirectionItemHander items = this.createItemHandler();
    private final LazyOptional<AutomationFilterItemHander> itemHandler = LazyOptional.of(() -> new AutomationFilterItemHander(this.items));
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)EnvironmentalConfiguration.ENVIRONMENTAL_MAXENERGY.get()).intValue(), (long)((Integer)EnvironmentalConfiguration.ENVIRONMENTAL_RECEIVEPERTICK.get()).intValue());
    private final LazyOptional<GenericEnergyStorage> energyHandler = LazyOptional.of(() -> this.energyStorage);
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((TileEntity)this));
    private final LazyOptional<IPowerInformation> powerInfoHandler = LazyOptional.of(this::createPowerInfo);
    private final LazyOptional<IModuleSupport> moduleSupportHandler = LazyOptional.of(() -> new DefaultModuleSupport(0, 6){

        public boolean isModule(ItemStack itemStack) {
            return itemStack.func_77973_b() instanceof EnvModuleProvider;
        }
    });
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Builder").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)EnvironmentalModule.CONTAINER_ENVIRONENTAL_CONTROLLER.get(), windowId.intValue(), (ContainerFactory)CONTAINER_FACTORY.get(), this.func_174877_v(), (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage));
    private List<EnvironmentModule> environmentModules = null;
    public Set<String> players = new HashSet<String>();
    private EnvironmentalMode mode = EnvironmentalMode.MODE_BLACKLIST;
    private int totalRfPerTick = 0;
    private int radius = 50;
    private int miny = 30;
    private int maxy = 70;
    private int volume = -1;
    private boolean active = false;
    private int powerTimeout = 0;

    public EnvironmentalControllerTileEntity() {
        super((TileEntityType)EnvironmentalModule.TYPE_ENVIRONENTAL_CONTROLLER.get());
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(2.0f).func_200947_a(SoundType.field_185852_e).func_235838_a_(value -> 13)).tileEntitySupplier(EnvironmentalControllerTileEntity::new).topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolsutility:machines/environmental")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()})){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }
        };
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public EnvironmentalMode getMode() {
        return this.mode;
    }

    public void setMode(EnvironmentalMode mode) {
        this.mode = mode;
        this.markDirtyClient();
    }

    private float getPowerMultiplier() {
        switch (this.mode) {
            case MODE_BLACKLIST: 
            case MODE_WHITELIST: {
                return 1.0f;
            }
            case MODE_HOSTILE: 
            case MODE_PASSIVE: 
            case MODE_MOBS: 
            case MODE_ALL: {
                return (float)((Double)EnvironmentalConfiguration.mobsPowerMultiplier.get()).doubleValue();
            }
        }
        return 1.0f;
    }

    public boolean isEntityAffected(Entity entity) {
        switch (this.mode) {
            case MODE_BLACKLIST: {
                if (entity instanceof PlayerEntity) {
                    return this.isPlayerAffected((PlayerEntity)entity);
                }
                return false;
            }
            case MODE_WHITELIST: {
                if (entity instanceof PlayerEntity) {
                    return this.isPlayerAffected((PlayerEntity)entity);
                }
                return false;
            }
            case MODE_HOSTILE: {
                return entity instanceof IMob;
            }
            case MODE_PASSIVE: {
                return entity instanceof MobEntity && !(entity instanceof IMob);
            }
            case MODE_MOBS: {
                return entity instanceof MobEntity;
            }
            case MODE_ALL: {
                if (entity instanceof PlayerEntity) {
                    return this.isPlayerAffected((PlayerEntity)entity);
                }
                return true;
            }
        }
        return false;
    }

    public boolean isPlayerAffected(PlayerEntity player) {
        if (this.mode == EnvironmentalMode.MODE_WHITELIST) {
            return this.players.contains(player.func_200200_C_().getString());
        }
        if (this.mode == EnvironmentalMode.MODE_BLACKLIST) {
            return !this.players.contains(player.func_200200_C_().getString());
        }
        return this.mode == EnvironmentalMode.MODE_ALL;
    }

    private List<String> getPlayersAsList() {
        return new ArrayList<String>(this.players);
    }

    private void addPlayer(String player) {
        if (!this.players.contains(player)) {
            this.players.add(player);
            this.markDirtyClient();
        }
    }

    private void delPlayer(String player) {
        if (this.players.contains(player)) {
            this.players.remove(player);
            this.markDirtyClient();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public int getTotalRfPerTick() {
        if (this.environmentModules == null) {
            this.getEnvironmentModules();
        }
        float factor = this.infusableHandler.map(IInfusable::getInfusedFactor).orElse(Float.valueOf(0.0f)).floatValue();
        int rfNeeded = (int)((float)this.totalRfPerTick * this.getPowerMultiplier() * (4.0f - factor) / 4.0f);
        if (this.environmentModules.isEmpty()) {
            return rfNeeded;
        }
        if (rfNeeded < (Integer)EnvironmentalConfiguration.MIN_USAGE.get()) {
            rfNeeded = (Integer)EnvironmentalConfiguration.MIN_USAGE.get();
        }
        return rfNeeded;
    }

    public int getVolume() {
        if (this.volume == -1) {
            this.volume = (int)((double)(this.radius * this.radius) * Math.PI * (double)(this.maxy - this.miny + 1));
        }
        return this.volume;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.volume = -1;
        this.environmentModules = null;
        this.markDirtyClient();
    }

    public int getMiny() {
        return this.miny;
    }

    public void setMiny(int miny) {
        if (miny == -1) {
            return;
        }
        this.miny = miny;
        this.volume = -1;
        this.environmentModules = null;
        this.markDirtyClient();
    }

    public int getMaxy() {
        return this.maxy;
    }

    public void setMaxy(int maxy) {
        if (maxy == -1) {
            return;
        }
        this.maxy = maxy;
        this.volume = -1;
        this.environmentModules = null;
        this.markDirtyClient();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        if (this.powerTimeout > 0) {
            --this.powerTimeout;
            return;
        }
        long rf = this.energyStorage.getEnergyStored();
        if (!this.isMachineEnabled()) {
            rf = 0L;
        }
        this.getEnvironmentModules();
        int rfNeeded = this.getTotalRfPerTick();
        if ((long)rfNeeded > rf || this.environmentModules.isEmpty()) {
            this.deactivate();
            this.powerTimeout = 20;
        } else {
            this.energyStorage.consumeEnergy((long)rfNeeded);
            for (EnvironmentModule module : this.environmentModules) {
                module.activate(true);
                module.tick(this.field_145850_b, this.func_174877_v(), this.radius, this.miny, this.maxy, this);
            }
            if (!this.active) {
                this.active = true;
                this.markDirtyClient();
            }
        }
    }

    public void deactivate() {
        for (EnvironmentModule module : this.environmentModules) {
            module.activate(false);
        }
        if (this.active) {
            this.active = false;
            this.markDirtyClient();
        }
    }

    private Object[] setRedstoneMode(String mode) {
        RedstoneMode redstoneMode = RedstoneMode.getMode((String)mode);
        if (redstoneMode == null) {
            throw new IllegalArgumentException("Not a valid mode");
        }
        this.setRSMode(redstoneMode);
        return null;
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel != powered) {
            this.powerTimeout = 0;
        }
        super.setPowerInput(powered);
    }

    public List<EnvironmentModule> getEnvironmentModules() {
        if (this.environmentModules == null) {
            int volume = this.getVolume();
            this.totalRfPerTick = 0;
            this.environmentModules = new ArrayList<EnvironmentModule>();
            for (int i = 0; i < this.items.getSlots(); ++i) {
                ItemStack itemStack = this.items.getStackInSlot(i);
                if (itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof EnvModuleProvider)) continue;
                EnvModuleProvider moduleProvider = (EnvModuleProvider)itemStack.func_77973_b();
                Supplier<? extends EnvironmentModule> supplier = moduleProvider.getServerEnvironmentModule();
                EnvironmentModule environmentModule = supplier.get();
                this.environmentModules.add(environmentModule);
                this.totalRfPerTick += (int)(environmentModule.getRfPerTick() * (float)volume);
            }
        }
        return this.environmentModules;
    }

    public void read(CompoundNBT tagCompound) {
        super.read(tagCompound);
        this.totalRfPerTick = tagCompound.func_74762_e("rfPerTick");
        this.active = tagCompound.func_74767_n("active");
    }

    protected void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.radius = info.func_74762_e("radius");
        this.miny = info.func_74762_e("miny");
        this.maxy = info.func_74762_e("maxy");
        this.volume = -1;
        if (info.func_74764_b("whitelist")) {
            boolean wl = info.func_74767_n("whitelist");
            this.mode = wl ? EnvironmentalMode.MODE_WHITELIST : EnvironmentalMode.MODE_BLACKLIST;
        } else {
            int m = info.func_74762_e("mode");
            this.mode = EnvironmentalMode.values()[m];
        }
        this.players.clear();
        ListNBT playerList = info.func_150295_c("players", 8);
        if (!playerList.isEmpty()) {
            for (int i = 0; i < playerList.size(); ++i) {
                String player = playerList.func_150307_f(i);
                this.players.add(player);
            }
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("rfPerTick", this.totalRfPerTick);
        tagCompound.func_74757_a("active", this.active);
        return tagCompound;
    }

    protected void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("radius", this.radius);
        info.func_74768_a("miny", this.miny);
        info.func_74768_a("maxy", this.maxy);
        info.func_74768_a("mode", this.mode.ordinal());
        ListNBT playerTagList = new ListNBT();
        for (String player : this.players) {
            playerTagList.add((Object)StringNBT.func_229705_a_((String)player));
        }
        info.func_218657_a("players", (INBT)playerTagList);
    }

    public boolean execute(PlayerEntity playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_ADDPLAYER.equals(command)) {
            this.addPlayer((String)params.get(PARAM_NAME));
            return true;
        }
        if (CMD_DELPLAYER.equals(command)) {
            this.delPlayer((String)params.get(PARAM_NAME));
            return true;
        }
        if (CMD_RSMODE.equals(command)) {
            this.setRSMode(RedstoneMode.values()[(Integer)params.get(ImageChoiceLabel.PARAM_CHOICE_IDX)]);
            return true;
        }
        if (CMD_SETRADIUS.equals(command)) {
            this.setRadius((Integer)params.get(ScrollableLabel.PARAM_VALUE));
            return true;
        }
        if (CMD_SETMODE.equals(command)) {
            this.setMode(EnvironmentalMode.values()[(Integer)params.get(PARAM_MODE)]);
            return true;
        }
        if (CMD_SETBOUNDS.equals(command)) {
            this.setMiny((Integer)params.get(PARAM_MIN));
            this.setMaxy((Integer)params.get(PARAM_MAX));
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, TypedMap args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if ("getPlayers".equals(command)) {
            return type.convert(this.getPlayersAsList());
        }
        return Collections.emptyList();
    }

    public <T> boolean receiveListFromServer(String command, List<T> list, Type<T> type) {
        boolean rc = super.receiveListFromServer(command, list, type);
        if (rc) {
            return true;
        }
        if ("getPlayers".equals(command)) {
            this.players = new HashSet<String>(Type.STRING.convert(list));
            return true;
        }
        return false;
    }

    public void onReplaced(World world, BlockPos pos, BlockState state, BlockState newstate) {
        this.deactivate();
    }

    private NoDirectionItemHander createItemHandler() {
        return new NoDirectionItemHander(this, (ContainerFactory)CONTAINER_FACTORY.get()){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.func_77973_b() instanceof EnvModuleProvider;
            }

            public boolean isItemInsertable(int slot, @Nonnull ItemStack stack) {
                return this.isItemValid(slot, stack);
            }
        };
    }

    @Nonnull
    private IPowerInformation createPowerInfo() {
        return new IPowerInformation(){

            public long getEnergyDiffPerTick() {
                return EnvironmentalControllerTileEntity.this.isActive() ? (long)(-EnvironmentalControllerTileEntity.this.getTotalRfPerTick()) : 0L;
            }

            @Nullable
            public String getEnergyUnitName() {
                return "RF";
            }

            public boolean isMachineActive() {
                return EnvironmentalControllerTileEntity.this.isActive();
            }

            public boolean isMachineRunning() {
                return EnvironmentalControllerTileEntity.this.isActive();
            }

            @Nullable
            public String getMachineStatus() {
                return EnvironmentalControllerTileEntity.this.isActive() ? "active" : "idle";
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyHandler.cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        if (cap == CapabilityInfusable.INFUSABLE_CAPABILITY) {
            return this.infusableHandler.cast();
        }
        if (cap == CapabilityModuleSupport.MODULE_CAPABILITY) {
            return this.moduleSupportHandler.cast();
        }
        if (cap == CapabilityPowerInformation.POWER_INFORMATION_CAPABILITY) {
            return this.powerInfoHandler.cast();
        }
        return super.getCapability(cap, facing);
    }

    public static enum EnvironmentalMode {
        MODE_BLACKLIST,
        MODE_WHITELIST,
        MODE_HOSTILE,
        MODE_PASSIVE,
        MODE_MOBS,
        MODE_ALL;

    }
}

