/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.crafter.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftoolsutility.modules.crafter.CrafterModule;
import mcjty.rftoolsutility.modules.crafter.CraftingRecipe;
import mcjty.rftoolsutility.modules.crafter.blocks.CrafterBaseTE;
import mcjty.rftoolsutility.modules.crafter.blocks.CrafterContainer;
import mcjty.rftoolsutility.modules.crafter.network.PacketCrafter;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class GuiCrafter
extends GenericGuiContainer<CrafterBaseTE, CrafterContainer> {
    private EnergyBar energyBar;
    private WidgetList recipeList;
    private ChoiceLabel keepItem;
    private ChoiceLabel internalRecipe;
    private Button applyButton;
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftoolsbase", "textures/gui/guielements.png");
    private static int lastSelected = -1;

    public GuiCrafter(CrafterBaseTE te, CrafterContainer container, PlayerInventory inventory) {
        super((GenericTileEntity)te, (Container)container, inventory, ((BaseBlock)CrafterModule.CRAFTER1.get()).getManualEntry());
    }

    public static void register() {
        GuiCrafter.register((ContainerType)((ContainerType)CrafterModule.CONTAINER_CRAFTER.get()), GuiCrafter::new);
    }

    public void func_231160_c_() {
        this.window = new Window((Screen)this, this.tileEntity, RFToolsUtilityMessages.INSTANCE, new ResourceLocation("rftoolsutility", "gui/crafter.gui"));
        super.func_231160_c_();
        this.initializeFields();
        Integer sizeInventory = ((CrafterBaseTE)this.tileEntity).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(IItemHandler::getSlots).orElse(0);
        if (lastSelected != -1 && lastSelected < sizeInventory) {
            this.recipeList.selected(lastSelected);
        }
        this.window.event("apply", (source, params) -> this.applyRecipe());
        this.window.event("select", (source, params) -> this.selectRecipe());
    }

    private void initializeFields() {
        this.recipeList = (WidgetList)this.window.findChild("recipes");
        this.energyBar = (EnergyBar)this.window.findChild("energybar");
        this.applyButton = (Button)this.window.findChild("apply");
        this.keepItem = (ChoiceLabel)this.window.findChild("keep");
        this.internalRecipe = (ChoiceLabel)this.window.findChild("internal");
        ((ImageChoiceLabel)this.window.findChild("redstone")).setCurrentChoice(((CrafterBaseTE)this.tileEntity).getRSMode().ordinal());
        ((ImageChoiceLabel)this.window.findChild("speed")).setCurrentChoice(((CrafterBaseTE)this.tileEntity).getSpeedMode());
        this.populateList();
    }

    private void populateList() {
        this.recipeList.removeChildren();
        for (int i = 0; i < ((CrafterBaseTE)this.tileEntity).getSupportedRecipes(); ++i) {
            CraftingRecipe recipe = ((CrafterBaseTE)this.tileEntity).getRecipe(i);
            this.addRecipeLine(recipe.getResult());
        }
    }

    private void addRecipeLine(ItemStack craftingResult) {
        String readableName = BlockTools.getReadableName((ItemStack)craftingResult);
        int color = StyleConfig.colorTextInListNormal;
        if (craftingResult.func_190926_b()) {
            readableName = "<no recipe>";
            color = -11513776;
        }
        Panel panel = (Panel)Widgets.horizontal().children(new Widget[]{new BlockRender().renderItem((Object)craftingResult).tooltips(new String[]{"Double click to edit this recipe"}), ((Label)((Label)((Label)Widgets.label((String)readableName).color(color)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).dynamic(true)).tooltips(new String[]{"Double click to edit this recipe"})});
        this.recipeList.children(new Widget[]{panel});
    }

    private void selectRecipe() {
        int selected;
        lastSelected = selected = this.recipeList.getSelected();
        if (selected == -1) {
            for (int i = 0; i < 10; ++i) {
                ((CrafterContainer)this.field_147002_h).func_75139_a(i).func_75215_d(ItemStack.field_190927_a);
            }
            this.keepItem.choice("All");
            this.internalRecipe.choice("Ext");
            return;
        }
        CraftingRecipe craftingRecipe = ((CrafterBaseTE)this.tileEntity).getRecipe(selected);
        CraftingInventory inv = craftingRecipe.getInventory();
        for (int i = 0; i < 9; ++i) {
            ((CrafterContainer)this.field_147002_h).func_75139_a(i).func_75215_d(inv.func_70301_a(i));
        }
        ((CrafterContainer)this.field_147002_h).func_75139_a(9).func_75215_d(craftingRecipe.getResult());
        this.keepItem.choice(craftingRecipe.isKeepOne() ? "Keep" : "All");
        this.internalRecipe.choice(craftingRecipe.getCraftMode().getDescription());
    }

    private void testRecipe() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            return;
        }
        CraftingInventory inv = new CraftingInventory(new Container(null, -1){

            public boolean func_75145_c(PlayerEntity var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            inv.func_70299_a(i, ((CrafterContainer)this.field_147002_h).func_75139_a(i).func_75211_c());
        }
        IRecipe recipe = CraftingRecipe.findRecipe((World)this.field_230706_i_.field_71441_e, inv);
        ItemStack newResult = recipe == null ? ItemStack.field_190927_a : recipe.func_77572_b((IInventory)inv);
        ((CrafterContainer)this.field_147002_h).func_75139_a(9).func_75215_d(newResult);
    }

    private void applyRecipe() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            return;
        }
        if (selected >= ((CrafterBaseTE)this.tileEntity).getSupportedRecipes()) {
            this.recipeList.selected(-1);
            return;
        }
        CraftingRecipe craftingRecipe = ((CrafterBaseTE)this.tileEntity).getRecipe(selected);
        CraftingInventory inv = craftingRecipe.getInventory();
        for (int i = 0; i < 9; ++i) {
            ItemStack newStack;
            ItemStack oldStack = inv.func_70301_a(i);
            if (this.itemStacksEqual(oldStack, newStack = ((CrafterContainer)this.field_147002_h).func_75139_a(i).func_75211_c())) continue;
            inv.func_70299_a(i, newStack);
        }
        IRecipe recipe = CraftingRecipe.findRecipe((World)this.field_230706_i_.field_71441_e, inv);
        ItemStack newResult = recipe == null ? ItemStack.field_190927_a : recipe.func_77572_b((IInventory)inv);
        ItemStack oldResult = ((CrafterContainer)this.field_147002_h).func_75139_a(9).func_75211_c();
        if (!this.itemStacksEqual(oldResult, newResult)) {
            ((CrafterContainer)this.field_147002_h).func_75139_a(9).func_75215_d(newResult);
        }
        craftingRecipe.setResult(newResult);
        this.updateRecipe();
        this.populateList();
    }

    private void updateRecipe() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            return;
        }
        CraftingRecipe craftingRecipe = ((CrafterBaseTE)this.tileEntity).getRecipe(selected);
        boolean keepOne = "Keep".equals(this.keepItem.getCurrentChoice());
        CraftingRecipe.CraftMode mode = "Int".equals(this.internalRecipe.getCurrentChoice()) ? CraftingRecipe.CraftMode.INT : ("Ext".equals(this.internalRecipe.getCurrentChoice()) ? CraftingRecipe.CraftMode.EXT : CraftingRecipe.CraftMode.EXTC);
        craftingRecipe.setKeepOne(keepOne);
        craftingRecipe.setCraftMode(mode);
        this.sendChangeToServer(selected, craftingRecipe.getInventory(), craftingRecipe.getResult(), keepOne, mode);
    }

    private boolean itemStacksEqual(ItemStack matches, ItemStack oldStack) {
        if (matches.func_190926_b()) {
            return oldStack.func_190926_b();
        }
        return !oldStack.func_190926_b() && matches.func_77969_a(oldStack);
    }

    private void sendChangeToServer(int index, CraftingInventory inv, ItemStack result, boolean keepOne, CraftingRecipe.CraftMode mode) {
        RFToolsUtilityMessages.INSTANCE.sendToServer((Object)new PacketCrafter(((CrafterBaseTE)this.tileEntity).func_174877_v(), index, inv, result, keepOne, mode));
    }

    private void updateButtons() {
        if (this.recipeList != null) {
            boolean selected = this.recipeList.getSelected() != -1;
            this.keepItem.enabled(selected);
            this.internalRecipe.enabled(selected);
            this.applyButton.enabled(selected);
        }
        if (this.keepItem.getCurrentChoice() == null || this.keepItem.getCurrentChoice().trim().isEmpty()) {
            this.keepItem.choice("All");
        }
        if (this.internalRecipe.getCurrentChoice() == null || this.internalRecipe.getCurrentChoice().trim().isEmpty()) {
            this.internalRecipe.choice("Ext");
        }
    }

    protected void func_230450_a_(MatrixStack matrixStack, float v, int x, int y) {
        if (this.window == null) {
            return;
        }
        this.updateButtons();
        this.drawWindow(matrixStack);
        this.updateEnergyBar(this.energyBar);
        this.drawGhostSlots(matrixStack);
        this.testRecipe();
    }

    private void drawGhostSlots(MatrixStack matrixStack) {
        net.minecraft.client.renderer.RenderHelper.func_227784_d_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)this.field_147003_i, (double)this.field_147009_r, 0.0);
        RenderSystem.color4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.enableRescaleNormal();
        ItemStackList ghostSlots = ((CrafterBaseTE)this.tileEntity).getGhostSlots();
        this.field_230707_j_.field_77023_b = 100.0f;
        GlStateManager.func_227734_k_();
        GlStateManager.func_227737_l_();
        RenderSystem.enableLighting();
        for (int i = 0; i < ghostSlots.size(); ++i) {
            int slotIdx;
            Slot slot;
            ItemStack stack = (ItemStack)ghostSlots.get(i);
            if (stack.func_190926_b() || (slot = ((CrafterContainer)this.field_147002_h).func_75139_a(slotIdx = i < 26 ? i + 10 : i + 36 - 26)).func_75216_d()) continue;
            this.field_230707_j_.func_180450_b(stack, this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f);
            RenderSystem.disableLighting();
            GlStateManager.func_227740_m_();
            GlStateManager.func_227731_j_();
            this.field_230706_i_.func_110434_K().func_110577_a(iconGuiElements);
            RenderHelper.drawTexturedModalRect((Matrix4f)matrixStack.func_227866_c_().func_227870_a_(), (int)slot.field_75223_e, (int)slot.field_75221_f, (int)224, (int)48, (int)16, (int)16);
            GlStateManager.func_227734_k_();
            GlStateManager.func_227737_l_();
            RenderSystem.enableLighting();
        }
        this.field_230707_j_.field_77023_b = 0.0f;
        matrixStack.func_227865_b_();
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
    }
}

