/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.compat;

import com.mojang.blaze3d.matrix.MatrixStack;
import io.netty.buffer.ByteBuf;
import mcjty.rftoolsutility.compat.TheOneProbeSupport;
import mcjty.theoneprobe.api.IElement;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.network.PacketBuffer;

public class ElementSequencer
implements IElement {
    private final long bits;
    private final int current;
    private final boolean large;

    public ElementSequencer(long bits, int current, boolean large) {
        this.bits = bits;
        this.current = current;
        this.large = large;
    }

    public ElementSequencer(ByteBuf buf) {
        this.bits = buf.readLong();
        this.current = buf.readInt();
        this.large = buf.readBoolean();
    }

    private int getSize() {
        return this.large ? 5 : 3;
    }

    public void render(MatrixStack matrixStack, int x, int y) {
        int size = this.getSize();
        for (int row = 0; row < 8; ++row) {
            for (int col = 0; col < 8; ++col) {
                int bit = row * 8 + col;
                if (this.large && bit == this.current) {
                    Screen.func_238467_a_((MatrixStack)matrixStack, (int)(6 + x + col * size), (int)(y + row * size), (int)(6 + x + col * size + size - 1), (int)(y + row * size + size - 1), (int)-65536);
                    Screen.func_238467_a_((MatrixStack)matrixStack, (int)(6 + x + col * size + 1), (int)(y + row * size + 1), (int)(6 + x + col * size + size - 2), (int)(y + row * size + size - 2), (int)((this.bits >> bit & 1L) == 1L ? -1 : -16777216));
                    continue;
                }
                Screen.func_238467_a_((MatrixStack)matrixStack, (int)(6 + x + col * size), (int)(y + row * size), (int)(6 + x + col * size + size - 1), (int)(y + row * size + size - 1), (int)((this.bits >> bit & 1L) == 1L ? -1 : -16777216));
            }
        }
    }

    public int getWidth() {
        return 12 + this.getSize() * 8;
    }

    public int getHeight() {
        return this.getSize() * 8;
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeLong(this.bits);
        buf.writeInt(this.current);
        buf.writeBoolean(this.large);
    }

    public int getID() {
        return TheOneProbeSupport.ELEMENT_SEQUENCER;
    }
}

