/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.IncompatibleEnvironmentException;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.TracingPrintStream;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.Environment;
import net.minecraftforge.forgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FMLServiceProvider
implements ITransformationService {
    private static final Logger LOGGER = LogManager.getLogger();
    private ArgumentAcceptingOptionSpec<String> modsOption;
    private ArgumentAcceptingOptionSpec<String> modListsOption;
    private ArgumentAcceptingOptionSpec<String> mavenRootsOption;
    private ArgumentAcceptingOptionSpec<String> forgeOption;
    private ArgumentAcceptingOptionSpec<String> mcOption;
    private ArgumentAcceptingOptionSpec<String> forgeGroupOption;
    private ArgumentAcceptingOptionSpec<String> mcpOption;
    private ArgumentAcceptingOptionSpec<String> mappingsOption;
    private List<String> modsArgumentList;
    private List<String> modListsArgumentList;
    private List<String> mavenRootsArgumentList;
    private String targetForgeVersion;
    private String targetMcVersion;
    private String targetMcpVersion;
    private String targetMcpMappings;
    private String targetForgeGroup;
    private Map<String, Object> arguments;

    public String name() {
        return "fml";
    }

    public void initialize(IEnvironment environment) {
        LOGGER.debug(LogMarkers.CORE, "Setting up basic FML game directories");
        FMLPaths.setup(environment);
        LOGGER.debug(LogMarkers.CORE, "Loading configuration");
        FMLConfig.load();
        LOGGER.debug(LogMarkers.CORE, "Preparing ModFile");
        environment.computePropertyIfAbsent((TypesafeMap.Key)Environment.Keys.MODFILEFACTORY.get(), k -> ModFile.buildFactory());
        this.arguments = new HashMap<String, Object>();
        this.arguments.put("modLists", this.modListsArgumentList);
        this.arguments.put("mods", this.modsArgumentList);
        this.arguments.put("mavenRoots", this.mavenRootsArgumentList);
        this.arguments.put("forgeVersion", this.targetForgeVersion);
        this.arguments.put("forgeGroup", this.targetForgeGroup);
        this.arguments.put("mcVersion", this.targetMcVersion);
        this.arguments.put("mcpVersion", this.targetMcpVersion);
        this.arguments.put("mcpMappings", this.targetMcpMappings);
        LOGGER.debug(LogMarkers.CORE, "Preparing launch handler");
        FMLLoader.setupLaunchHandler(environment, this.arguments);
        FMLEnvironment.setupInteropEnvironment(environment);
        Environment.build((IEnvironment)environment);
    }

    public void beginScanning(IEnvironment environment) {
        throw new IllegalStateException("WHY ARE YOU HERE??????");
    }

    public List<Map.Entry<String, Path>> runScan(IEnvironment environment) {
        LOGGER.debug(LogMarkers.CORE, "Initiating mod scan");
        Map<IModFile.Type, List<ModFile>> foundFiles = FMLLoader.beginModScan(this.arguments);
        return foundFiles.values().stream().flatMap(Collection::stream).map(modFile -> new AbstractMap.SimpleImmutableEntry<String, Path>(modFile.getFileName(), modFile.getFilePath())).collect(Collectors.toList());
    }

    public void onLoad(IEnvironment environment, Set<String> otherServices) throws IncompatibleEnvironmentException {
        LOGGER.debug("Injecting tracing printstreams for STDOUT/STDERR.");
        System.setOut(new TracingPrintStream(LogManager.getLogger((String)"STDOUT"), System.out));
        System.setErr(new TracingPrintStream(LogManager.getLogger((String)"STDERR"), System.err));
        FMLLoader.onInitialLoad(environment, otherServices);
    }

    public void arguments(BiFunction<String, String, OptionSpecBuilder> argumentBuilder) {
        this.forgeOption = argumentBuilder.apply("forgeVersion", "Forge Version number").withRequiredArg().ofType(String.class).required();
        this.forgeGroupOption = argumentBuilder.apply("forgeGroup", "Forge Group (for testing)").withRequiredArg().ofType(String.class).defaultsTo((Object)"net.minecraftforge", (Object[])new String[0]);
        this.mcOption = argumentBuilder.apply("mcVersion", "Minecraft Version number").withRequiredArg().ofType(String.class).required();
        this.mcpOption = argumentBuilder.apply("mcpVersion", "MCP Version number").withRequiredArg().ofType(String.class).required();
        this.mappingsOption = argumentBuilder.apply("mcpMappings", "MCP Mappings Channel and Version").withRequiredArg().ofType(String.class);
        this.modsOption = argumentBuilder.apply("mods", "List of mods to add").withRequiredArg().ofType(String.class).withValuesSeparatedBy(",");
        this.modListsOption = argumentBuilder.apply("modLists", "JSON modlists").withRequiredArg().ofType(String.class).withValuesSeparatedBy(",");
        this.mavenRootsOption = argumentBuilder.apply("mavenRoots", "Maven root directories").withRequiredArg().ofType(String.class).withValuesSeparatedBy(",");
    }

    public void argumentValues(ITransformationService.OptionResult option) {
        this.modsArgumentList = option.values(this.modsOption);
        this.modListsArgumentList = option.values(this.modListsOption);
        this.mavenRootsArgumentList = option.values(this.mavenRootsOption);
        this.targetForgeVersion = (String)option.value(this.forgeOption);
        this.targetForgeGroup = (String)option.value(this.forgeGroupOption);
        this.targetMcVersion = (String)option.value(this.mcOption);
        this.targetMcpVersion = (String)option.value(this.mcpOption);
        this.targetMcpMappings = (String)option.value(this.mappingsOption);
    }

    @Nonnull
    public List<ITransformer> transformers() {
        LOGGER.debug(LogMarkers.CORE, "Loading coremod transformers");
        return new ArrayList<ITransformer>(FMLLoader.getCoreModProvider().getCoreModTransformers());
    }
}

