/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.network.IClientCommandHandler;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.Logging;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorContainer;
import mcjty.rftoolscontrol.modules.processor.logic.Parameter;
import mcjty.rftoolscontrol.modules.processor.logic.ParameterTools;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketVariablesReady {
    public BlockPos pos;
    public List<Parameter> list;
    public String command;

    public PacketVariablesReady(PacketBuffer buf) {
        if (buf.readBoolean()) {
            this.pos = buf.func_179259_c();
        }
        this.command = buf.func_150789_c(Short.MAX_VALUE);
        int size = buf.readInt();
        if (size != -1) {
            this.list = new ArrayList<Parameter>(size);
            for (int i = 0; i < size; ++i) {
                this.list.add(ParameterTools.readFromBuf(buf));
            }
        } else {
            this.list = null;
        }
    }

    public PacketVariablesReady(@Nullable BlockPos pos, String command, List<Parameter> list) {
        this.pos = pos;
        this.command = command;
        this.list = new ArrayList<Parameter>();
        this.list.addAll(list);
    }

    public void toBytes(PacketBuffer buf) {
        if (this.pos != null) {
            buf.writeBoolean(true);
            buf.func_179255_a(this.pos);
        } else {
            buf.writeBoolean(false);
        }
        buf.func_180714_a(this.command);
        if (this.list == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.list.size());
            for (Parameter item : this.list) {
                if (item == null) {
                    buf.writeByte(-1);
                    continue;
                }
                ParameterTools.writeToBuf(buf, item);
            }
        }
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te;
            if (this.pos == null) {
                ProcessorContainer container = PacketVariablesReady.getOpenContainer();
                if (container == null) {
                    Logging.log((String)"Container is missing!");
                    return;
                }
                te = container.getTe();
            } else {
                te = McJtyLib.proxy.getClientWorld().func_175625_s(this.pos);
                if (!(te instanceof IClientCommandHandler)) {
                    Logging.log((String)"TileEntity is not a ClientCommandHandler!");
                    return;
                }
            }
            IClientCommandHandler clientCommandHandler = (IClientCommandHandler)te;
            if (!clientCommandHandler.receiveListFromServer(this.command, this.list, Type.create(Parameter.class))) {
                Logging.log((String)("Command " + this.command + " was not handled!"));
            }
        });
        ctx.setPacketHandled(true);
    }

    private static ProcessorContainer getOpenContainer() {
        Container container = McJtyLib.proxy.getClientPlayer().field_71070_bA;
        if (container instanceof ProcessorContainer) {
            return (ProcessorContainer)container;
        }
        return null;
    }
}

