/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcjty.rftoolsbase.api.control.code.Function;
import mcjty.rftoolsbase.api.control.parameters.BlockSide;
import mcjty.rftoolsbase.api.control.parameters.Inventory;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolsbase.api.control.parameters.Tuple;
import mcjty.rftoolscontrol.modules.processor.logic.Parameter;
import mcjty.rftoolscontrol.modules.processor.logic.ParameterTools;
import mcjty.rftoolscontrol.modules.processor.logic.TypeConverters;
import mcjty.rftoolscontrol.modules.processor.logic.registry.Functions;
import mcjty.rftoolscontrol.modules.processor.logic.running.ExceptionType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class ParameterTypeTools {
    public static String stringRepresentation(ParameterType type, ParameterValue value) {
        if (value.isVariable()) {
            return "V:" + value.getVariableIndex();
        }
        if (value.isFunction()) {
            return "F:" + value.getFunction().getName();
        }
        if (value.getValue() == null) {
            return "";
        }
        return ParameterTypeTools.stringRepresentationInternal(type, value.getValue());
    }

    private static String stringRepresentationInternal(ParameterType type, Object value) {
        switch (type) {
            case PAR_STRING: {
                return (String)value;
            }
            case PAR_INTEGER: {
                return Integer.toString((Integer)value);
            }
            case PAR_LONG: {
                return Long.toString((Long)value);
            }
            case PAR_FLOAT: {
                return Float.toString(((Float)value).floatValue());
            }
            case PAR_NUMBER: {
                String s = TypeConverters.castNumberToString(value);
                return s + " (" + TypeConverters.getNumberType(value) + ")";
            }
            case PAR_SIDE: {
                return ((BlockSide)value).getStringRepresentation();
            }
            case PAR_BOOLEAN: {
                return (Boolean)value != false ? "true" : "false";
            }
            case PAR_INVENTORY: {
                return ((Inventory)value).getStringRepresentation();
            }
            case PAR_ITEM: {
                ItemStack itemStack = (ItemStack)value;
                return StringUtils.left((String)itemStack.func_200301_q().getString(), (int)10);
            }
            case PAR_FLUID: {
                FluidStack fluidStack = (FluidStack)value;
                return StringUtils.left((String)fluidStack.getDisplayName().getString(), (int)10);
            }
            case PAR_EXCEPTION: {
                ExceptionType exception = (ExceptionType)((Object)value);
                return exception.getCode();
            }
            case PAR_TUPLE: {
                return value.toString();
            }
            case PAR_VECTOR: {
                return "[" + ((List)value).size() + "]";
            }
        }
        return "?";
    }

    public static JsonElement writeToJson(ParameterType type, ParameterValue value) {
        JsonObject jsonObject = new JsonObject();
        if (value.isVariable()) {
            jsonObject.add("var", (JsonElement)new JsonPrimitive((Number)value.getVariableIndex()));
        } else if (value.isFunction()) {
            jsonObject.add("fun", (JsonElement)new JsonPrimitive(value.getFunction().getId()));
        } else if (value.getValue() == null) {
            jsonObject.add("null", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        } else {
            ParameterTypeTools.writeToJsonInternal(jsonObject, type, value.getValue());
        }
        return jsonObject;
    }

    public static ParameterValue readFromJson(ParameterType type, JsonObject object) {
        if (object.has("var")) {
            return ParameterValue.variable((int)object.get("var").getAsInt());
        }
        if (object.has("fun")) {
            return ParameterValue.function((Function)Functions.FUNCTIONS.get(object.get("fun").getAsString()));
        }
        if (object.has("null")) {
            return ParameterValue.constant(null);
        }
        return ParameterTypeTools.readFromJsonInternal(object, type);
    }

    public static void writeToNBT(CompoundNBT tag, ParameterType type, ParameterValue value) {
        if (value.isVariable()) {
            tag.func_74768_a("varIdx", value.getVariableIndex());
        } else if (value.isFunction()) {
            tag.func_74778_a("funId", value.getFunction().getId());
        } else if (value.getValue() == null) {
            tag.func_74757_a("null", true);
        } else {
            ParameterTypeTools.writeToNBTInternal(tag, type, value.getValue());
        }
    }

    public static ParameterValue readFromNBT(CompoundNBT tag, ParameterType type) {
        if (tag.func_74764_b("varIdx")) {
            return ParameterValue.variable((int)tag.func_74762_e("varIdx"));
        }
        if (tag.func_74764_b("funId")) {
            return ParameterValue.function((Function)Functions.FUNCTIONS.get(tag.func_74779_i("funId")));
        }
        if (tag.func_74764_b("null")) {
            return ParameterValue.constant(null);
        }
        return ParameterTypeTools.readFromNBTInternal(tag, type);
    }

    private static ParameterValue readFromNBTInternal(CompoundNBT tag, ParameterType type) {
        switch (type) {
            case PAR_STRING: {
                return ParameterValue.constant((Object)tag.func_74779_i("v"));
            }
            case PAR_INTEGER: {
                return ParameterValue.constant((Object)tag.func_74762_e("v"));
            }
            case PAR_LONG: {
                return ParameterValue.constant((Object)tag.func_74763_f("v"));
            }
            case PAR_FLOAT: {
                return ParameterValue.constant((Object)Float.valueOf(tag.func_74760_g("v")));
            }
            case PAR_NUMBER: {
                if (tag.func_74764_b("v")) {
                    return ParameterValue.constant((Object)tag.func_74762_e("v"));
                }
                if (tag.func_74764_b("l")) {
                    return ParameterValue.constant((Object)tag.func_74763_f("l"));
                }
                if (tag.func_74764_b("f")) {
                    return ParameterValue.constant((Object)Float.valueOf(tag.func_74760_g("f")));
                }
                if (!tag.func_74764_b("d")) break;
                return ParameterValue.constant((Object)tag.func_74769_h("d"));
            }
            case PAR_SIDE: {
                int v = tag.func_74762_e("v");
                Direction facing = v == -1 ? null : Direction.values()[v];
                String node = tag.func_74779_i("node");
                return ParameterValue.constant((Object)new BlockSide(node, facing));
            }
            case PAR_BOOLEAN: {
                return ParameterValue.constant((Object)tag.func_74767_n("v"));
            }
            case PAR_INVENTORY: {
                Direction side = Direction.values()[tag.func_74762_e("side")];
                String name = null;
                Direction intSide = null;
                if (tag.func_74764_b("nodeName")) {
                    name = tag.func_74779_i("nodeName");
                }
                if (tag.func_74764_b("intSide")) {
                    intSide = Direction.values()[tag.func_74762_e("intSide")];
                }
                return ParameterValue.constant((Object)new Inventory(name, side, intSide));
            }
            case PAR_ITEM: {
                if (tag.func_74764_b("item")) {
                    CompoundNBT tc = tag.func_74775_l("item");
                    ItemStack stack = ItemStack.func_199557_a((CompoundNBT)tc);
                    if (stack.func_190916_E() == 0) {
                        stack.func_190920_e(1);
                    }
                    return ParameterValue.constant((Object)stack);
                }
                return ParameterValue.constant((Object)ItemStack.field_190927_a);
            }
            case PAR_FLUID: {
                if (tag.func_74764_b("fluid")) {
                    CompoundNBT tc = tag.func_74775_l("fluid");
                    FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundNBT)tc);
                    return ParameterValue.constant((Object)stack);
                }
                return ParameterValue.constant(null);
            }
            case PAR_EXCEPTION: {
                String code = tag.func_74779_i("code");
                return ParameterValue.constant((Object)((Object)ExceptionType.getExceptionForCode(code)));
            }
            case PAR_TUPLE: {
                return ParameterValue.constant((Object)new Tuple(tag.func_74762_e("x"), tag.func_74762_e("y")));
            }
            case PAR_VECTOR: {
                ListNBT array = tag.func_150295_c("vector", 10);
                ArrayList<Parameter> vector = new ArrayList<Parameter>();
                for (int i = 0; i < array.size(); ++i) {
                    vector.add(ParameterTools.readFromNBT(array.func_150305_b(i)));
                }
                return ParameterValue.constant(Collections.unmodifiableList(vector));
            }
        }
        return ParameterValue.constant(null);
    }

    private static void writeToNBTInternal(CompoundNBT tag, ParameterType type, Object value) {
        switch (type) {
            case PAR_STRING: {
                tag.func_74778_a("v", (String)value);
                break;
            }
            case PAR_INTEGER: {
                tag.func_74768_a("v", ((Integer)value).intValue());
                break;
            }
            case PAR_LONG: {
                tag.func_74772_a("v", ((Long)value).longValue());
                break;
            }
            case PAR_FLOAT: {
                tag.func_74776_a("v", ((Float)value).floatValue());
                break;
            }
            case PAR_NUMBER: {
                if (value instanceof Integer) {
                    tag.func_74768_a("v", ((Integer)value).intValue());
                    break;
                }
                if (value instanceof Long) {
                    tag.func_74772_a("l", ((Long)value).longValue());
                    break;
                }
                if (value instanceof Float) {
                    tag.func_74776_a("f", ((Float)value).floatValue());
                    break;
                }
                if (!(value instanceof Double)) break;
                tag.func_74780_a("d", ((Double)value).doubleValue());
                break;
            }
            case PAR_SIDE: {
                BlockSide side = (BlockSide)value;
                tag.func_74768_a("v", side.getSide() == null ? -1 : side.getSide().ordinal());
                tag.func_74778_a("node", side.getNodeName() == null ? "" : side.getNodeName());
                break;
            }
            case PAR_BOOLEAN: {
                tag.func_74757_a("v", ((Boolean)value).booleanValue());
                break;
            }
            case PAR_INVENTORY: {
                Inventory inv = (Inventory)value;
                if (inv.getNodeName() != null) {
                    tag.func_74778_a("nodeName", inv.getNodeName());
                }
                tag.func_74768_a("side", inv.getSide().ordinal());
                if (inv.getIntSide() == null) break;
                tag.func_74768_a("intSide", inv.getIntSide().ordinal());
                break;
            }
            case PAR_ITEM: {
                ItemStack itemStack = (ItemStack)value;
                CompoundNBT tc = new CompoundNBT();
                itemStack.func_77955_b(tc);
                tag.func_218657_a("item", (INBT)tc);
                break;
            }
            case PAR_FLUID: {
                FluidStack fluidStack = (FluidStack)value;
                CompoundNBT fluidTc = new CompoundNBT();
                fluidStack.writeToNBT(fluidTc);
                tag.func_218657_a("fluid", (INBT)fluidTc);
                break;
            }
            case PAR_EXCEPTION: {
                ExceptionType exception = (ExceptionType)((Object)value);
                tag.func_74778_a("code", exception.getCode());
                break;
            }
            case PAR_TUPLE: {
                tag.func_74768_a("x", ((Tuple)value).getX());
                tag.func_74768_a("y", ((Tuple)value).getY());
                break;
            }
            case PAR_VECTOR: {
                List vector = (List)value;
                ListNBT list = new ListNBT();
                for (Parameter p : vector) {
                    list.add((Object)ParameterTools.writeToNBT(p));
                }
                tag.func_218657_a("vector", (INBT)list);
            }
        }
    }

    private static void writeToJsonInternal(JsonObject object, ParameterType type, Object value) {
        switch (type) {
            case PAR_STRING: {
                object.add("v", (JsonElement)new JsonPrimitive((String)value));
                break;
            }
            case PAR_INTEGER: {
                object.add("v", (JsonElement)new JsonPrimitive((Number)((Integer)value)));
                break;
            }
            case PAR_LONG: {
                object.add("v", (JsonElement)new JsonPrimitive((Number)((Long)value)));
                break;
            }
            case PAR_FLOAT: {
                object.add("v", (JsonElement)new JsonPrimitive((Number)((Float)value)));
                break;
            }
            case PAR_NUMBER: {
                if (value instanceof Integer) {
                    object.add("v", (JsonElement)new JsonPrimitive((Number)((Integer)value)));
                    break;
                }
                if (value instanceof Long) {
                    object.add("l", (JsonElement)new JsonPrimitive((Number)((Long)value)));
                    break;
                }
                if (value instanceof Float) {
                    object.add("f", (JsonElement)new JsonPrimitive((Number)((Float)value)));
                    break;
                }
                if (!(value instanceof Double)) break;
                object.add("d", (JsonElement)new JsonPrimitive((Number)((Double)value)));
                break;
            }
            case PAR_SIDE: {
                BlockSide side = (BlockSide)value;
                if (side.getSide() != null) {
                    object.add("side", (JsonElement)new JsonPrimitive(side.getSide().func_176610_l()));
                }
                if (side.getNodeName() == null) break;
                object.add("node", (JsonElement)new JsonPrimitive(side.getNodeName()));
                break;
            }
            case PAR_BOOLEAN: {
                object.add("v", (JsonElement)new JsonPrimitive((Boolean)value));
                break;
            }
            case PAR_INVENTORY: {
                Inventory inv = (Inventory)value;
                object.add("side", (JsonElement)new JsonPrimitive(inv.getSide().func_176610_l()));
                if (inv.getIntSide() != null) {
                    object.add("intside", (JsonElement)new JsonPrimitive(inv.getIntSide().func_176610_l()));
                }
                if (inv.getNodeName() == null) break;
                object.add("node", (JsonElement)new JsonPrimitive(inv.getNodeName()));
                break;
            }
            case PAR_ITEM: {
                ItemStack item = (ItemStack)value;
                object.add("item", (JsonElement)new JsonPrimitive(item.func_77973_b().getRegistryName().toString()));
                if (item.func_190916_E() != 1) {
                    object.add("amount", (JsonElement)new JsonPrimitive((Number)item.func_190916_E()));
                }
                if (!item.func_77942_o()) break;
                String string = item.func_77978_p().toString();
                object.add("nbt", (JsonElement)new JsonPrimitive(string));
                break;
            }
            case PAR_FLUID: {
                FluidStack fluidStack = (FluidStack)value;
                object.add("fluid", (JsonElement)new JsonPrimitive(fluidStack.getFluid().getRegistryName().toString()));
                object.add("amount", (JsonElement)new JsonPrimitive((Number)fluidStack.getAmount()));
                if (!fluidStack.hasTag()) break;
                object.add("nbt", (JsonElement)new JsonPrimitive(fluidStack.getTag().toString()));
                break;
            }
            case PAR_EXCEPTION: {
                ExceptionType exception = (ExceptionType)((Object)value);
                object.add("code", (JsonElement)new JsonPrimitive(exception.getCode()));
                break;
            }
            case PAR_TUPLE: {
                object.add("x", (JsonElement)new JsonPrimitive((Number)((Tuple)value).getX()));
                object.add("y", (JsonElement)new JsonPrimitive((Number)((Tuple)value).getY()));
                break;
            }
            case PAR_VECTOR: {
                List vector = (List)value;
                JsonArray array = new JsonArray();
                for (Parameter p : vector) {
                    array.add(ParameterTools.getJsonElement(p));
                }
                object.add("vector", (JsonElement)array);
            }
        }
    }

    private static ParameterValue readFromJsonInternal(JsonObject object, ParameterType type) {
        switch (type) {
            case PAR_STRING: {
                return ParameterValue.constant((Object)object.get("v").getAsString());
            }
            case PAR_INTEGER: {
                return ParameterValue.constant((Object)object.get("v").getAsInt());
            }
            case PAR_LONG: {
                return ParameterValue.constant((Object)object.get("v").getAsLong());
            }
            case PAR_FLOAT: {
                return ParameterValue.constant((Object)Float.valueOf(object.get("v").getAsFloat()));
            }
            case PAR_NUMBER: {
                if (object.has("v")) {
                    return ParameterValue.constant((Object)object.get("v").getAsInt());
                }
                if (object.has("l")) {
                    return ParameterValue.constant((Object)object.get("l").getAsLong());
                }
                if (object.has("f")) {
                    return ParameterValue.constant((Object)Float.valueOf(object.get("f").getAsFloat()));
                }
                if (!object.has("d")) break;
                return ParameterValue.constant((Object)object.get("d").getAsDouble());
            }
            case PAR_SIDE: {
                Direction side = object.has("side") ? Direction.func_176739_a((String)object.get("side").getAsString()) : null;
                String node = object.has("node") ? object.get("node").getAsString() : null;
                return ParameterValue.constant((Object)new BlockSide(node, side));
            }
            case PAR_BOOLEAN: {
                return ParameterValue.constant((Object)object.get("v").getAsBoolean());
            }
            case PAR_INVENTORY: {
                Direction side = Direction.func_176739_a((String)object.get("side").getAsString());
                Direction intSide = object.has("intside") ? Direction.func_176739_a((String)object.get("intside").getAsString()) : null;
                String node = object.has("node") ? object.get("node").getAsString() : null;
                return ParameterValue.constant((Object)new Inventory(node, side, intSide));
            }
            case PAR_ITEM: {
                String itemReg = object.get("item").getAsString();
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemReg));
                int amount = object.has("amount") ? object.get("amount").getAsInt() : 1;
                ItemStack stack = new ItemStack((IItemProvider)item, amount);
                if (object.has("nbt")) {
                    String nbt2 = object.get("nbt").getAsString();
                    CompoundNBT tagCompound = null;
                    try {
                        tagCompound = JsonToNBT.func_180713_a((String)nbt2);
                    }
                    catch (CommandSyntaxException commandSyntaxException) {
                        // empty catch block
                    }
                    stack.func_77982_d(tagCompound);
                }
                return ParameterValue.constant((Object)stack);
            }
            case PAR_FLUID: {
                String fluidName = object.get("fluid").getAsString();
                int amount = object.get("amount").getAsInt();
                FluidStack fluidStack = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName)), amount);
                if (object.has("nbt")) {
                    String nbt = object.get("nbt").getAsString();
                    try {
                        fluidStack.setTag(JsonToNBT.func_180713_a((String)nbt));
                    }
                    catch (CommandSyntaxException nbt2) {
                        // empty catch block
                    }
                }
                return ParameterValue.constant((Object)fluidStack);
            }
            case PAR_EXCEPTION: {
                String code = object.get("code").getAsString();
                return ParameterValue.constant((Object)((Object)ExceptionType.getExceptionForCode(code)));
            }
            case PAR_TUPLE: {
                return ParameterValue.constant((Object)new Tuple(object.get("x").getAsInt(), object.get("y").getAsInt()));
            }
            case PAR_VECTOR: {
                JsonArray array = object.get("vector").getAsJsonArray();
                ArrayList<Parameter> vector = new ArrayList<Parameter>();
                for (JsonElement element : array) {
                    JsonObject job = element.getAsJsonObject();
                    ParameterType t = ParameterType.getByName((String)job.get("type").getAsString());
                    vector.add(Parameter.builder().type(t).value(ParameterTypeTools.readFromJson(t, job)).build());
                }
                return ParameterValue.constant(Collections.unmodifiableList(vector));
            }
        }
        return null;
    }
}

