/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.network.PacketSendServerCommand;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolscontrol.CommandHandler;
import mcjty.rftoolscontrol.modules.processor.ProcessorModule;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.network.PacketGetDebugLog;
import mcjty.rftoolscontrol.modules.processor.network.PacketGetLog;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOp;
import mcjty.rftoolscontrol.setup.RFToolsCtrlMessages;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class ProcessorRenderer
extends TileEntityRenderer<ProcessorTileEntity> {
    public ProcessorRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(ProcessorTileEntity te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        if (te.getShowHud() == 0) {
            return;
        }
        BlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
        Block block = state.func_177230_c();
        if (!(block instanceof BaseBlock)) {
            return;
        }
        BaseBlock baseBlock = (BaseBlock)block;
        matrixStack.func_227860_a_();
        Direction facing = BaseBlock.getFrontDirection((RotationType)baseBlock.getRotationType(), (BlockState)state);
        matrixStack.func_227861_a_(0.5, 1.5, 0.5);
        if (facing == Direction.UP) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
        } else if (facing == Direction.DOWN) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        } else {
            float rotY = 0.0f;
            if (facing == Direction.NORTH) {
                rotY = 180.0f;
            } else if (facing == Direction.WEST) {
                rotY = 90.0f;
            } else if (facing == Direction.EAST) {
                rotY = -90.0f;
            }
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-rotY));
        }
        if (te.func_145831_w().func_175623_d(te.func_174877_v().func_177984_a())) {
            matrixStack.func_227861_a_(0.0, 0.0, -0.03749999403953552);
        } else {
            matrixStack.func_227861_a_(0.0, 0.0, 0.4624999761581421);
        }
        this.renderHud(matrixStack, buffer, Minecraft.func_71410_x().field_71466_p, te);
        matrixStack.func_227865_b_();
    }

    private void renderHud(MatrixStack matrixStack, IRenderTypeBuffer buffer, FontRenderer fontrenderer, ProcessorTileEntity tileEntity) {
        float factor = 1.0f;
        int currenty = 7;
        matrixStack.func_227861_a_(-0.5, 0.5, (double)0.07f);
        float f3 = 0.0075f;
        matrixStack.func_227862_a_(f3 * factor, -f3 * factor, f3);
        if (tileEntity.getShowHud() == 3) {
            this.renderGfx(matrixStack, buffer, tileEntity);
        } else {
            this.renderLog(matrixStack, buffer, fontrenderer, tileEntity, currenty);
        }
    }

    private void renderLog(MatrixStack matrixStack, IRenderTypeBuffer buffer, FontRenderer fontrenderer, ProcessorTileEntity tileEntity, int currenty) {
        List<String> log = tileEntity.getShowHud() == 2 ? tileEntity.getClientDebugLog() : tileEntity.getClientLog();
        long t = System.currentTimeMillis();
        if (t - tileEntity.clientTime > 250L) {
            if (tileEntity.getShowHud() == 2) {
                RFToolsCtrlMessages.INSTANCE.sendToServer((Object)new PacketGetDebugLog(tileEntity.func_174877_v()));
            } else {
                RFToolsCtrlMessages.INSTANCE.sendToServer((Object)new PacketGetLog(tileEntity.getDimension(), tileEntity.func_174877_v(), false));
            }
            tileEntity.clientTime = t;
        }
        int height = 10;
        int logsize = log.size();
        int i = 0;
        for (String s : log) {
            if (i >= logsize - 11 && currenty + height <= 124) {
                fontrenderer.func_228079_a_(fontrenderer.func_238412_a_(s, 115), 7.0f, (float)currenty, -1, false, matrixStack.func_227866_c_().func_227870_a_(), buffer, false, 0, 0xF000F0);
                currenty += height;
            }
            ++i;
        }
    }

    private void renderGfx(MatrixStack matrixStack, IRenderTypeBuffer buffer, ProcessorTileEntity tileEntity) {
        List<GfxOp> ops;
        long t = System.currentTimeMillis();
        if (t - tileEntity.clientTime > 250L) {
            RFToolsCtrlMessages.INSTANCE.sendToServer((Object)new PacketSendServerCommand("rftoolscontrol", "getGraphics", TypedMap.builder().put(CommandHandler.PARAM_POS, (Object)tileEntity.func_174877_v()).build()));
            tileEntity.clientTime = t;
        }
        if ((ops = tileEntity.getClientGfxOps()) != null) {
            for (GfxOp op : ops) {
                op.render(matrixStack, buffer);
            }
        }
    }

    public static void register() {
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ProcessorModule.PROCESSOR_TILE.get()), ProcessorRenderer::new);
    }
}

