/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.events.TextSpecialKeyEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolscontrol.modules.processor.ProcessorModule;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorContainer;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.logic.Parameter;
import mcjty.rftoolscontrol.modules.processor.logic.ParameterTypeTools;
import mcjty.rftoolscontrol.modules.processor.logic.editors.ParameterEditor;
import mcjty.rftoolscontrol.modules.processor.logic.editors.ParameterEditors;
import mcjty.rftoolscontrol.modules.processor.network.PacketGetFluids;
import mcjty.rftoolscontrol.modules.processor.network.PacketGetLog;
import mcjty.rftoolscontrol.modules.processor.network.PacketGetVariables;
import mcjty.rftoolscontrol.modules.processor.network.PacketVariableToServer;
import mcjty.rftoolscontrol.modules.processor.util.CardInfo;
import mcjty.rftoolscontrol.modules.programmer.client.GuiTools;
import mcjty.rftoolscontrol.setup.RFToolsCtrlMessages;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;

public class GuiProcessor
extends GenericGuiContainer<ProcessorTileEntity, ProcessorContainer> {
    public static final int SIDEWIDTH = 80;
    public static final int WIDTH = 256;
    public static final int HEIGHT = 236;
    private static final ResourceLocation mainBackground = new ResourceLocation("rftoolscontrol", "textures/gui/processor.png");
    private static final ResourceLocation sideBackground = new ResourceLocation("rftoolscontrol", "textures/gui/sidegui.png");
    private static final ResourceLocation icons = new ResourceLocation("rftoolscontrol", "textures/gui/icons.png");
    private Window sideWindow;
    private EnergyBar energyBar;
    private ToggleButton[] setupButtons = new ToggleButton[6];
    private WidgetList log;
    private WidgetList variableList;
    private WidgetList fluidList;
    private TextField command;
    private ToggleButton exclusive;
    private ChoiceLabel hudMode;
    private static List<String> commandHistory = new ArrayList<String>();
    private static int commandHistoryIndex = -1;
    private int[] fluidListMapping = new int[24];
    private static List<PacketGetFluids.FluidEntry> fromServer_fluids = new ArrayList<PacketGetFluids.FluidEntry>();
    private static List<Parameter> fromServer_vars = new ArrayList<Parameter>();
    private int listDirty = 0;

    public static void storeFluidsForClient(List<PacketGetFluids.FluidEntry> messages) {
        fromServer_fluids = new ArrayList<PacketGetFluids.FluidEntry>(messages);
    }

    public static void storeVarsForClient(List<Parameter> messages) {
        fromServer_vars = new ArrayList<Parameter>(messages);
    }

    public GuiProcessor(ProcessorTileEntity te, ProcessorContainer container, PlayerInventory inventory) {
        super((GenericTileEntity)te, (Container)container, inventory, ((BaseBlock)ProcessorModule.PROCESSOR.get()).getManualEntry());
        this.field_146999_f = 256;
        this.field_147000_g = 236;
    }

    public static void register() {
        GuiProcessor.register((ContainerType)((ContainerType)ProcessorModule.PROCESSOR_CONTAINER.get()), GuiProcessor::new);
        ScreenManager.IScreenFactory factory = (container, inventory, title) -> {
            GenericTileEntity te = container.getTe();
            return (GuiProcessor)((Object)((Object)Tools.safeMap((Object)te, tile -> new GuiProcessor((ProcessorTileEntity)((Object)((Object)tile)), (ProcessorContainer)container, inventory), (String)"Invalid tile entity!")));
        };
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ProcessorModule.PROCESSOR_CONTAINER_REMOTE.get()), (ScreenManager.IScreenFactory)factory);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        Panel toplevel = (Panel)Widgets.positional().background(mainBackground);
        toplevel.bounds(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        this.energyBar = ((EnergyBar)new EnergyBar().vertical().hint(122, 4, 70, 10)).showText(false).horizontal();
        toplevel.children(new Widget[]{this.energyBar});
        this.exclusive = (ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().hint(122, 16, 40, 15)).checkMarker(true).text("Excl.")).tooltips(new String[]{TextFormatting.YELLOW + "Exclusive mode", "If pressed then programs on", "card X can only run on core X"});
        this.exclusive.pressed(((ProcessorTileEntity)this.tileEntity).isExclusive());
        this.exclusive.event(() -> {
            ((ProcessorTileEntity)this.tileEntity).setExclusive(this.exclusive.isPressed());
            this.sendServerCommandTyped(RFToolsCtrlMessages.INSTANCE, "setExclusive", TypedMap.builder().put(ProcessorTileEntity.PARAM_EXCLUSIVE, (Object)this.exclusive.isPressed()).build());
        });
        toplevel.children(new Widget[]{this.exclusive});
        this.hudMode = ((ChoiceLabel)new ChoiceLabel().hint(163, 16, 28, 15)).choices(new String[]{"Off", "Log", "Db", "Gfx"}).choiceTooltip("Off", new String[]{"No overhead log"}).choiceTooltip("Log", new String[]{"Show the normal log"}).choiceTooltip("Db", new String[]{"Show a debug display"}).choiceTooltip("Gfx", new String[]{"Graphics display"});
        switch (((ProcessorTileEntity)this.tileEntity).getShowHud()) {
            case 0: {
                this.hudMode.choice("Off");
                break;
            }
            case 1: {
                this.hudMode.choice("Log");
                break;
            }
            case 2: {
                this.hudMode.choice("Db");
                break;
            }
            case 3: {
                this.hudMode.choice("Gfx");
            }
        }
        this.hudMode.event(newChoice -> {
            String choice = this.hudMode.getCurrentChoice();
            int m = 0;
            m = "Off".equals(choice) ? 0 : ("Log".equals(choice) ? 1 : ("Db".equals(choice) ? 2 : 3));
            this.sendServerCommandTyped(RFToolsCtrlMessages.INSTANCE, "setHudMode", TypedMap.builder().put(ProcessorTileEntity.PARAM_HUDMODE, (Object)m).build());
        });
        toplevel.children(new Widget[]{this.hudMode});
        this.setupLogWindow(toplevel);
        for (int i = 0; i < 6; ++i) {
            int finalI = i;
            this.setupButtons[i] = (ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().event(() -> this.setupMode((Widget<?>)this.setupButtons[finalI])).tooltips(new String[]{TextFormatting.YELLOW + "Resource allocation", "Setup item and variable", "allocation for this card"})).hint(11 + i * 18, 6, 15, 7)).userObject((Object)"allowed");
            toplevel.children(new Widget[]{this.setupButtons[i]});
        }
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        Panel listPanel = this.setupVariableListPanel();
        Panel sidePanel = (Panel)((Panel)Widgets.positional().background(sideBackground)).children(new Widget[]{listPanel});
        sidePanel.bounds(this.field_147003_i - 80, this.field_147009_r, 80, this.field_147000_g);
        this.sideWindow = new Window((Screen)this, (AbstractContainerWidget)sidePanel);
        this.field_230706_i_.field_195559_v.func_197967_a(true);
    }

    private void setupLogWindow(Panel toplevel) {
        this.log = ((WidgetList)((WidgetList)((WidgetList)Widgets.list((int)9, (int)35, (int)173, (int)98).name("log")).filledBackground(-16777216)).filledRectThickness(1)).rowheight(14).invisibleSelection(true).drawHorizontalLines(false);
        Slider slider = Widgets.slider((int)183, (int)35, (int)9, (int)98).vertical().scrollableName("log");
        this.command = Widgets.textfield((int)9, (int)134, (int)183, (int)15).addTextEnterEvent(this::executeCommand).specialKeyEvent(new TextSpecialKeyEvent(){

            public void arrowUp() {
                GuiProcessor.this.dumpHistory();
                if (commandHistoryIndex == -1) {
                    commandHistoryIndex = commandHistory.size() - 1;
                } else {
                    commandHistoryIndex--;
                    if (commandHistoryIndex < 0) {
                        commandHistoryIndex = 0;
                    }
                }
                if (commandHistoryIndex >= 0 && commandHistoryIndex < commandHistory.size()) {
                    GuiProcessor.this.command.text((String)commandHistory.get(commandHistoryIndex));
                }
                GuiProcessor.this.dumpHistory();
            }

            public void arrowDown() {
                GuiProcessor.this.dumpHistory();
                if (commandHistoryIndex != -1) {
                    commandHistoryIndex++;
                    if (commandHistoryIndex >= commandHistory.size()) {
                        commandHistoryIndex = -1;
                        GuiProcessor.this.command.text("");
                    } else {
                        GuiProcessor.this.command.text((String)commandHistory.get(commandHistoryIndex));
                    }
                }
                GuiProcessor.this.dumpHistory();
            }

            public void tab() {
            }
        });
        toplevel.children(new Widget[]{this.log, slider, this.command});
    }

    private void executeCommand(String text) {
        this.dumpHistory();
        this.sendServerCommandTyped(RFToolsCtrlMessages.INSTANCE, "execute", TypedMap.builder().put(ProcessorTileEntity.PARAM_CMD, (Object)text).build());
        if (!(commandHistoryIndex >= 0 && commandHistoryIndex < commandHistory.size() && text.equals(commandHistory.get(commandHistoryIndex)) || text.isEmpty())) {
            if (commandHistory.isEmpty() || !text.equals(commandHistory.get(commandHistory.size() - 1))) {
                commandHistory.add(text);
            }
            while (commandHistory.size() > 50) {
                commandHistory.remove(0);
            }
            commandHistoryIndex = -1;
        }
        this.command.text("");
        this.window.setTextFocus((Widget)this.command);
    }

    private void dumpHistory() {
    }

    private void requestLists() {
        RFToolsCtrlMessages.INSTANCE.sendToServer((Object)new PacketGetLog(((ProcessorTileEntity)this.tileEntity).getDimension(), ((ProcessorTileEntity)this.tileEntity).func_174877_v(), ((ProcessorTileEntity)this.tileEntity).isDummy()));
        RFToolsCtrlMessages.INSTANCE.sendToServer((Object)new PacketGetVariables(((ProcessorTileEntity)this.tileEntity).func_174877_v(), ((ProcessorTileEntity)this.tileEntity).getDimension(), ((ProcessorTileEntity)this.tileEntity).isDummy()));
        RFToolsCtrlMessages.INSTANCE.sendToServer((Object)new PacketGetFluids(((ProcessorTileEntity)this.tileEntity).func_174877_v(), ((ProcessorTileEntity)this.tileEntity).getDimension(), ((ProcessorTileEntity)this.tileEntity).isDummy()));
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.requestLists();
            this.listDirty = 10;
        }
    }

    private void populateLog() {
        boolean atend = this.log.getFirstSelected() + this.log.getCountSelected() >= this.log.getChildCount();
        this.log.removeChildren();
        for (String message : ((ProcessorTileEntity)this.tileEntity).getClientLog()) {
            this.log.children(new Widget[]{((Label)Widgets.label((String)message).color(-16742400)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)});
        }
        if (atend) {
            this.log.setFirstSelected(this.log.getChildCount());
        }
    }

    private void setupMode(Widget<?> parent) {
        ToggleButton tb = (ToggleButton)parent;
        if (tb.isPressed()) {
            for (ToggleButton button : this.setupButtons) {
                if (button == tb) continue;
                button.pressed(false);
            }
        }
        this.updateVariableList();
    }

    private int getSetupMode() {
        for (int i = 0; i < this.setupButtons.length; ++i) {
            if (!this.setupButtons[i].isPressed()) continue;
            return i;
        }
        return -1;
    }

    public boolean func_231044_a_(double x, double y, int button) {
        int setupMode = this.getSetupMode();
        if (setupMode == -1) {
            super.func_231044_a_(x, y, button);
        } else {
            Widget w;
            Optional widget = this.getWindowManager().findWidgetAtPosition(x, y);
            if (widget.isPresent() && "allowed".equals((w = (Widget)widget.get()).getUserObject())) {
                return super.func_231044_a_(x, y, button);
            }
            int leftx = this.window.getToplevel().getBounds().x;
            int topy = this.window.getToplevel().getBounds().y;
            x -= (double)leftx;
            y -= (double)topy;
            CardInfo cardInfo = ((ProcessorTileEntity)this.tileEntity).getCardInfo(setupMode);
            int itemAlloc = cardInfo.getItemAllocation();
            int varAlloc = cardInfo.getVarAllocation();
            int fluidAlloc = cardInfo.getFluidAllocation();
            for (int i = 0; i < 24; ++i) {
                Slot slot = ((ProcessorContainer)this.field_147002_h).func_75139_a(22 + i);
                if (!(x >= (double)slot.field_75223_e) || !(x <= (double)(slot.field_75223_e + 17)) || !(y >= (double)slot.field_75221_f) || !(y <= (double)(slot.field_75221_f + 17))) continue;
                boolean allocated = (itemAlloc >> i & 1) != 0;
                boolean bl = allocated = !allocated;
                itemAlloc = allocated ? (itemAlloc |= 1 << i) : (itemAlloc &= ~(1 << i));
                cardInfo.setItemAllocation(itemAlloc);
                this.sendServerCommandTyped(RFToolsCtrlMessages.INSTANCE, "allocate", TypedMap.builder().put(ProcessorTileEntity.PARAM_CARD, (Object)setupMode).put(ProcessorTileEntity.PARAM_ITEMS, (Object)itemAlloc).put(ProcessorTileEntity.PARAM_VARS, (Object)varAlloc).put(ProcessorTileEntity.PARAM_FLUID, (Object)fluidAlloc).build());
                break;
            }
        }
        return true;
    }

    protected void registerWindows(WindowManager mgr) {
        super.registerWindows(mgr);
        mgr.addWindow(this.sideWindow);
        mgr.getIconManager().setClickHoldToDrag(true);
    }

    private Panel setupVariableListPanel() {
        this.fluidList = (WidgetList)((WidgetList)Widgets.list((int)0, (int)0, (int)62, (int)65).name("fluids")).propagateEventsToChildren(true).invisibleSelection(true).drawHorizontalLines(false).userObject((Object)"allowed");
        this.fluidList.event(new SelectionEvent(){

            public void select(int i) {
                int setupMode = GuiProcessor.this.getSetupMode();
                if (setupMode != -1) {
                    int idx;
                    CardInfo cardInfo = ((ProcessorTileEntity)GuiProcessor.this.tileEntity).getCardInfo(setupMode);
                    int varAlloc = cardInfo.getVarAllocation();
                    int itemAlloc = cardInfo.getItemAllocation();
                    int fluidAlloc = cardInfo.getFluidAllocation();
                    boolean allocated = (fluidAlloc >> (idx = GuiProcessor.this.fluidListMapping[i]) & 1) != 0;
                    boolean bl = allocated = !allocated;
                    fluidAlloc = allocated ? (fluidAlloc |= 1 << idx) : (fluidAlloc &= ~(1 << idx));
                    cardInfo.setFluidAllocation(fluidAlloc);
                    GuiProcessor.this.sendServerCommandTyped(RFToolsCtrlMessages.INSTANCE, "allocate", TypedMap.builder().put(ProcessorTileEntity.PARAM_CARD, (Object)setupMode).put(ProcessorTileEntity.PARAM_ITEMS, (Object)itemAlloc).put(ProcessorTileEntity.PARAM_VARS, (Object)varAlloc).put(ProcessorTileEntity.PARAM_FLUID, (Object)fluidAlloc).build());
                    GuiProcessor.this.updateFluidList();
                    GuiProcessor.this.fluidList.selected(-1);
                }
            }

            public void doubleClick(int index) {
            }
        });
        Slider fluidSlider = (Slider)Widgets.slider((int)62, (int)0, (int)9, (int)65).vertical().scrollableName("fluids").userObject((Object)"allowed");
        this.updateFluidList();
        this.variableList = (WidgetList)((WidgetList)Widgets.list((int)0, (int)67, (int)62, (int)161).name("variables")).propagateEventsToChildren(true).invisibleSelection(true).drawHorizontalLines(false).userObject((Object)"allowed");
        this.variableList.event(new SelectionEvent(){

            public void select(int i) {
                int setupMode = GuiProcessor.this.getSetupMode();
                if (setupMode != -1) {
                    CardInfo cardInfo = ((ProcessorTileEntity)GuiProcessor.this.tileEntity).getCardInfo(setupMode);
                    int varAlloc = cardInfo.getVarAllocation();
                    int itemAlloc = cardInfo.getItemAllocation();
                    int fluidAlloc = cardInfo.getFluidAllocation();
                    boolean allocated = (varAlloc >> i & 1) != 0;
                    boolean bl = allocated = !allocated;
                    varAlloc = allocated ? (varAlloc |= 1 << i) : (varAlloc &= ~(1 << i));
                    cardInfo.setVarAllocation(varAlloc);
                    GuiProcessor.this.sendServerCommandTyped(RFToolsCtrlMessages.INSTANCE, "allocate", TypedMap.builder().put(ProcessorTileEntity.PARAM_CARD, (Object)setupMode).put(ProcessorTileEntity.PARAM_ITEMS, (Object)itemAlloc).put(ProcessorTileEntity.PARAM_VARS, (Object)varAlloc).put(ProcessorTileEntity.PARAM_FLUID, (Object)fluidAlloc).build());
                    GuiProcessor.this.updateVariableList();
                    GuiProcessor.this.variableList.selected(-1);
                }
            }

            public void doubleClick(int index) {
            }
        });
        Slider varSlider = (Slider)Widgets.slider((int)62, (int)67, (int)9, (int)161).vertical().scrollableName("variables").userObject((Object)"allowed");
        this.updateVariableList();
        return (Panel)((Panel)((Panel)Widgets.positional().hint(5, 5, 72, 220)).children(new Widget[]{this.variableList, varSlider, this.fluidList, fluidSlider})).userObject((Object)"allowed");
    }

    private void openValueEditor(int varIdx) {
        if (fromServer_vars == null || varIdx > fromServer_vars.size()) {
            return;
        }
        if (fromServer_vars.get(varIdx) == null) {
            GuiTools.showMessage(this.field_230706_i_, (Screen)this, this.getWindowManager(), 50, 50, "Variable is not defined!");
            return;
        }
        Parameter parameter = fromServer_vars.get(varIdx);
        if (parameter == null) {
            GuiTools.showMessage(this.field_230706_i_, (Screen)this, this.getWindowManager(), 50, 50, "Variable is not defined!");
            return;
        }
        ParameterType type = parameter.getParameterType();
        ParameterEditor editor = ParameterEditors.getEditor(type);
        if (editor == null) {
            return;
        }
        Panel editPanel = (Panel)Widgets.positional().filledRectThickness(1);
        editor.build(this.field_230706_i_, (Screen)this, editPanel, o -> {
            CompoundNBT tag = new CompoundNBT();
            ParameterTypeTools.writeToNBT(tag, type, o);
            RFToolsCtrlMessages.INSTANCE.sendToServer((Object)new PacketVariableToServer(((ProcessorTileEntity)this.tileEntity).func_174877_v(), varIdx, tag));
        });
        editor.writeValue(parameter.getParameterValue());
        editor.constantOnly();
        Panel panel = (Panel)((Panel)Widgets.vertical().filledBackground(-10066330, -5592406)).filledRectThickness(1);
        panel.bounds(50, 50, 200, 60 + editor.getHeight());
        Window modalWindow = this.getWindowManager().createModalWindow((AbstractContainerWidget)panel);
        panel.children(new Widget[]{Widgets.label((String)("Var " + varIdx + ":")), editPanel, Widgets.button((String)"Close").channel("close")});
        modalWindow.event("close", (source, params) -> this.getWindowManager().closeWindow(modalWindow));
    }

    private void updateFluidList() {
        this.fluidList.removeChildren();
        for (int i = 0; i < this.fluidListMapping.length; ++i) {
            this.fluidListMapping[i] = -1;
        }
        int setupMode = this.getSetupMode();
        int fluidAlloc = 0;
        if (setupMode != -1) {
            CardInfo cardInfo = ((ProcessorTileEntity)this.tileEntity).getCardInfo(setupMode);
            fluidAlloc = cardInfo.getFluidAllocation();
        }
        this.fluidList.propagateEventsToChildren(setupMode == -1);
        int index = 0;
        for (int i = 0; i < fromServer_fluids.size(); ++i) {
            AbstractWidget label;
            PacketGetFluids.FluidEntry entry = fromServer_fluids.get(i);
            if (!entry.isAllocated()) continue;
            this.fluidListMapping[this.fluidList.getChildCount()] = i;
            Direction side = Direction.values()[i / 4];
            String l = side.func_176610_l().substring(0, 1).toUpperCase() + i % 4;
            Panel panel = (Panel)Widgets.horizontal().desiredWidth(40);
            if (setupMode != -1) {
                boolean allocated;
                boolean bl = allocated = (fluidAlloc >> i & 1) != 0;
                int fill = allocated ? 0x7700FF00 : (((ProcessorTileEntity)this.tileEntity).isFluidAllocated(-1, i) ? 0x77660000 : 0x77444444);
                panel.filledBackground(fill);
                if (allocated) {
                    label = ((Label)((Label)Widgets.label((String)String.valueOf(index)).color(-1)).desiredWidth(26)).userObject((Object)"allowed");
                    ++index;
                } else {
                    label = ((Label)Widgets.label((String)"/").desiredWidth(26)).userObject((Object)"allowed");
                }
            } else {
                label = ((Label)Widgets.label((String)l).desiredWidth(26)).userObject((Object)"allowed");
            }
            label.userObject((Object)"allowed");
            panel.children(new Widget[]{label});
            FluidStack fluidStack = entry.getFluidStack();
            if (fluidStack != null) {
                BlockRender fluid = new BlockRender().renderItem((Object)fluidStack);
                fluid.tooltips(new String[]{TextFormatting.GREEN + "Fluid: " + TextFormatting.WHITE + fluidStack.getDisplayName().getString(), TextFormatting.GREEN + "Amount: " + TextFormatting.WHITE + fluidStack.getAmount() + "mb"});
                fluid.userObject((Object)"allowed");
                panel.children(new Widget[]{fluid});
            }
            panel.userObject((Object)"allowed");
            this.fluidList.children(new Widget[]{panel});
        }
    }

    private void updateVariableList() {
        this.variableList.removeChildren();
        int setupMode = this.getSetupMode();
        int varAlloc = 0;
        if (setupMode != -1) {
            CardInfo cardInfo = ((ProcessorTileEntity)this.tileEntity).getCardInfo(setupMode);
            varAlloc = cardInfo.getVarAllocation();
        }
        this.variableList.propagateEventsToChildren(setupMode == -1);
        int index = 0;
        int i = 0;
        while (i < ((ProcessorTileEntity)this.tileEntity).getMaxvars()) {
            Panel panel = (Panel)Widgets.horizontal().desiredWidth(40);
            if (setupMode != -1) {
                boolean allocated;
                boolean bl = allocated = (varAlloc >> i & 1) != 0;
                int fill = allocated ? 0x7700FF00 : (((ProcessorTileEntity)this.tileEntity).isVarAllocated(-1, i) ? 0x77660000 : 0x77444444);
                panel.filledBackground(fill);
                if (allocated) {
                    panel.children(new Widget[]{((Label)((Label)Widgets.label((String)String.valueOf(index)).color(-1)).desiredWidth(26)).userObject((Object)"allowed")});
                    ++index;
                } else {
                    panel.children(new Widget[]{((Label)Widgets.label((String)"/").desiredWidth(26)).userObject((Object)"allowed")});
                }
            } else {
                panel.children(new Widget[]{((Label)Widgets.label((String)String.valueOf(i)).desiredWidth(26)).userObject((Object)"allowed")});
            }
            int finalI = i++;
            panel.children(new Widget[]{Widgets.button((String)"...").event(() -> this.openValueEditor(finalI)).userObject((Object)"allowed")});
            panel.userObject((Object)"allowed");
            this.variableList.children(new Widget[]{panel});
        }
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        if (this.variableList.getChildCount() != ((ProcessorTileEntity)this.tileEntity).getMaxvars()) {
            this.updateVariableList();
        }
        this.updateFluidList();
        this.requestListsIfNeeded();
        this.populateLog();
        this.drawWindow(matrixStack);
        this.updateEnergyBar(this.energyBar);
        this.drawAllocatedSlots(matrixStack);
    }

    private void drawAllocatedSlots(MatrixStack matrixStack) {
        int setupMode = this.getSetupMode();
        if (setupMode == -1) {
            return;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)this.field_147003_i, (double)this.field_147009_r, 0.0);
        CardInfo cardInfo = ((ProcessorTileEntity)this.tileEntity).getCardInfo(setupMode);
        int itemAlloc = cardInfo.getItemAllocation();
        int index = 0;
        for (int i = 0; i < 24; ++i) {
            int border;
            Slot slot = ((ProcessorContainer)this.field_147002_h).func_75139_a(22 + i);
            boolean allocated = (itemAlloc >> i & 1) != 0;
            int n = border = allocated ? -1 : -1431655766;
            int fill = allocated ? 0x7700FF00 : (((ProcessorTileEntity)this.tileEntity).isItemAllocated(-1, i) ? 0x77660000 : 0x77444444);
            RenderHelper.drawFlatBox((MatrixStack)matrixStack, (int)slot.field_75223_e, (int)slot.field_75221_f, (int)(slot.field_75223_e + 17), (int)(slot.field_75221_f + 17), (int)border, (int)fill);
            if (!allocated) continue;
            GuiProcessor.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)("" + index), (int)(slot.field_75223_e + 4), (int)(slot.field_75221_f + 4), (int)-1);
            ++index;
        }
        matrixStack.func_227865_b_();
    }
}

