/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.module;

import com.google.common.collect.ImmutableSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.building.block.LeafCarpetBlock;
import vazkii.quark.content.world.block.BlossomLeavesBlock;
import vazkii.quark.content.world.module.BlossomTreesModule;

@LoadModule(category=ModuleCategory.BUILDING)
public class LeafCarpetModule
extends QuarkModule {
    public static List<LeafCarpetBlock> carpets = new LinkedList<LeafCarpetBlock>();

    @Override
    public void construct() {
        ImmutableSet.of((Object)Blocks.field_196642_W, (Object)Blocks.field_196645_X, (Object)Blocks.field_196647_Y, (Object)Blocks.field_196648_Z, (Object)Blocks.field_196572_aa, (Object)Blocks.field_196574_ab, (Object[])new Block[0]).forEach(this::carpet);
    }

    @Override
    public void modulesStarted() {
        BlossomTreesModule.trees.keySet().stream().map(t -> (BlossomLeavesBlock)t.leaf.func_177230_c()).forEach(this::blossomCarpet);
    }

    @Override
    public void loadComplete() {
        this.enqueue(() -> {
            for (LeafCarpetBlock c : carpets) {
                if (c.func_199767_j() == null) continue;
                ComposterBlock.field_220299_b.put((Object)c.func_199767_j(), 0.2f);
            }
        });
    }

    private void carpet(Block base) {
        this.carpetBlock(base);
    }

    private void blossomCarpet(BlossomLeavesBlock base) {
        this.carpetBlock((Block)base).setCondition(() -> base.isEnabled());
    }

    private LeafCarpetBlock carpetBlock(Block base) {
        LeafCarpetBlock carpet = new LeafCarpetBlock(base.getRegistryName().func_110623_a().replaceAll("_leaves", ""), base, this);
        carpets.add(carpet);
        return carpet;
    }
}

