/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.block;

import it.unimi.dsi.fastutil.floats.Float2ObjectArrayMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.QuarkModule;

public class GrateBlock
extends QuarkBlock
implements IWaterLoggable {
    private static final VoxelShape TRUE_SHAPE = GrateBlock.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Float2ObjectArrayMap<VoxelShape> WALK_BLOCK_CACHE = new Float2ObjectArrayMap();
    public static BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public GrateBlock(QuarkModule module) {
        super("grate", module, ItemGroup.field_78031_c, AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(5.0f, 10.0f).func_200947_a(SoundType.field_185852_e).func_226896_b_());
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
    }

    private static VoxelShape createNewBox(double stepHeight) {
        return GrateBlock.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)(17.0 + 16.0 * stepHeight), (double)16.0);
    }

    public boolean func_208619_r() {
        return true;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return TRUE_SHAPE;
    }

    private static VoxelShape getCachedShape(float stepHeight) {
        return (VoxelShape)WALK_BLOCK_CACHE.computeIfAbsent(stepHeight, GrateBlock::createNewBox);
    }

    @Nonnull
    public VoxelShape func_220071_b(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, ISelectionContext context) {
        Entity entity = context.getEntity();
        if (entity != null) {
            if (entity instanceof ItemEntity || entity instanceof ExperienceOrbEntity) {
                return VoxelShapes.func_197880_a();
            }
            boolean animal = entity instanceof AnimalEntity;
            boolean leashed = animal && ((AnimalEntity)entity).func_110166_bE() != null;
            boolean onGrate = world.func_180495_p(entity.func_233580_cy_().func_177982_a(0, -1, 0)).func_177230_c() instanceof GrateBlock;
            if (animal && !leashed && !onGrate) {
                return GrateBlock.getCachedShape(entity.field_70138_W);
            }
            return TRUE_SHAPE;
        }
        return TRUE_SHAPE;
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        if (entity instanceof AnimalEntity) {
            return PathNodeType.DAMAGE_OTHER;
        }
        return null;
    }

    @Nonnull
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }

    public boolean func_196266_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, PathType path) {
        return false;
    }

    public boolean func_200123_i(BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) == false;
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, EntityType<?> entityType) {
        return false;
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }
}

