/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.DaylightDetectorFrameBlock;
import mod.pianomanu.blockcarpentry.setup.Registration;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DaylightDetectorFrameTileEntity
extends TileEntity
implements ITickableTileEntity {
    public static final ModelProperty<BlockState> MIMIC = new ModelProperty();
    public static final ModelProperty<Integer> TEXTURE = new ModelProperty();
    public static final ModelProperty<Integer> DESIGN = new ModelProperty();
    public static final ModelProperty<Integer> DESIGN_TEXTURE = new ModelProperty();
    public static final ModelProperty<Integer> GLASS_COLOR = new ModelProperty();
    public static final ModelProperty<Integer> OVERLAY = new ModelProperty();
    public static final ModelProperty<Integer> ROTATION = new ModelProperty();
    public static final ModelProperty<Boolean> NORTH_VISIBLE = new ModelProperty();
    public static final ModelProperty<Boolean> EAST_VISIBLE = new ModelProperty();
    public static final ModelProperty<Boolean> SOUTH_VISIBLE = new ModelProperty();
    public static final ModelProperty<Boolean> WEST_VISIBLE = new ModelProperty();
    public static final ModelProperty<Boolean> UP_VISIBLE = new ModelProperty();
    public static final ModelProperty<Boolean> DOWN_VISIBLE = new ModelProperty();
    private static final Logger LOGGER = LogManager.getLogger();
    public final int maxTextures = 8;
    public final int maxDesignTextures = 4;
    public final int maxDesigns = 4;
    private BlockState mimic;
    private Integer texture = 0;
    private Integer design = 0;
    private Integer designTexture = 0;
    private Integer glassColor = 0;
    private Integer overlay = 0;
    private Integer rotation = 0;
    private Boolean northVisible = true;
    private Boolean eastVisible = true;
    private Boolean southVisible = true;
    private Boolean westVisible = true;
    private Boolean upVisible = true;
    private Boolean downVisible = true;

    public DaylightDetectorFrameTileEntity() {
        super((TileEntityType)Registration.DAYLIGHT_DETECTOR_FRAME_TILE.get());
    }

    private static Integer readInteger(CompoundNBT tag) {
        if (!tag.func_150297_b("number", 8)) {
            return 0;
        }
        try {
            return Integer.parseInt(tag.func_74779_i("number"));
        }
        catch (NumberFormatException e) {
            LOGGER.error("Not a valid Number Format: " + tag.func_74779_i("number"));
            return 0;
        }
    }

    private static CompoundNBT writeInteger(Integer tag) {
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74778_a("number", tag.toString());
        return compoundnbt;
    }

    public void func_73660_a() {
        BlockState blockstate;
        Block block;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L && (block = (blockstate = this.func_195044_w()).func_177230_c()) instanceof DaylightDetectorFrameBlock) {
            DaylightDetectorFrameBlock.func_196319_d((BlockState)blockstate, (World)this.field_145850_b, (BlockPos)this.field_174879_c);
        }
    }

    public BlockState getMimic() {
        return this.mimic;
    }

    public void setMimic(BlockState mimic) {
        this.mimic = mimic;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public Integer getDesign() {
        return this.design;
    }

    public void setDesign(Integer design) {
        this.design = design;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public Integer getDesignTexture() {
        return this.designTexture;
    }

    public void setDesignTexture(Integer designTexture) {
        this.designTexture = designTexture;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public Integer getTexture() {
        return this.texture;
    }

    public void setTexture(Integer texture) {
        this.texture = texture;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public Integer getGlassColor() {
        return this.glassColor;
    }

    public void setGlassColor(Integer colorNumber) {
        this.glassColor = colorNumber;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public Integer getRotation() {
        return this.rotation;
    }

    public void setRotation(Integer rotation) {
        this.rotation = rotation;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public void setVisibileSides(Direction dir, boolean isVisible) {
        switch (dir) {
            case DOWN: {
                this.downVisible = isVisible;
                break;
            }
            case UP: {
                this.upVisible = isVisible;
                break;
            }
            case NORTH: {
                this.northVisible = isVisible;
                break;
            }
            case WEST: {
                this.westVisible = isVisible;
                break;
            }
            case SOUTH: {
                this.southVisible = isVisible;
                break;
            }
            case EAST: {
                this.eastVisible = isVisible;
                break;
            }
        }
    }

    public List<Direction> getVisibleSides() {
        ArrayList<Direction> dir = new ArrayList<Direction>();
        if (this.northVisible.booleanValue()) {
            dir.add(Direction.NORTH);
        }
        if (this.eastVisible.booleanValue()) {
            dir.add(Direction.EAST);
        }
        if (this.southVisible.booleanValue()) {
            dir.add(Direction.SOUTH);
        }
        if (this.westVisible.booleanValue()) {
            dir.add(Direction.WEST);
        }
        if (this.upVisible.booleanValue()) {
            dir.add(Direction.UP);
        }
        if (this.downVisible.booleanValue()) {
            dir.add(Direction.DOWN);
        }
        return dir;
    }

    public Integer getOverlay() {
        return this.overlay;
    }

    public void setOverlay(Integer overlay) {
        this.overlay = overlay;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        if (this.mimic != null) {
            tag.func_218657_a("mimic", (INBT)NBTUtil.func_190009_a((BlockState)this.mimic));
        }
        if (this.texture != null) {
            tag.func_218657_a("texture", (INBT)DaylightDetectorFrameTileEntity.writeInteger(this.texture));
        }
        if (this.design != null) {
            tag.func_218657_a("design", (INBT)DaylightDetectorFrameTileEntity.writeInteger(this.design));
        }
        if (this.designTexture != null) {
            tag.func_218657_a("design_texture", (INBT)DaylightDetectorFrameTileEntity.writeInteger(this.designTexture));
        }
        if (this.glassColor != null) {
            tag.func_218657_a("glass_color", (INBT)DaylightDetectorFrameTileEntity.writeInteger(this.glassColor));
        }
        if (this.overlay != null) {
            tag.func_218657_a("overlay", (INBT)DaylightDetectorFrameTileEntity.writeInteger(this.overlay));
        }
        if (this.rotation != null) {
            tag.func_218657_a("rotation", (INBT)DaylightDetectorFrameTileEntity.writeInteger(this.rotation));
        }
        return tag;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        BlockState oldMimic = this.mimic;
        Integer oldTexture = this.texture;
        Integer oldDesign = this.design;
        Integer oldDesignTexture = this.designTexture;
        Integer oldGlassColor = this.glassColor;
        Integer oldOverlay = this.overlay;
        Integer oldRotation = this.rotation;
        CompoundNBT tag = pkt.func_148857_g();
        if (tag.func_74764_b("mimic")) {
            this.mimic = NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l("mimic"));
            if (!Objects.equals(oldMimic, this.mimic)) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
        if (tag.func_74764_b("texture")) {
            this.texture = DaylightDetectorFrameTileEntity.readInteger(tag.func_74775_l("texture"));
            if (!Objects.equals(oldTexture, this.texture)) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
        if (tag.func_74764_b("design")) {
            this.design = DaylightDetectorFrameTileEntity.readInteger(tag.func_74775_l("design"));
            if (!Objects.equals(oldDesign, this.design)) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
        if (tag.func_74764_b("design_texture")) {
            this.designTexture = DaylightDetectorFrameTileEntity.readInteger(tag.func_74775_l("design_texture"));
            if (!Objects.equals(oldDesignTexture, this.designTexture)) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
        if (tag.func_74764_b("glass_color")) {
            this.glassColor = DaylightDetectorFrameTileEntity.readInteger(tag.func_74775_l("glass_color"));
            if (!Objects.equals(oldGlassColor, this.glassColor)) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
        if (tag.func_74764_b("overlay")) {
            this.overlay = DaylightDetectorFrameTileEntity.readInteger(tag.func_74775_l("overlay"));
            if (!Objects.equals(oldOverlay, this.overlay)) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
        if (tag.func_74764_b("rotation")) {
            this.rotation = DaylightDetectorFrameTileEntity.readInteger(tag.func_74775_l("rotation"));
            if (!Objects.equals(oldRotation, this.rotation)) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(MIMIC, (Object)this.mimic).withInitial(TEXTURE, (Object)this.texture).withInitial(DESIGN, (Object)this.design).withInitial(DESIGN_TEXTURE, (Object)this.designTexture).withInitial(GLASS_COLOR, (Object)this.glassColor).withInitial(OVERLAY, (Object)this.overlay).withInitial(ROTATION, (Object)this.rotation).withInitial(NORTH_VISIBLE, (Object)this.northVisible).withInitial(EAST_VISIBLE, (Object)this.eastVisible).withInitial(SOUTH_VISIBLE, (Object)this.southVisible).withInitial(WEST_VISIBLE, (Object)this.westVisible).withInitial(UP_VISIBLE, (Object)this.upVisible).withInitial(DOWN_VISIBLE, (Object)this.downVisible).build();
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        if (tag.func_74764_b("mimic")) {
            this.mimic = NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l("mimic"));
        }
        if (tag.func_74764_b("texture")) {
            this.texture = DaylightDetectorFrameTileEntity.readInteger(tag.func_74775_l("texture"));
        }
        if (tag.func_74764_b("design")) {
            this.design = DaylightDetectorFrameTileEntity.readInteger(tag.func_74775_l("design"));
        }
        if (tag.func_74764_b("design_texture")) {
            this.designTexture = DaylightDetectorFrameTileEntity.readInteger(tag.func_74775_l("design_texture"));
        }
        if (tag.func_74764_b("glass_color")) {
            this.glassColor = DaylightDetectorFrameTileEntity.readInteger(tag.func_74775_l("glass_color"));
        }
        if (tag.func_74764_b("overlay")) {
            this.overlay = DaylightDetectorFrameTileEntity.readInteger(tag.func_74775_l("overlay"));
        }
        if (tag.func_74764_b("rotation")) {
            this.rotation = DaylightDetectorFrameTileEntity.readInteger(tag.func_74775_l("rotation"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        if (this.mimic != null) {
            tag.func_218657_a("mimic", (INBT)NBTUtil.func_190009_a((BlockState)this.mimic));
        }
        if (this.texture != null) {
            tag.func_218657_a("texture", (INBT)DaylightDetectorFrameTileEntity.writeInteger(this.texture));
        }
        if (this.design != null) {
            tag.func_218657_a("design", (INBT)DaylightDetectorFrameTileEntity.writeInteger(this.design));
        }
        if (this.designTexture != null) {
            tag.func_218657_a("design_texture", (INBT)DaylightDetectorFrameTileEntity.writeInteger(this.designTexture));
        }
        if (this.glassColor != null) {
            tag.func_218657_a("glass_color", (INBT)DaylightDetectorFrameTileEntity.writeInteger(this.glassColor));
        }
        if (this.overlay != null) {
            tag.func_218657_a("overlay", (INBT)DaylightDetectorFrameTileEntity.writeInteger(this.overlay));
        }
        if (this.rotation != null) {
            tag.func_218657_a("rotation", (INBT)DaylightDetectorFrameTileEntity.writeInteger(this.rotation));
        }
        return super.func_189515_b(tag);
    }

    public void clear() {
        this.setMimic(null);
        this.setDesign(0);
        this.setDesign(0);
        this.setDesign(0);
        this.setGlassColor(0);
        this.setOverlay(0);
        this.setRotation(0);
    }
}

