/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.FrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.block.BlockState;
import net.minecraft.block.StairsBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.Property;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class SlopeBakedModel
implements IDynamicBakedModel {
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        ModelResourceLocation location;
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        if (mimic != null && !(mimic.func_177230_c() instanceof FrameBlock) && (location = BlockModelShapes.func_209554_c((BlockState)mimic)) != null) {
            IBakedModel model = Minecraft.func_71410_x().func_209506_al().func_174953_a(location);
            model.getBakedModel().getQuads(mimic, side, rand, extraData);
            if (model != null) {
                return this.getMimicQuads(state, side, rand, extraData, model);
            }
        }
        return Collections.emptyList();
    }

    private static Vector3d v(double x, double y, double z) {
        return new Vector3d(x, y, z);
    }

    public List<BakedQuad> getMimicQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData, IBakedModel model) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        List<TextureAtlasSprite> texture = TextureHelper.getTextureFromModel(model, extraData, rand);
        int index = (Integer)extraData.getData(FrameBlockTile.TEXTURE);
        if (index >= texture.size()) {
            index = 0;
        }
        if (texture.size() == 0) {
            if (Minecraft.func_71410_x().field_71439_g != null) {
                Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("message.blockcarpentry.block_not_available"), true);
            }
            for (int i = 0; i < 6; ++i) {
                texture.add((TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("missing")));
            }
        }
        int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
        double w = 0.5;
        if (state.func_177229_b((Property)StairsBlock.field_176308_b) == Half.TOP) {
            w = -0.5;
        }
        Vector3d NWU = SlopeBakedModel.v(0.0, 0.5 + w, 0.0);
        Vector3d NEU = SlopeBakedModel.v(1.0, 0.5 + w, 0.0);
        Vector3d NWD = SlopeBakedModel.v(0.0, 0.5 - w, 0.0);
        Vector3d NED = SlopeBakedModel.v(1.0, 0.5 - w, 0.0);
        Vector3d SWU = SlopeBakedModel.v(0.0, 0.5 + w, 1.0);
        Vector3d SEU = SlopeBakedModel.v(1.0, 0.5 + w, 1.0);
        Vector3d SWD = SlopeBakedModel.v(0.0, 0.5 - w, 1.0);
        Vector3d SED = SlopeBakedModel.v(1.0, 0.5 - w, 1.0);
        quads.addAll(this.createSlope(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, texture.get(index), tintIndex, (Direction)state.func_177229_b((Property)StairsBlock.field_176309_a), (StairsShape)state.func_177229_b((Property)StairsBlock.field_176310_M), (Half)state.func_177229_b((Property)StairsBlock.field_176308_b)));
        return quads;
    }

    public List<BakedQuad> createSlope(float xl, float xh, float yl, float yh, float zl, float zh, TextureAtlasSprite texture, int tintIndex, Direction direction, StairsShape shape, Half half) {
        boolean isBottom;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vector3d NWU = SlopeBakedModel.v(xl, yh, zl);
        Vector3d SWU = SlopeBakedModel.v(xl, yh, zh);
        Vector3d NWD = SlopeBakedModel.v(xl, yl, zl);
        Vector3d SWD = SlopeBakedModel.v(xl, yl, zh);
        Vector3d NEU = SlopeBakedModel.v(xh, yh, zl);
        Vector3d SEU = SlopeBakedModel.v(xh, yh, zh);
        Vector3d NED = SlopeBakedModel.v(xh, yl, zl);
        Vector3d SED = SlopeBakedModel.v(xh, yl, zh);
        if (xh - xl > 1.0f || yh - yl > 1.0f || zh - zl > 1.0f) {
            if (Minecraft.func_71410_x().field_71439_g != null) {
                Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("An error occured with this block, please report to the mod author (PianoManu)"), true);
            }
            return quads;
        }
        boolean bl = isBottom = half == Half.BOTTOM;
        if (isBottom) {
            quads.add(ModelHelper.createQuad(SWD, NWD, NED, SED, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
            block0 : switch (shape) {
                case STRAIGHT: {
                    switch (direction) {
                        case NORTH: {
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWD, SWD, NWU, NWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, SWD, SED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            break block0;
                        }
                        case EAST: {
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NED, NWD, NWD, NEU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SED, SEU, SEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWD, SEU, NEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            break block0;
                        }
                        case SOUTH: {
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NED, SEU, SED, NED, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWD, SWU, SEU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            break block0;
                        }
                        case WEST: {
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NED, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWD, SED, SWU, SWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SED, NED, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                        }
                    }
                    break;
                }
                case OUTER_LEFT: {
                    switch (direction) {
                        case NORTH: {
                            quads.add(ModelHelper.createQuad(NED, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWD, SWD, NWU, NWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWD, SED, NWU, NWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, SED, NED, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            break block0;
                        }
                        case EAST: {
                            quads.add(ModelHelper.createQuad(NEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NED, NWD, NWD, NEU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWD, SWD, NEU, NEU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SED, NEU, NEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            break block0;
                        }
                        case SOUTH: {
                            quads.add(ModelHelper.createQuad(SED, SEU, SEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NED, SEU, SED, NED, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NED, NWD, NWD, SEU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, NWD, SWD, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            break block0;
                        }
                        case WEST: {
                            quads.add(ModelHelper.createQuad(SWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWD, SED, SWU, SWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NED, SWU, SED, NED, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NED, NED, NWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                        }
                    }
                    break;
                }
                case OUTER_RIGHT: {
                    switch (direction) {
                        case NORTH: {
                            quads.add(ModelHelper.createQuad(NEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NED, NWD, NWD, NEU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWD, SWD, NEU, NEU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SED, NEU, NEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            break block0;
                        }
                        case EAST: {
                            quads.add(ModelHelper.createQuad(SED, SEU, SEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NED, SEU, SED, NED, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NED, NWD, NWD, SEU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, NWD, SWD, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            break block0;
                        }
                        case SOUTH: {
                            quads.add(ModelHelper.createQuad(SWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWD, SED, SWU, SWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NED, SWU, SED, NED, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NED, NED, NWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            break block0;
                        }
                        case WEST: {
                            quads.add(ModelHelper.createQuad(NED, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWD, SWD, NWU, NWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWD, SED, NWU, NWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, SED, NED, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                        }
                    }
                    break;
                }
                case INNER_LEFT: {
                    switch (direction) {
                        case NORTH: {
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, SWD, SED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWD, SED, SWU, SWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SED, NED, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            break block0;
                        }
                        case EAST: {
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SED, SEU, SEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWD, SEU, NEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWD, SWD, NWU, NWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, SWD, SED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            break block0;
                        }
                        case SOUTH: {
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWD, SWU, SEU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NED, NWD, NWD, NEU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWD, SEU, NEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            break block0;
                        }
                        case WEST: {
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NED, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SED, NED, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NED, SEU, SED, NED, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWD, SWU, SEU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                        }
                    }
                    break;
                }
                case INNER_RIGHT: {
                    switch (direction) {
                        case NORTH: {
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWD, SWD, NWU, NWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, SWD, SED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SED, SEU, SEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWD, SEU, NEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            break block0;
                        }
                        case EAST: {
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NED, NWD, NWD, NEU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWD, SEU, NEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWD, SWU, SEU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            break block0;
                        }
                        case SOUTH: {
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NED, SEU, SED, NED, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWD, SWU, SEU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NED, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SED, NED, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            break block0;
                        }
                        case WEST: {
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWD, SED, SWU, SWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SED, NED, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, SWD, SED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                        }
                    }
                }
            }
        } else {
            quads.add(ModelHelper.createQuad(NWU, SWU, SEU, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
            block37 : switch (shape) {
                case STRAIGHT: {
                    switch (direction) {
                        case NORTH: {
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SEU, NED, NEU, SEU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SWU, NWU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NED, SEU, SWU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            break;
                        }
                        case EAST: {
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWU, SED, SEU, SWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NWU, NEU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NED, SED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            break;
                        }
                        case SOUTH: {
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWU, SWD, SWU, NWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, NEU, SEU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, SED, SWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            break;
                        }
                        case WEST: {
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NEU, NWD, NWU, NEU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, SEU, SWU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWD, NEU, SEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                        }
                    }
                    break;
                }
                case OUTER_LEFT: {
                    switch (direction) {
                        case NORTH: {
                            quads.add(ModelHelper.createQuadInverted(NEU, NWD, NWU, NEU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SWU, NWU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, SEU, SWU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SEU, NWD, NEU, SEU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            break;
                        }
                        case EAST: {
                            quads.add(ModelHelper.createQuadInverted(SEU, NED, NEU, SEU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NWU, NEU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SWU, NWU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWU, NED, SEU, SWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            break;
                        }
                        case SOUTH: {
                            quads.add(ModelHelper.createQuadInverted(SWU, SED, SEU, SWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, NEU, SEU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NWU, NEU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWU, SED, SWU, NWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            break;
                        }
                        case WEST: {
                            quads.add(ModelHelper.createQuadInverted(NWU, SWD, SWU, NWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, SEU, SWU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, NEU, SEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NEU, SWD, NWU, NEU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                        }
                    }
                    break;
                }
                case OUTER_RIGHT: {
                    switch (direction) {
                        case NORTH: {
                            quads.add(ModelHelper.createQuadInverted(SEU, NED, NEU, SEU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NWU, NEU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SWU, NWU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWU, NED, SEU, SWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            break;
                        }
                        case EAST: {
                            quads.add(ModelHelper.createQuadInverted(SWU, SED, SEU, SWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, NEU, SEU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NWU, NEU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWU, SED, SWU, NWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            break;
                        }
                        case SOUTH: {
                            quads.add(ModelHelper.createQuadInverted(NWU, SWD, SWU, NWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, SEU, SWU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, NEU, SEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NEU, SWD, NWU, NEU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            break;
                        }
                        case WEST: {
                            quads.add(ModelHelper.createQuadInverted(NEU, NWD, NWU, NEU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SWU, NWU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, SEU, SWU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SEU, NWD, NEU, SEU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                        }
                    }
                    break;
                }
                case INNER_LEFT: {
                    switch (direction) {
                        case NORTH: {
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SEU, NED, NEU, SEU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NED, SEU, SWU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, SEU, SWU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWD, NEU, SEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            break;
                        }
                        case EAST: {
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWU, SED, SEU, SWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NED, SED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SWU, NWU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NED, SEU, SWU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            break;
                        }
                        case SOUTH: {
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWU, SWD, SWU, NWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, SED, SWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NWU, NEU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NED, SED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            break;
                        }
                        case WEST: {
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NEU, NWD, NWU, NEU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWD, NEU, SEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, NEU, SEU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, SED, SWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                        }
                    }
                    break;
                }
                case INNER_RIGHT: {
                    switch (direction) {
                        case NORTH: {
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SWU, NWU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NED, SEU, SWU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SWU, SED, SEU, SWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NED, SED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            break block37;
                        }
                        case EAST: {
                            quads.add(ModelHelper.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NWU, NEU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NED, SED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NWU, SWD, SWU, NWU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, SED, SWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            break block37;
                        }
                        case SOUTH: {
                            quads.add(ModelHelper.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, NEU, SEU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, SED, SWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(NEU, NWD, NWU, NEU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWD, NEU, SEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            break block37;
                        }
                        case WEST: {
                            quads.add(ModelHelper.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(SEU, SEU, SWU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NWD, NEU, SEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            quads.add(ModelHelper.createQuadInverted(SEU, NED, NEU, SEU, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            quads.add(ModelHelper.createQuad(NED, SEU, SWU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                        }
                    }
                }
            }
        }
        return quads;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft", "block/oak_planks"));
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }
}

