/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.FrameBlock;
import mod.pianomanu.blockcarpentry.block.SixWaySlabFrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.TwoBlocksFrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class SlabFrameBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockState mimic = (BlockState)extraData.getData(TwoBlocksFrameBlockTile.MIMIC_1);
        if (mimic != null && !(mimic.func_177230_c() instanceof FrameBlock)) {
            ModelResourceLocation location = BlockModelShapes.func_209554_c((BlockState)mimic);
            IBakedModel model = Minecraft.func_71410_x().func_209506_al().func_174953_a(location);
            model.getBakedModel().getQuads(mimic, side, rand, extraData);
            return this.getMimicQuads(state, side, rand, extraData, model);
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> getMimicQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData, IBakedModel model) {
        if (side == null) {
            return Collections.emptyList();
        }
        BlockState mimic_1 = (BlockState)extraData.getData(TwoBlocksFrameBlockTile.MIMIC_1);
        BlockState mimic_2 = (BlockState)extraData.getData(TwoBlocksFrameBlockTile.MIMIC_2);
        int tex_1 = (Integer)extraData.getData(TwoBlocksFrameBlockTile.TEXTURE_1);
        int tex_2 = (Integer)extraData.getData(TwoBlocksFrameBlockTile.TEXTURE_2);
        if (mimic_1 != null && state != null) {
            List<TextureAtlasSprite> textureList_1 = TextureHelper.getTextureFromModel(model, extraData, rand);
            List<Object> textureList_2 = new ArrayList();
            if (mimic_2 != null) {
                ModelResourceLocation location_2 = BlockModelShapes.func_209554_c((BlockState)mimic_2);
                IBakedModel model_2 = Minecraft.func_71410_x().func_209506_al().func_174953_a(location_2);
                textureList_2 = TextureHelper.getTextureFromModel(model_2, extraData, rand);
            }
            if (textureList_1.size() <= tex_1) {
                extraData.setData(TwoBlocksFrameBlockTile.TEXTURE_1, (Object)0);
                tex_1 = 0;
            }
            if (textureList_2.size() <= tex_2) {
                extraData.setData(TwoBlocksFrameBlockTile.TEXTURE_2, (Object)0);
                tex_2 = 0;
            }
            if (textureList_1.size() == 0) {
                if (Minecraft.func_71410_x().field_71439_g != null) {
                    Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("message.blockcarpentry.block_not_available"), true);
                }
                for (int i = 0; i < 6; ++i) {
                    textureList_1.add((TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("missing")));
                }
            }
            TextureAtlasSprite texture_1 = textureList_1.get(tex_1);
            TextureAtlasSprite texture_2 = textureList_2.size() > 0 ? (TextureAtlasSprite)textureList_2.get(tex_2) : null;
            int tintIndex_1 = BlockAppearanceHelper.setTintIndex(mimic_1);
            int tintIndex_2 = mimic_2 == null ? -1 : BlockAppearanceHelper.setTintIndex(mimic_2);
            boolean isDouble = texture_2 != null;
            boolean renderNorth = side == Direction.NORTH && (Boolean)extraData.getData(TwoBlocksFrameBlockTile.NORTH_VISIBLE) != false;
            boolean renderEast = side == Direction.EAST && (Boolean)extraData.getData(TwoBlocksFrameBlockTile.EAST_VISIBLE) != false;
            boolean renderSouth = side == Direction.SOUTH && (Boolean)extraData.getData(TwoBlocksFrameBlockTile.SOUTH_VISIBLE) != false;
            boolean renderWest = side == Direction.WEST && (Boolean)extraData.getData(TwoBlocksFrameBlockTile.WEST_VISIBLE) != false;
            boolean renderUp = side == Direction.UP && (Boolean)extraData.getData(TwoBlocksFrameBlockTile.UP_VISIBLE) != false;
            boolean renderDown = side == Direction.DOWN && (Boolean)extraData.getData(TwoBlocksFrameBlockTile.DOWN_VISIBLE) != false;
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            switch ((Direction)state.func_177229_b((Property)SixWaySlabFrameBlock.FACING)) {
                case UP: {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 0.5f, 0.0f, 1.0f, texture_1, tintIndex_1, renderNorth, renderSouth, renderEast, renderWest, side == Direction.UP, renderDown));
                    break;
                }
                case DOWN: {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.5f, 1.0f, 0.0f, 1.0f, texture_1, tintIndex_1, renderNorth, renderSouth, renderEast, renderWest, renderUp, side == Direction.DOWN));
                    break;
                }
                case WEST: {
                    quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, texture_1, tintIndex_1, renderNorth, renderSouth, renderEast, side == Direction.WEST, renderUp, renderDown));
                    break;
                }
                case SOUTH: {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.5f, texture_1, tintIndex_1, renderNorth, side == Direction.SOUTH, renderEast, renderWest, renderUp, renderDown));
                    break;
                }
                case NORTH: {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.5f, 1.0f, texture_1, tintIndex_1, side == Direction.NORTH, renderSouth, renderEast, renderWest, renderUp, renderDown));
                    break;
                }
                case EAST: {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, 0.0f, 1.0f, 0.0f, 1.0f, texture_1, tintIndex_1, renderNorth, renderSouth, side == Direction.EAST, renderWest, renderUp, renderDown));
                }
            }
            if (((Boolean)state.func_177229_b((Property)SixWaySlabFrameBlock.DOUBLE_SLAB)).booleanValue() && texture_2 != null) {
                switch ((Direction)state.func_177229_b((Property)SixWaySlabFrameBlock.FACING)) {
                    case UP: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.5f, 1.0f, 0.0f, 1.0f, texture_2, tintIndex_2, renderNorth, renderSouth, renderEast, renderWest, renderUp, side == Direction.DOWN));
                        break;
                    }
                    case DOWN: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 0.5f, 0.0f, 1.0f, texture_2, tintIndex_2, renderNorth, renderSouth, renderEast, renderWest, side == Direction.UP, renderDown));
                        break;
                    }
                    case WEST: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, 0.0f, 1.0f, 0.0f, 1.0f, texture_2, tintIndex_2, renderNorth, renderSouth, side == Direction.EAST, renderWest, renderUp, renderDown));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.5f, 1.0f, texture_2, tintIndex_2, side == Direction.NORTH, renderSouth, renderEast, renderWest, renderUp, renderDown));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.5f, texture_2, tintIndex_2, renderNorth, side == Direction.SOUTH, renderEast, renderWest, renderUp, renderDown));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, texture_2, tintIndex_2, renderNorth, renderSouth, renderEast, side == Direction.WEST, renderUp, renderDown));
                    }
                }
            }
            int overlayIndex_1 = (Integer)extraData.getData(TwoBlocksFrameBlockTile.OVERLAY_1);
            if ((Integer)extraData.getData(TwoBlocksFrameBlockTile.OVERLAY_1) != 0) {
                switch ((Direction)state.func_177229_b((Property)SixWaySlabFrameBlock.FACING)) {
                    case UP: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 0.5f, 0.0f, 1.0f, overlayIndex_1, renderWest, renderEast, renderSouth, renderNorth, renderUp, renderDown, false));
                        break;
                    }
                    case DOWN: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.5f, 1.0f, 0.0f, 1.0f, overlayIndex_1, renderWest, renderEast, renderSouth, renderNorth, renderUp, renderDown, false));
                        break;
                    }
                    case WEST: {
                        quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex_1, renderWest, renderEast, renderSouth, renderNorth, renderUp, renderDown, false));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.5f, overlayIndex_1, renderWest, renderEast, renderSouth, renderNorth, renderUp, renderDown, false));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.5f, 1.0f, overlayIndex_1, renderWest, renderEast, renderSouth, renderNorth, renderUp, renderDown, false));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex_1, renderWest, renderEast, renderSouth, renderNorth, renderUp, renderDown, false));
                    }
                }
            }
            if (((Boolean)state.func_177229_b((Property)SixWaySlabFrameBlock.DOUBLE_SLAB)).booleanValue()) {
                int overlayIndex_2 = (Integer)extraData.getData(TwoBlocksFrameBlockTile.OVERLAY_2);
                if ((Integer)extraData.getData(TwoBlocksFrameBlockTile.OVERLAY_2) != 0) {
                    switch ((Direction)state.func_177229_b((Property)SixWaySlabFrameBlock.FACING)) {
                        case UP: {
                            quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.5f, 1.0f, 0.0f, 1.0f, overlayIndex_2, renderWest, renderEast, renderSouth, renderNorth, renderUp, renderDown, false));
                            break;
                        }
                        case DOWN: {
                            quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 0.5f, 0.0f, 1.0f, overlayIndex_2, renderWest, renderEast, renderSouth, renderNorth, renderUp, renderDown, false));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex_2, renderWest, renderEast, renderSouth, renderNorth, renderUp, renderDown, false));
                            break;
                        }
                        case SOUTH: {
                            quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.5f, 1.0f, overlayIndex_2, renderWest, renderEast, renderSouth, renderNorth, renderUp, renderDown, false));
                            break;
                        }
                        case NORTH: {
                            quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.5f, overlayIndex_2, renderWest, renderEast, renderSouth, renderNorth, renderUp, renderDown, false));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex_2, renderWest, renderEast, renderSouth, renderNorth, renderUp, renderDown, false));
                        }
                    }
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.getTexture();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }
}

