/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.FrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class FrameBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        Integer design = (Integer)extraData.getData(FrameBlockTile.DESIGN);
        Integer desTex = (Integer)extraData.getData(FrameBlockTile.DESIGN_TEXTURE);
        if (side == null) {
            return Collections.emptyList();
        }
        if (mimic != null && !(mimic.func_177230_c() instanceof FrameBlock)) {
            ModelResourceLocation location = BlockModelShapes.func_209554_c((BlockState)mimic);
            if (state != null) {
                IBakedModel model = Minecraft.func_71410_x().func_209506_al().func_174953_a(location);
                List<TextureAtlasSprite> textureList = TextureHelper.getTextureFromModel(model, extraData, rand);
                Integer tex = (Integer)extraData.getData(FrameBlockTile.TEXTURE);
                if (textureList.size() <= tex) {
                    extraData.setData(FrameBlockTile.TEXTURE, (Object)0);
                    tex = 0;
                }
                if (textureList.size() == 0) {
                    if (Minecraft.func_71410_x().field_71439_g != null) {
                        Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("message.blockcarpentry.block_not_available"), true);
                    }
                    for (int i = 0; i < 6; ++i) {
                        textureList.add((TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("missing")));
                    }
                }
                TextureAtlasSprite texture = textureList.get(tex);
                boolean renderNorth = side == Direction.NORTH && (Boolean)extraData.getData(FrameBlockTile.NORTH_VISIBLE) != false;
                boolean renderEast = side == Direction.EAST && (Boolean)extraData.getData(FrameBlockTile.EAST_VISIBLE) != false;
                boolean renderSouth = side == Direction.SOUTH && (Boolean)extraData.getData(FrameBlockTile.SOUTH_VISIBLE) != false;
                boolean renderWest = side == Direction.WEST && (Boolean)extraData.getData(FrameBlockTile.WEST_VISIBLE) != false;
                boolean renderUp = side == Direction.UP && (Boolean)extraData.getData(FrameBlockTile.UP_VISIBLE) != false;
                boolean renderDown = side == Direction.DOWN && (Boolean)extraData.getData(FrameBlockTile.DOWN_VISIBLE) != false;
                int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, texture, tintIndex, renderNorth, renderSouth, renderEast, renderWest, renderUp, renderDown));
                int overlayIndex = (Integer)extraData.getData(FrameBlockTile.OVERLAY);
                if (overlayIndex != 0) {
                    quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex, true, true, renderEast, renderWest, renderUp, renderDown, true));
                }
                return quads;
            }
        }
        return Collections.emptyList();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.getTexture();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }
}

