/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.item.ItemMod;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.common.core.PsiCreativeTab;
import vazkii.psi.common.item.base.IHUDItem;
import vazkii.psi.common.item.base.IPsiItem;

public class ItemVectorRuler
extends ItemMod
implements IHUDItem,
IPsiItem {
    private static final String TAG_SRC_X = "srcX";
    private static final String TAG_SRC_Y = "srcY";
    private static final String TAG_SRC_Z = "srcZ";
    private static final String TAG_DST_X = "dstX";
    private static final String TAG_DST_Y = "dstY";
    private static final String TAG_DST_Z = "dstZ";

    public ItemVectorRuler() {
        super("vector_ruler", new String[0]);
        this.func_77625_d(1);
        this.func_77637_a(PsiCreativeTab.INSTANCE);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        int srcY = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_SRC_Y, (int)-1);
        if (srcY == -1 || playerIn.func_70093_af()) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_SRC_X, (int)pos.func_177958_n());
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_SRC_Y, (int)pos.func_177956_o());
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_SRC_Z, (int)pos.func_177952_p());
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_DST_Y, (int)-1);
        } else {
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_DST_X, (int)pos.func_177958_n());
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_DST_Y, (int)pos.func_177956_o());
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_DST_Z, (int)pos.func_177952_p());
        }
        return EnumActionResult.SUCCESS;
    }

    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(this.getVector(stack).toString());
    }

    public Vector3 getVector(ItemStack stack) {
        int srcX = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_SRC_X, (int)0);
        int srcY = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_SRC_Y, (int)0);
        int srcZ = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_SRC_Z, (int)0);
        int dstY = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_DST_Y, (int)-1);
        if (dstY == -1) {
            return new Vector3(srcX, srcY, srcZ);
        }
        int dstX = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_DST_X, (int)0);
        int dstZ = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_DST_Z, (int)0);
        return new Vector3(dstX - srcX, dstY - srcY, dstZ - srcZ);
    }

    public static Vector3 getRulerVector(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemVectorRuler)) continue;
            return ((ItemVectorRuler)stack.func_77973_b()).getVector(stack);
        }
        return Vector3.zero;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawHUD(ScaledResolution res, float partTicks, ItemStack stack) {
        String s = this.getVector(stack).toString();
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int w = font.func_78256_a(s);
        font.func_175063_a(s, (float)res.func_78326_a() / 2.0f - (float)w / 2.0f, (float)res.func_78328_b() / 2.0f + 10.0f, -1);
    }
}

