/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.DefaultStaleable;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.User;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public class DefaultUser
extends DefaultStaleable
implements User {
    private final String account;
    private final String awayMessage;
    private final Set<String> channels;
    private final String host;
    private final boolean isAway;
    private final String nick;
    private final String operString;
    private final String realName;
    private final String server;
    private final String user;

    public DefaultUser(@Nonnull Client.WithManagement client, @Nonnull String name, @Nullable String account, @Nullable String awayMessage, @Nonnull String nick, @Nonnull String user, @Nonnull String host, boolean isAway, @Nullable String operString, @Nullable String realName, @Nullable String server, @Nonnull Set<String> channels) {
        super(client, name);
        this.account = account;
        this.awayMessage = awayMessage;
        this.nick = nick;
        this.user = user;
        this.host = host;
        this.isAway = isAway;
        this.operString = operString;
        this.realName = realName;
        this.server = server;
        this.channels = Collections.unmodifiableSet(channels);
    }

    public boolean equals(Object o) {
        return o instanceof DefaultUser && ((DefaultUser)o).getClient() == this.getClient() && ((DefaultUser)o).getLowerCaseName().equals(this.getLowerCaseName());
    }

    @Override
    @Nonnull
    public Optional<String> getAccount() {
        return Optional.ofNullable(this.account);
    }

    @Override
    @Nonnull
    public Optional<String> getAwayMessage() {
        return Optional.ofNullable(this.awayMessage);
    }

    @Override
    @Nonnull
    public Set<String> getChannels() {
        return this.channels;
    }

    @Override
    @Nonnull
    public String getHost() {
        return this.host;
    }

    @Override
    @Nonnull
    public String getMessagingName() {
        return this.getNick();
    }

    @Override
    @Nonnull
    public String getNick() {
        return this.nick;
    }

    @Override
    @Nonnull
    public Optional<String> getOperatorInformation() {
        return Optional.ofNullable(this.operString);
    }

    @Override
    @Nonnull
    public Optional<String> getRealName() {
        return Optional.ofNullable(this.realName);
    }

    @Override
    @Nonnull
    public Optional<String> getServer() {
        return Optional.ofNullable(this.server);
    }

    @Override
    @Nonnull
    public String getUserString() {
        return this.user;
    }

    public int hashCode() {
        return this.getLowerCaseName().hashCode() * 2 + this.getClient().hashCode();
    }

    @Override
    public boolean isAway() {
        return this.isAway;
    }

    @Override
    @Nonnull
    public String toString() {
        return new ToStringer(this).add("client", this.getClient()).add("nick", this.nick).add("user", this.user).add("host", this.host).add("channels", this.channels.size()).toString();
    }
}

