/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.tcomplement;

import com.blamejared.ModTweaker;
import com.blamejared.compat.tconstruct.recipes.MeltingRecipeTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.LinkedList;
import java.util.List;
import knightminer.tcomplement.library.IBlacklist;
import knightminer.tcomplement.library.TCompRegistry;
import knightminer.tcomplement.library.events.TCompRegisterEvent;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.mantle.util.RecipeMatch;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.tcomplement.Blacklist")
@ZenRegister
@ModOnly(value="tcomplement")
public class Blacklist {
    public static final List<IItemStack> REMOVED_RECIPES = new LinkedList<IItemStack>();
    private static boolean init = false;

    private static void init() {
        if (!init) {
            MinecraftForge.EVENT_BUS.register((Object)new Blacklist());
            init = true;
        }
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack output, IItemStack input) {
        Blacklist.init();
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toFluid((ILiquidStack)output), InputHelper.toStack((IItemStack)input)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        Blacklist.init();
        CraftTweakerAPI.apply((IAction)new Remove(input));
    }

    @SubscribeEvent
    public void onTinkerRegister(TCompRegisterEvent.MelterBlackListRegisterEvent event) {
        if (event.getRecipe() instanceof MeltingRecipeTweaker) {
            return;
        }
        for (IItemStack ent : REMOVED_RECIPES) {
            if (!((IBlacklist)event.getRecipe()).matches(InputHelper.toStack((IItemStack)ent))) continue;
            event.setCanceled(true);
        }
    }

    private static class Remove
    extends BaseAction {
        private IItemStack input;

        protected Remove(IItemStack input) {
            super("Blacklist");
            this.input = input;
        }

        public void apply() {
            REMOVED_RECIPES.add(this.input);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((IIngredient)this.input);
        }
    }

    private static class Add
    extends BaseAction {
        private FluidStack output;
        private ItemStack input;

        public Add(FluidStack output, ItemStack input) {
            super("Blacklist");
            this.output = output;
            this.input = input;
        }

        public void apply() {
            TCompRegistry.registerMelterBlacklist((RecipeMatch)RecipeMatch.of((ItemStack)this.input, (int)this.output.amount));
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((FluidStack)this.output);
        }
    }
}

