/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.ModConfig;
import net.blay09.mods.cookingforblockheads.ModSounds;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenSmeltingProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenSmeltingProvider;
import net.blay09.mods.cookingforblockheads.api.capability.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.block.BlockOven;
import net.blay09.mods.cookingforblockheads.network.VanillaPacketHandler;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.DoorAnimator;
import net.blay09.mods.cookingforblockheads.tile.EnergyStorageModifiable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;
import org.apache.commons.lang3.ArrayUtils;

@Optional.Interface(iface="blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler$IExternalHeatable", modid="immersiveengineering")
public class TileOven
extends TileEntity
implements ITickable,
IKitchenSmeltingProvider,
ExternalHeaterHandler.IExternalHeatable {
    private static final int COOK_TIME = 200;
    private final ItemStackHandler itemHandler = new ItemStackHandler(20){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot < 3 ? TileOven.getSmeltingResult(stack).func_190926_b() : slot == 3 && !TileOven.isItemFuel(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        protected void onContentsChanged(int slot) {
            if (slot >= 7 && slot < 16) {
                TileOven.this.slotCookTime[slot - 7] = 0;
            }
            TileOven.this.isDirty = true;
            TileOven.this.func_70296_d();
        }
    };
    private EnergyStorageModifiable energyStorage = new EnergyStorageModifiable(10000){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!simulate) {
                TileOven.this.func_70296_d();
            }
            return super.receiveEnergy(maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!simulate) {
                TileOven.this.func_70296_d();
            }
            return super.extractEnergy(maxExtract, simulate);
        }
    };
    private final RangedWrapper itemHandlerInput = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 0, 3);
    private final RangedWrapper itemHandlerFuel = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 3, 4);
    private final RangedWrapper itemHandlerOutput = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 4, 7);
    private final RangedWrapper itemHandlerProcessing = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 7, 16);
    private final RangedWrapper itemHandlerTools = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 16, 20);
    private final KitchenItemProvider itemProvider = new KitchenItemProvider((IItemHandler)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandlerTools, this.itemHandlerOutput}));
    private final DoorAnimator doorAnimator = new DoorAnimator(this, 1, 2);
    private boolean isFirstTick = true;
    public int[] slotCookTime = new int[9];
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    private boolean isDirty;
    private boolean hasPowerUpgrade;
    private EnumFacing facing;

    public TileOven() {
        this.doorAnimator.setSoundEventOpen(ModSounds.ovenOpen);
        this.doorAnimator.setSoundEventClose(ModSounds.ovenClose);
    }

    public boolean func_145842_c(int id, int type) {
        return this.doorAnimator.receiveClientEvent(id, type) || super.func_145842_c(id, type);
    }

    public void func_73660_a() {
        if (this.isFirstTick) {
            this.facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockOven.FACING);
            this.isFirstTick = false;
        }
        this.doorAnimator.update();
        if (this.isDirty) {
            VanillaPacketHandler.sendTileEntityUpdate(this);
            this.isDirty = false;
        }
        boolean hasChanged = false;
        int burnPotential = 200 - this.furnaceBurnTime;
        if (this.hasPowerUpgrade && burnPotential > 0 && this.shouldConsumeFuel()) {
            this.furnaceBurnTime += this.energyStorage.extractEnergy(burnPotential, false);
        }
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemStack;
            if (this.furnaceBurnTime == 0 && this.shouldConsumeFuel()) {
                for (int i = 0; i < this.itemHandlerFuel.getSlots(); ++i) {
                    ItemStack fuelItem = this.itemHandlerFuel.getStackInSlot(i);
                    if (fuelItem.func_190926_b()) continue;
                    this.currentItemBurnTime = this.furnaceBurnTime = (int)Math.max(1.0f, (float)TileOven.getItemBurnTime(fuelItem) * ModConfig.general.ovenFuelTimeMultiplier);
                    if (this.furnaceBurnTime == 0) break;
                    fuelItem.func_190918_g(1);
                    if (fuelItem.func_190916_E() == 0) {
                        this.itemHandlerFuel.setStackInSlot(i, fuelItem.func_77973_b().getContainerItem(fuelItem));
                    }
                    hasChanged = true;
                    break;
                }
            }
            int firstEmptySlot = -1;
            int firstTransferSlot = -1;
            for (int i = 0; i < this.itemHandlerProcessing.getSlots(); ++i) {
                itemStack = this.itemHandlerProcessing.getStackInSlot(i);
                if (!itemStack.func_190926_b()) {
                    if (this.slotCookTime[i] != -1) {
                        ItemStack resultStack;
                        if (this.furnaceBurnTime > 0) {
                            int n = i;
                            this.slotCookTime[n] = this.slotCookTime[n] + 1;
                        }
                        if (!((float)this.slotCookTime[i] >= 200.0f * ModConfig.general.ovenCookTimeMultiplier) || (resultStack = TileOven.getSmeltingResult(itemStack)).func_190926_b()) continue;
                        this.itemHandlerProcessing.setStackInSlot(i, resultStack.func_77946_l());
                        this.slotCookTime[i] = -1;
                        if (firstTransferSlot != -1) continue;
                        firstTransferSlot = i;
                        continue;
                    }
                    if (firstTransferSlot != -1) continue;
                    firstTransferSlot = i;
                    continue;
                }
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
            }
            if (firstTransferSlot != -1) {
                ItemStack transferStack = this.itemHandlerProcessing.getStackInSlot(firstTransferSlot);
                transferStack = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandlerOutput, (ItemStack)transferStack, (boolean)false);
                this.itemHandlerProcessing.setStackInSlot(firstTransferSlot, transferStack);
                if (transferStack.func_190926_b()) {
                    this.slotCookTime[firstTransferSlot] = 0;
                }
                hasChanged = true;
            }
            if (firstEmptySlot != -1) {
                for (int j = 0; j < this.itemHandlerInput.getSlots(); ++j) {
                    itemStack = this.itemHandlerInput.getStackInSlot(j);
                    if (itemStack.func_190926_b()) continue;
                    this.itemHandlerProcessing.setStackInSlot(firstEmptySlot, itemStack.func_77979_a(1));
                    if (itemStack.func_190916_E() > 0) break;
                    this.itemHandlerInput.setStackInSlot(j, ItemStack.field_190927_a);
                    break;
                }
            }
        }
        if (hasChanged) {
            this.func_70296_d();
        }
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getEnergyCapacity() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public static ItemStack getSmeltingResult(ItemStack itemStack) {
        ItemStack result = CookingRegistry.getSmeltingResult(itemStack);
        if (!result.func_190926_b()) {
            return result;
        }
        result = FurnaceRecipes.func_77602_a().func_151395_a(itemStack);
        if (!result.func_190926_b() && result.func_77973_b() instanceof ItemFood) {
            return result;
        }
        if (!result.func_190926_b() && CookingRegistry.isNonFoodRecipe(result)) {
            return result;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isItemFuel(ItemStack itemStack) {
        return TileOven.getItemBurnTime(itemStack) > 0;
    }

    public static int getItemBurnTime(ItemStack fuelItem) {
        int fuelTime = CookingRegistry.getOvenFuelTime(fuelItem);
        if (fuelTime != 0 || ModConfig.compat.ovenRequiresCookingOil) {
            return fuelTime;
        }
        return TileEntityFurnace.func_145952_a((ItemStack)fuelItem);
    }

    private boolean shouldConsumeFuel() {
        for (int i = 0; i < this.itemHandlerProcessing.getSlots(); ++i) {
            ItemStack cookingStack = this.itemHandlerProcessing.getStackInSlot(i);
            if (cookingStack.func_190926_b() || this.slotCookTime[i] == -1) continue;
            return true;
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.itemHandler.deserializeNBT(tagCompound.func_74775_l("ItemHandler"));
        this.furnaceBurnTime = tagCompound.func_74765_d("BurnTime");
        this.currentItemBurnTime = tagCompound.func_74765_d("CurrentItemBurnTime");
        this.slotCookTime = tagCompound.func_74759_k("CookTimes");
        this.hasPowerUpgrade = tagCompound.func_74767_n("HasPowerUpgrade");
        this.energyStorage.setEnergyStored(tagCompound.func_74762_e("EnergyStored"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74782_a("ItemHandler", (NBTBase)this.itemHandler.serializeNBT());
        tagCompound.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        tagCompound.func_74777_a("CurrentItemBurnTime", (short)this.currentItemBurnTime);
        tagCompound.func_74783_a("CookTimes", ArrayUtils.clone((int[])this.slotCookTime));
        tagCompound.func_74757_a("HasPowerUpgrade", this.hasPowerUpgrade);
        tagCompound.func_74768_a("EnergyStored", this.energyStorage.getEnergyStored());
        return tagCompound;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_189515_b(tagCompound);
        tagCompound.func_74757_a("IsForcedOpen", this.doorAnimator.isForcedOpen());
        tagCompound.func_74774_a("NumPlayersUsing", (byte)this.doorAnimator.getNumPlayersUsing());
        return tagCompound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
        this.doorAnimator.setForcedOpen(pkt.func_148857_g().func_74767_n("IsForcedOpen"));
        this.doorAnimator.setNumPlayersUsing(pkt.func_148857_g().func_74771_c("NumPlayersUsing"));
    }

    public boolean hasPowerUpgrade() {
        return this.hasPowerUpgrade;
    }

    public void setHasPowerUpgrade(boolean hasPowerUpgrade) {
        this.hasPowerUpgrade = hasPowerUpgrade;
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), state, state, 3);
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public float getBurnTimeProgress() {
        if (this.currentItemBurnTime == 0 && this.furnaceBurnTime > 0) {
            return 1.0f;
        }
        return (float)this.furnaceBurnTime / (float)this.currentItemBurnTime;
    }

    public float getCookProgress(int i) {
        return (float)this.slotCookTime[i] / (200.0f * ModConfig.general.ovenCookTimeMultiplier);
    }

    @Override
    public ItemStack smeltItem(ItemStack itemStack) {
        return ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandlerInput, (ItemStack)itemStack, (boolean)false);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public DoorAnimator getDoorAnimator() {
        return this.doorAnimator;
    }

    public ItemStack getToolItem(int i) {
        return this.itemHandlerTools.getStackInSlot(i);
    }

    public void setToolItem(int i, ItemStack itemStack) {
        this.itemHandlerTools.setStackInSlot(i, itemStack);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.hasPowerUpgrade && capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityKitchenSmeltingProvider.CAPABILITY || capability == CapabilityKitchenItemProvider.CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)this.itemHandler;
            }
            if (!ModConfig.general.disallowOvenAutomation) {
                switch (facing) {
                    case UP: {
                        return (T)this.itemHandlerInput;
                    }
                    case DOWN: {
                        return (T)this.itemHandlerOutput;
                    }
                }
                return (T)this.itemHandlerFuel;
            }
        }
        if (this.hasPowerUpgrade && capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.energyStorage);
        }
        if (capability == CapabilityKitchenItemProvider.CAPABILITY) {
            return (T)this.itemProvider;
        }
        if (capability == CapabilityKitchenSmeltingProvider.CAPABILITY) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }

    public IItemHandler getInputHandler() {
        return this.itemHandlerInput;
    }

    public RangedWrapper getItemHandlerFuel() {
        return this.itemHandlerFuel;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (oldState.func_177230_c() == newState.func_177230_c()) {
            this.facing = (EnumFacing)newState.func_177229_b((IProperty)BlockOven.FACING);
            return false;
        }
        return true;
    }

    public int doHeatTick(int energyAvailable, boolean redstone) {
        int energyConsumed = 0;
        boolean canCook = this.shouldConsumeFuel();
        if (canCook || redstone) {
            int energyToUse;
            int heatEnergyRatio;
            int heatAttempt;
            int energyToUse2;
            int heat;
            boolean burning = this.isBurning();
            if (this.furnaceBurnTime < 200 && (heat = (energyToUse2 = Math.min(energyAvailable, (heatAttempt = 4) * (heatEnergyRatio = (int)Math.max(1.0f, (float)ExternalHeaterHandler.defaultFurnaceEnergyCost * ModConfig.general.ovenFuelTimeMultiplier)))) / heatEnergyRatio) > 0) {
                this.furnaceBurnTime += heat;
                energyConsumed += heat * heatEnergyRatio;
                if (!burning) {
                    this.isDirty = true;
                }
            }
            if (canCook && this.furnaceBurnTime >= 200 && energyAvailable - energyConsumed > (energyToUse = ExternalHeaterHandler.defaultFurnaceSpeedupCost * 9)) {
                for (int i = 0; i < this.slotCookTime.length; ++i) {
                    if (this.slotCookTime[i] == -1) continue;
                    int n = i;
                    this.slotCookTime[n] = this.slotCookTime[n] + 1;
                }
                energyConsumed += energyToUse;
            }
        }
        return energyConsumed;
    }

    public EnumFacing getFacing() {
        if (this.facing == null) {
            return EnumFacing.NORTH;
        }
        return this.facing;
    }
}

