/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.sync.packets;

import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import p455w0rd.wct.api.IWCTContainer;
import p455w0rd.wct.client.gui.GuiWCT;
import p455w0rd.wct.init.ModGuiHandler;
import p455w0rd.wct.sync.WCTPacket;
import p455w0rd.wct.sync.network.INetworkInfo;

public class PacketSwitchGuis
extends WCTPacket {
    private final int newGui;

    public PacketSwitchGuis(ByteBuf stream) {
        this.newGui = stream.readInt();
    }

    public PacketSwitchGuis(int newGui) {
        this.newGui = newGui;
        if (Platform.isClient()) {
            GuiWCT.setSwitchingGuis((boolean)true);
        }
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(newGui);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, WCTPacket packet, EntityPlayer player) {
        World world = player.func_130014_f_();
        int x = (int)player.field_70165_t;
        int y = (int)player.field_70163_u;
        int z = (int)player.field_70161_v;
        Container c = player.field_71070_bA;
        boolean isBauble = false;
        boolean isHeld = false;
        int slot = -1;
        if (c instanceof IWCTContainer) {
            IWCTContainer wctContainer = (IWCTContainer)c;
            isBauble = wctContainer.isWTBauble();
            slot = wctContainer.getWTSlot();
            isHeld = wctContainer.isMagnetHeld();
        }
        ModGuiHandler.open(this.newGui, player, world, new BlockPos(x, y, z), isHeld, isBauble, slot);
    }

    @Override
    public void clientPacketData(INetworkInfo network, WCTPacket packet, EntityPlayer player) {
        GuiWCT.setSwitchingGuis((boolean)true);
    }
}

