/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.client.PktPlayerStatus;
import java.util.EnumSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerActivityManager
implements ITickHandler {
    private static final long INACTIVITY_MS = 300000L;
    public static final PlayerActivityManager INSTANCE = new PlayerActivityManager();
    private Map<UUID, Boolean> serverActivityMap = Maps.newHashMap();
    private long clientInteractMs = -1L;
    private boolean clientActive = true;
    private boolean up = false;
    private boolean down = false;
    private boolean left = false;
    private boolean right = false;

    private PlayerActivityManager() {
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        this.handleClientTick();
    }

    @SideOnly(value=Side.CLIENT)
    private void handleClientTick() {
        if (this.clientInteractMs == -1L) {
            this.clientInteractMs = System.currentTimeMillis();
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        this.checkMs();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKeyIn(InputEvent.KeyInputEvent event) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        GameSettings gs = Minecraft.func_71410_x().field_71474_y;
        if (this.up && gs.field_74351_w.func_151470_d()) {
            return;
        }
        this.up = gs.field_74351_w.func_151470_d();
        if (this.down && gs.field_74368_y.func_151470_d()) {
            return;
        }
        this.down = gs.field_74368_y.func_151470_d();
        if (this.left && gs.field_74370_x.func_151470_d()) {
            return;
        }
        this.left = gs.field_74370_x.func_151470_d();
        if (this.right && gs.field_74366_z.func_151470_d()) {
            return;
        }
        this.right = gs.field_74366_z.func_151470_d();
        if (this.up || this.down || this.left || this.right) {
            this.clientInteractMs = System.currentTimeMillis();
            if (!this.clientActive) {
                this.clientActive = true;
                PktPlayerStatus pkt = new PktPlayerStatus(Minecraft.func_71410_x().field_71439_g.func_110124_au(), true);
                PacketChannel.CHANNEL.sendToServer((IMessage)pkt);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void checkMs() {
        if (System.currentTimeMillis() - this.clientInteractMs > 300000L) {
            this.clientInteractMs = System.currentTimeMillis();
            this.clientActive = false;
            PktPlayerStatus pkt = new PktPlayerStatus(Minecraft.func_71410_x().field_71439_g.func_110124_au(), false);
            PacketChannel.CHANNEL.sendToServer((IMessage)pkt);
        }
    }

    public void setStatusServer(UUID playerUUID, boolean active) {
        this.serverActivityMap.put(playerUUID, active);
    }

    public boolean isPlayerActiveServer(EntityPlayer player) {
        return this.isPlayerActiveServer(player.func_110124_au());
    }

    public boolean isPlayerActiveServer(UUID playerUUID) {
        return this.serverActivityMap.getOrDefault(playerUUID, true);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isPlayerActiveClient() {
        return this.clientActive;
    }

    public void clearCache(Side side) {
        if (side == Side.CLIENT) {
            this.clientInteractMs = -1L;
            this.clientActive = true;
            this.up = false;
            this.down = false;
            this.left = false;
            this.right = false;
        } else {
            this.serverActivityMap.clear();
        }
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.CLIENT);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "Player Activity Manager";
    }
}

